//
//  AdvanceSearchView.h
//  Extension
//
//  Created by AndrewLai on 2018/3/2.
//

#import <UIKit/UIKit.h>

//Define
#import "AdvanceSearchViewDataSource.h"
#import "AdvanceSearchViewDelegate.h"

//View
#import "PPTableView.h"
#import "ContactKeyboardToolBarView.h"
#import "PPTextFieldTableViewCell.h"
#import "PPPhoneTextFieldTableViewCell.h"
#import "SearchPhoneTextFieldTableViewCell.h"
#import "SearchNumberTextFieldTableViewCell.h"
#import "SearchPicklistChoiceTableViewCell.h"
#import "SearchTextFieldTableViewCell.h"
#import "SearchDateAndTimeTextFieldTableViewCell.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - AdvanceSearchView Interface

@interface AdvanceSearchView : UIView
<
SearchDateAndTimeTextFieldTableViewCellDelegate,
SearchTextFieldTableViewCellDelegate,
SearchPhoneTextFieldTableViewCellDelegate,
SearchPicklistChoiceTableViewCellDelegate,
SearchNumberTextFieldTableViewCellDelegate,
ContactKeyboardToolBarViewDelegate,
PPTextFieldTableViewCellDelegate,
PPPhoneTextFieldTableViewCellDelegate,
UITableViewDelegate,
UITableViewDataSource
>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic, assign)   id<AdvanceSearchViewDataSource> dataSource;
@property (nonatomic, assign)   id<AdvanceSearchViewDelegate>   delegate;
@property (nonatomic, readonly) PPTableView                     *advanceSearchTableView;

@end
