//
//  WCABItemSelectFlowController.h
//
//
//  Created by Howard on 2015/7/28.
//
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

// Define
#import "WCDisplayNameDefine.h"
#import "WCABItemSelectFlowControllerDelegate.h"

// Model
#import "WCABGroupModel.h"

// Controller
#import "PPIndexSectionController.h"

// Category
#import "WCABItemSelectFlowController+ParameterDefine.h"


/// 是否顯示匯出系統聯絡人的限制提示
extern NSString *const WCABItemSelectFlowController_SettingsKey_ShowExportLimitationAlert;

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCABItemSelectFlowController : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign) id<WCABItemSelectFlowControllerDelegate> abSelectFlowControllerDelegate;
@property (nonatomic,assign,readonly) WCABItemSelectFlowControllerMode abSelectFlowControllerMode;

//預設英文
@property (nonatomic,assign) PPIndexSectionControllerStyle        indexSectionControllerStyle;

@property (nonatomic,assign) WCDisplayNameOrder eastDisplayNameOrder;
@property (nonatomic,assign) WCDisplayNameOrder westDisplayNameOrder;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

+ (instancetype)sharedInstance;

/**
 *  顯示連絡人群組頁面
 *
 *  @param abSelectFlowControllerMode     模式
 *  @param abSelectFlowControllerDelegate 委托
 *  @param superViewController            來源視圖
 *  @param syncAccountName                同步帳號名稱
 *
 */
+ (void)showGroupViewControllerWithABSelectFlowControllerMode:(WCABItemSelectFlowControllerMode)abSelectFlowControllerMode
                               abSelectFlowControllerDelegate:(id<WCABItemSelectFlowControllerDelegate>)abSelectFlowControllerDelegate
                                              syncAccountName:(NSString *)syncAccountName
                                      fromSuperViewController:(UIViewController *)superViewController;

@end
