#include <stdio.h>
#ifdef __ANDROID__
#include "../PPFileIo.h"
#elif defined __OBJECTIVEC__
#include "./PPFileIo.h"
#else
#include "PPFileIo_WinAnsi.h"
#endif

#define PPWCXF_BUFFER_SIZE	8192


CPPFileIo::CPPFileIo()
{
    m_outputDebugFileName = NULL;
}

CPPFileIo::~CPPFileIo()
{
    
}


void *CPPFileIo::OpenFile(char *fileName,const char *openMode)
{
    FILE *fp;
    
    fp = fopen(fileName,openMode);
    
    return fp;
}


int  CPPFileIo::CloseFile(void *fp)
{
    FILE *fp1 = (FILE *)fp;
    
    return fclose(fp1);
}

long CPPFileIo::GetFilePos(void *fp)
{
    FILE *fp1 = (FILE *)fp;
    
    return ftell(fp1);
}


int CPPFileIo::FileSeek(void *fp,long sd,int spos)
{
    FILE *fp1 = (FILE *)fp;
    
    return fseek(fp1,sd,spos);
}


unsigned int CPPFileIo::ReadFile(void *fp,void *Buffer,int iEsz,int iCount)
{
    FILE *fp1 = (FILE *)fp;
    
    if (fp1 != 0)
    {
        return (unsigned int)fread(Buffer,iEsz,iCount,fp1);
    }
    return 0;
}

unsigned int CPPFileIo::WriteFile(void *fp,void *Buffer,int iEsz,int iCount)
{
    FILE *fp1 = (FILE *)fp;
    
    if (fp1 != 0)
    {
        return (unsigned int)fwrite(Buffer,iEsz,iCount,fp1);
    }
    return 0;
}

void CPPFileIo::PPOutputDebugString(const char *inStrP)
{
    PPCStringW oneStrW;
    oneStrW = inStrP;
#ifdef __OBJECTIVEC__
    PPOutputDebugString_Base(oneStrW);
#else
    PPOutputDebugString(oneStrW);
#endif
}

void CPPFileIo::PPOutputDebugString(PPWCHAR *inStrP)
{
    PPCStringW oneStrW;
    oneStrW = inStrP;
    
#ifdef __OBJECTIVEC__
    PPOutputDebugString_Base(oneStrW);
#else
    PPOutputDebugString(oneStrW);
#endif
}

#if defined __OBJECTIVEC__
void CPPFileIo::PPOutputDebugString_Base(PPCStringW inStr)
#else
void CPPFileIo::PPOutputDebugString(PPCStringW inStr)
#endif
{
    FILE *fp;
    int iOffset;
    PPBYTE BBB[4096];
    char *fileName = (char *)DEF_LOG_PATH;

    if(m_outputDebugFileName)
    {
        fileName = m_outputDebugFileName;
    }
    
    fp = fopen(fileName,"a+b");
    
    if (fp != 0)
    {
        fseek(fp,0,SEEK_END);
        iOffset = (int)ftell(fp);
        
        if (iOffset == 0)
        {
            fclose(fp);
            fp = fopen(fileName,"wb");
            
            if (fp != 0)
            {
                BBB[0] = 0xFF;
                BBB[1] = 0xFE;
                fwrite(BBB,1,2,fp);
                fclose(fp);
                fp = fopen(fileName,"a+b");
                fseek(fp,0,SEEK_END);
            }
        }
        
        fwrite((char*)inStr.GetBuffer(),1,inStr.GetLength()*sizeof(PPWCHAR),fp);
        fclose(fp);
    }
}

int CPPFileIo::CreateFileByBuffer(char *tmpFile,PPBYTE *Buffer,int iLen)
{
    FILE *fp;
    int iRetV = 0;
    
    
    fp = fopen(tmpFile,"wb");
    if (fp != 0) 
    {
        if (fwrite(Buffer,sizeof(PPBYTE),iLen,fp) == iLen)
        {
            iRetV = 1;
        }
        fclose(fp);
    }
    return iRetV;
}
