//
//  PPWebSocketController.h
//  Example
//
//  Created by AndrewLai on 2016/3/15.
//  Copyright © 2016年 penpower. All rights reserved.
//

#import <Foundation/Foundation.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPWebSocketControllerDelegate

@class  PPWebSocketController;
@protocol PPWebSocketControllerDelegate <NSObject>

/**
 *  告知外部已連接上Server
 *
 *  @param webSocketController PPWebSocketController Object
 */
- (void)webSocketControllerDidConnectedServer:(PPWebSocketController *)webSocketController;


/**
 *  告知外部接收到從Server傳送的Data
 *
 *  @param webSocketController PPWebSocketController Object
 *  @param message                   Receive a UTF8 String or Data
 */
- (void)webSocketController:(PPWebSocketController *)webSocketController didReceiveMessage:(id)message;


@optional

/**
 socket 連線斷線(關閉)

 @param webSocketController  PPWebSocketController Object
 @param code code
 @param reason 斷線原因
 @param wasClean If we get closed in this state it's probably not clean because we should be sending this when we send messages
 */
- (void)webSocketController:(PPWebSocketController *)webSocketController
           didCloseWithCode:(NSInteger)code
                     reason:(NSString *)reason
                   wasClean:(BOOL)wasClean;



- (void)webSocketController:(PPWebSocketController *)webSocketController
             didReceivePong:(NSData *)pongPayload;




/**
 連線失敗

 @param webSocketController PPWebSocketController Object
 @param error 回傳錯誤
 */
- (void)webSocketController:(PPWebSocketController *)webSocketController
           didFailWithError:(NSError *)error;

@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPWebSocketController Interface

@interface PPWebSocketController : NSObject





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign) NSTimeInterval keepAliveTimeInterval; //預設20秒，連線後，每隔keepAliveTimeInterval ping 一次 server





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

/**
 *  即將進行連線的Server URL.
 *
 *  @param urlString Server URL，例如：ws://10.10.12.40:8080.
 */
+ (void)setDefaultURLString:(NSString *)urlString;

/**
 *  通知相關訊息的Delegate
 *
 *  @param delegate Delegate
 */
+ (void)setDelegate:(id<PPWebSocketControllerDelegate>)delegate;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Action Class Method

/**
 *  連線至Server端.
 */
+ (void)connect;

/**
 *  中斷與Server端的連線.
 */
+ (void)disconnect;

/**
 *  傳送資料至Server端.
 *
 *  @param data Send a UTF8 String or Data.
 *  @param error 回傳錯誤
 */
+ (BOOL)sendData:(id)data error:(NSError **)error;

@end
