//
//  PPURLController+TSMC.m
//  PPURLController
//
//  Created by sanhue cheng on 2021/12/14.
//

#import "PPURLController+TSMC.h"

static BOOL s_PPURLController_EnableTSMCMode = NO;

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation PPURLController (TSMC)


//==============================================================================
//
//==============================================================================
+ (void)enableTSMCMode:(BOOL)enable
{
    s_PPURLController_EnableTSMCMode = enable;
}



//==============================================================================
//
//==============================================================================
+ (BOOL)isTSMCMode
{
    return s_PPURLController_EnableTSMCMode;
}


//==============================================================================
//
//==============================================================================
+ (BOOL)tsmc_canOpenURLFromViewControllerWithType:(PPURLControllerType)type
{
    if(type==PPURLControllerType_Email)
    {
        return [[UIApplication sharedApplication] canOpenURL:[NSURL URLWithString:@"mailto:"]];
    }
    else
    {
        return NO;
    }
}

//==============================================================================
//
//==============================================================================
+ (BOOL)tsmc_showFromViewController:(UIViewController *)superViewController withURLType:(PPURLControllerType)type parameter:(NSString *)parameter
{
    BOOL result = NO;
    NSString *urlParam = nil;
    
    do
    {
        //////////////////////////////////////////////////
        
        UIApplication *application = [UIApplication sharedApplication];
        if(application==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        // remove scpace characters in prefix
        
        if([parameter length] == 0)
        {
            break;
        }
        
        urlParam = [NSString stringWithString:parameter];
        
        while ([urlParam hasPrefix:@" "] == YES)
        {
            urlParam = [urlParam substringFromIndex:1];
        }
        
        if(![urlParam length])
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSString *string = nil;
        
        switch(type)
        {
            case PPURLControllerType_Email:
            {
                //////////////////////////////////////////////////
                // TSMC_Feature
                if((superViewController==nil && [self canOpenURLWithType:type]==NO))
                {
                    break;
                }
                
                string = @"awemailclient://emailcompose?kAWEmailClientEmailTo=";
                //////////////////////////////////////////////////
                string = [string stringByAppendingString:[urlParam stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                
                [application openURL:[NSURL URLWithString:string] options:@{} completionHandler:nil];
                return YES;
            }
                
            case PPURLControllerType_None:
            default:
            {
                break;
            }
        }
    }while(0);
    
    //////////////////////////////////////////////////
    
    return result;
}
@end
