//
//  PPURLController.h
//  
//
//  Created by Andrew on 2015/7/14.
//  Copyright 2009 penpower. All rights reserved.
//

#import <Foundation/Foundation.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPURLControllerType)
{
    PPURLControllerType_None = 0,
    PPURLControllerType_Email,
    PPURLControllerType_EmailCC,
    PPURLControllerType_EmailBCC,
    PPURLControllerType_Facebook,
    PPURLControllerType_Facebook_Profile,
    PPURLControllerType_FaceTime,
    PPURLControllerType_GoogleMap,
    PPURLControllerType_BaiduMap,
    PPURLControllerType_LinkedIn,
    PPURLControllerType_LinkedIn_Profile,
    PPURLControllerType_NaviCon,
    PPURLControllerType_SMS,
    PPURLControllerType_Tel,
    PPURLControllerType_Twitter,
    PPURLControllerType_Twitter_Profile,
    PPURLControllerType_Web,
    PPURLControllerType_Skype,
    PPURLControllerType_SinaWebo,
    PPURLControllerType_SinaWebo_Profile
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPURLController : NSObject

+ (NSString *)dialStringFromPhoneNumber:(NSString *)phoneNumber;
+ (NSString *)parameterForNaviConWithAddress:(NSString *)address appName:(NSString *)appName title:(NSString *)title text:(NSString *)text;
+ (NSString *)parameterForLinkedInWithFirstName:(NSString *)firstName lastName:(NSString *)lastName;
+ (BOOL)canOpenURLWithType:(PPURLControllerType)type;


@end
