//
//  PPTableViewController.m
//  
//
//  Created by Mike on 13/5/8.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPTableViewController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static UIColor * PPTableViewController_DefaultBackgroundColor = nil;
static UIColor * PPTableViewController_DefaultNavigationBarBackgroundColor = nil;
static NSNumber * PPTableViewController_PreferredStatusBarStyle = nil;
static NSNumber * PPTableViewController_NavigationBarBackgroundImageHidden = nil;
static NSNumber * PPTableViewController_ModelPresentationStyle = nil;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPTableViewController()

@interface PPTableViewController()
@property(nonatomic,assign)             BOOL        shouldLayoutSubviews;
@property(nonatomic,readwrite,retain)   UIImageView *backgroundImageView;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPTableViewController

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Synthesize

@synthesize
shouldLayoutSubviews                = shouldLayoutSubviews_,
backgroundImageView                 = backgroundImageView_,
masterViewPopoverController         = masterViewPopoverController_,
ppInterfaceOrientationController    = ppInterfaceOrientationController_,
navigationBarBackgroundColor        = navigationBarBackgroundColor_;





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewStyle)style
{
	if((self=[super initWithStyle:style]))
	{
		ppInterfaceOrientationController_ = [[PPInterfaceOrientationController alloc] init];
        
        if(PPTableViewController_DefaultBackgroundColor != nil)
        {
            self.view.backgroundColor = PPTableViewController_DefaultBackgroundColor;
        }
        
        if(PPTableViewController_DefaultNavigationBarBackgroundColor!= nil)
        {
            self.navigationBarBackgroundColor = PPTableViewController_DefaultNavigationBarBackgroundColor;
        }
        
        if(PPTableViewController_ModelPresentationStyle!= nil)
        {
            self.modalPresentationStyle = [PPTableViewController_ModelPresentationStyle integerValue];
        }
	}
	
    return self;
}

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [masterViewPopoverController_ release];
	[ppInterfaceOrientationController_ release];
    [navigationBarBackgroundColor_ release];
    
    [backgroundImageView_ removeFromSuperview];
    [backgroundImageView_ release];
    backgroundImageView_ = nil;
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
	[super viewWillAppear:animated];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    // Set color of navigation bar
    
    if(self.navigationBarBackgroundColor != nil)
    {
        // !! ios7 要設定translucent不然無法設定顏色
        self.navigationController.navigationBar.translucent = NO;
        self.navigationController.navigationBar.barTintColor = self.navigationBarBackgroundColor;
    }
    
    if ([PPTableViewController_NavigationBarBackgroundImageHidden boolValue])
    {
        [self.navigationController.navigationBar setBackgroundImage:[[[UIImage alloc]init] autorelease] forBarMetrics:UIBarMetricsDefault];
        [self.navigationController.navigationBar setShadowImage:[[[UIImage alloc] init] autorelease]];
    }
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    UIImageView *imageView = nil;
    
    do
    {
        imageView = [[UIImageView alloc] initWithFrame:self.view.bounds];
        
        if (imageView == nil)
        {
            break;
        }
        
        imageView.autoresizingMask   = UIViewAutoresizingFlexibleWidth|UIViewAutoresizingFlexibleHeight;
        imageView.backgroundColor    = [UIColor clearColor];
        self.backgroundImageView     = imageView;
        [self.view insertSubview:self.backgroundImageView atIndex:0];
    }
    while (NO);

    [imageView release];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    // !! ios9 以上ipad介面會把table的內容左右內縮，造成cell的layout異常，
    // 設定這個可以讓介面看起來跟ios9以前一樣
    if ([self.tableView respondsToSelector:@selector(setCellLayoutMarginsFollowReadableWidth:)])
    {
        [self.tableView setCellLayoutMarginsFollowReadableWidth:NO];
    }

    self.shouldLayoutSubviews = YES;
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    self.isViewDidAppear = YES;
}



//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    self.isViewDidAppear = NO;
    
    [self.backgroundImageView removeFromSuperview];
    self.backgroundImageView = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super viewDidDisappear:animated];
}

//================================================================================
//
//================================================================================
- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(self.shouldLayoutSubviews==YES)
    {
        [self layoutSubviews];
        
        self.shouldLayoutSubviews = NO;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Responding to View Rotation Events

//================================================================================
//
//================================================================================
- (UIInterfaceOrientationMask)supportedInterfaceOrientations
{
    return [self.ppInterfaceOrientationController supportedInterfaceOrientations];
}

//================================================================================
//
//================================================================================
- (BOOL)shouldAutorotate
{
    return [self.ppInterfaceOrientationController shouldAutorotate];
}


//================================================================================
//
//================================================================================
- (void)willAnimateRotationToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation duration:(NSTimeInterval)duration
{
	[super willAnimateRotationToInterfaceOrientation:toInterfaceOrientation duration:duration];
	
	////////////////////////////////////////////////////////////////////////////////////////////////////
	
    [self layoutSubviews];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prefersStatusBarHidden


//================================================================================
//
//================================================================================
- (BOOL)prefersStatusBarHidden
{
    return self.preferedStatusBarHidden;
}


//================================================================================
// info.plist要加入 UIViewControllerBasedStatusBarAppearance 設定為YES才有用
//================================================================================
- (UIStatusBarStyle)preferredStatusBarStyle
{
    return (UIStatusBarStyle)[PPTableViewController_PreferredStatusBarStyle integerValue];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Presenting Another View Controller’s Content

//================================================================================
//
//================================================================================
- (BOOL)disablesAutomaticKeyboardDismissal
{
    if(self.modalPresentationStyle==UIModalPresentationFormSheet)
    {
        return NO;
    }
    
    return [super disablesAutomaticKeyboardDismissal];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Intended For Subclasses Method
//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class methods

//================================================================================
//
//================================================================================
+ (void)setDefaultBackgroundColor:(UIColor *)color
{
    PPTableViewController_DefaultBackgroundColor = [[UIColor alloc] initWithCGColor:color.CGColor];
}


//================================================================================
//
//================================================================================
+ (void)setDefaultNavigationBarBackgroundColor:(UIColor *)color
{
    PPTableViewController_DefaultNavigationBarBackgroundColor = [[UIColor alloc] initWithCGColor:color.CGColor];
}


//==============================================================================
//
//==============================================================================
+ (void)setDefaultStatusBarStyle:(UIStatusBarStyle)style
{
    PPTableViewController_PreferredStatusBarStyle = [[NSNumber numberWithInteger:style] retain];
}


//==============================================================================
//
//==============================================================================
+ (void)setNavigationBarBackgroundImageHidden:(BOOL)hidden
{
    PPTableViewController_NavigationBarBackgroundImageHidden = [@(hidden) retain];
}


//==============================================================================
//
//==============================================================================
+ (void)setDefaultModalPresentationStyle:(UIModalPresentationStyle)style
{
    PPTableViewController_ModelPresentationStyle = [@(style) retain];
}

@end
