//
//  PPLabelTableViewCell.m
//
//  Created by Howard.Lin on 13/10/17.
//  Modified by Andrew.Lai on 14/08/20.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPLabelTableViewCell.h"
#import "NSString+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

CGFloat PPLabelTableViewCell_ShortPressDuration = 0.5;

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPLabelTableViewCell()

- (void)handleShortPress:(UILongPressGestureRecognizer *)sender;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPLabelTableViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize
 delegate       = delegate_,
 valueTextLabel = valueTextLabel_;


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects
 

//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if((self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]))
    {
        self.selectionStyle = UITableViewCellSelectionStyleNone;

        //////////////////////////////////////////////////
        
        valueTextLabel_ = [[CustomRectLabel alloc] init];
        
        if(valueTextLabel_!=nil)
        {
            valueTextLabel_.adjustsFontSizeToFitWidth = YES;
            valueTextLabel_.numberOfLines   = 0;
            valueTextLabel_.lineBreakMode   = NSLineBreakByWordWrapping;
            valueTextLabel_.backgroundColor = [UIColor clearColor];

            [self.contentView addSubview:valueTextLabel_];
        }

    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    delegate_ = nil;
    
    [self removeShortPressGestureRecognizer];
    
    [valueTextLabel_ removeFromSuperview];
    [valueTextLabel_ release];
    valueTextLabel_ = nil;
    
    //////////////////////////////////////////////////
    
	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
	[super layoutSubviews];
    
    //////////////////////////////////////////////////

    if(self.valueTextLabel!=nil)
    {

        switch(self.style)
        {
            case UITableViewCellStyleValue1:
            case UITableViewCellStyleValue2:
            {
                if(self.valueTextLabel.text!=nil &&
                   self.valueTextLabel.text.length>0)
                {
                    CGRect textFrame = self.textLabel.frame;
                    
                    [self.textLabel sizeToFit];
                    
                    textFrame.size.height = self.textLabel.frame.size.height;
                    
                    self.textLabel.frame = textFrame;
                    
                    //////////////////////////////////////////////////
                    
                    CGRect valueTextLabelFrame = self.valueTextLabel.frame;
                    valueTextLabelFrame.origin.x = self.textLabel.frame.origin.x;
                    valueTextLabelFrame.origin.y = self.textLabel.frame.origin.y+self.textLabel.frame.size.height;
                    valueTextLabelFrame.size.width = textFrame.size.width;
                    self.valueTextLabel.frame = valueTextLabelFrame;
                    
                    [self.valueTextLabel sizeToFit];
                    
                    valueTextLabelFrame.origin.x = self.textLabel.frame.origin.x;
                    valueTextLabelFrame.origin.y = self.textLabel.frame.origin.y+self.textLabel.frame.size.height;
                    valueTextLabelFrame.size.width = textFrame.size.width;
                    valueTextLabelFrame.size.height = self.valueTextLabel.frame.size.height;
                
                    self.valueTextLabel.frame = valueTextLabelFrame;
                }
                else
                {
                    self.valueTextLabel.frame = CGRectZero;
                }
                
                break;
            }
            case UITableViewCellStyleSubtitle:
            {
                CGRect valueTextLabelFrame = self.contentView.bounds;
                
                //有子標題時，只使用預設tableViewCell
                valueTextLabelFrame.origin.x     = self.contentInsets.left;
                valueTextLabelFrame.origin.y     = self.contentInsets.top;
                valueTextLabelFrame.size.width   -= (self.contentInsets.left+self.contentInsets.right);
                valueTextLabelFrame.size.height  = (self.contentView.bounds.size.height-(PPTableViewCellDefaultVerticalGap+self.contentInsets.top+self.contentInsets.bottom))/2;
                
                self.valueTextLabel.frame = valueTextLabelFrame;
                
                //////////////////////////////////////////////////

                CGRect detailTextLabelFrame;
                detailTextLabelFrame.origin.x     = valueTextLabelFrame.origin.x;
                detailTextLabelFrame.origin.y     = valueTextLabelFrame.origin.y+valueTextLabelFrame.size.height+PPTableViewCellDefaultVerticalGap;
                detailTextLabelFrame.size.width   = valueTextLabelFrame.size.width;
                detailTextLabelFrame.size.height  = valueTextLabelFrame.size.height;
                self.detailTextLabel.frame = detailTextLabelFrame;
    
                break;
            }
            case UITableViewCellStyleDefault:
            default:
            {
                CGRect valueTextLabelFrame = self.contentView.bounds;
                
                valueTextLabelFrame.origin.x     = self.contentInsets.left;
                valueTextLabelFrame.origin.y     = self.contentInsets.top;
                valueTextLabelFrame.size.width   -= (self.contentInsets.left+self.contentInsets.right);
                valueTextLabelFrame.size.height  -= (self.contentInsets.top+self.contentInsets.bottom);
                
                self.valueTextLabel.frame = valueTextLabelFrame;
                break;
            }
        }

    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (BOOL)canBecomeFirstResponder
{
    return YES;
    
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)handleShortPress:(UILongPressGestureRecognizer *)sender
{
    if(sender.state==UIGestureRecognizerStateBegan)
    {
        [self becomeFirstResponder];
        
        //////////////////////////////////////////////////
        
        if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppLabelTableViewCellDidShortPress:)]==YES)
        {
            [self.delegate ppLabelTableViewCellDidShortPress:self];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)addShortPressGestureRecognizer
{
    if(shortPressGestureRecognizer_==nil)
    {
        shortPressGestureRecognizer_ = [[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(handleShortPress:)];
        
        if(shortPressGestureRecognizer_!=nil)
        {
            shortPressGestureRecognizer_.minimumPressDuration = PPLabelTableViewCell_ShortPressDuration; //seconds
            [self.contentView addGestureRecognizer:shortPressGestureRecognizer_];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)removeShortPressGestureRecognizer
{
    [self removeGestureRecognizer:shortPressGestureRecognizer_];
    
    [shortPressGestureRecognizer_ release];
    shortPressGestureRecognizer_ = nil;
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - subclass


//==============================================================================
//
//==============================================================================
- (void)setEnable:(BOOL)enable
{
    [super setEnable:enable];
    
    self.valueTextLabel.userInteractionEnabled = enable;
    self.valueTextLabel.enabled = enable;
}
@end

