//
//  PPFitLabelSizeTableViewCell.m
//  Pods
//
//  Created by sanhue on 2016/12/23.
//
//

#import "PPFitLabelSizeTableViewCell.h"


NSInteger const PPFitLabelSizeTableViewCellMargin = 5;

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation PPFitLabelSizeTableViewCell





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - init/dealloc methods



//==============================================================================
//
//==============================================================================
- (instancetype)initWithReuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:reuseIdentifier];
    if (self)
    {
        self.contentInsets = UIEdgeInsetsMake(8, 8, 8, 8);
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    
    //////////////////////////////////////////////////
    [super dealloc];
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - cell height



//==============================================================================
//
//==============================================================================
- (CGFloat)labelHeightWithText:(NSString *)text font:(UIFont *)font lineBreakMode:(NSLineBreakMode)lineBreakMode
{
    NSMutableParagraphStyle *paragraphStyle = [[NSMutableParagraphStyle alloc] init];
//    paragraphStyle.lineBreakMode = lineBreakMode;
    
    NSDictionary *attributes = @{NSFontAttributeName:font, NSParagraphStyleAttributeName:paragraphStyle};
    [paragraphStyle release];
    
    CGRect boundingRect = [text boundingRectWithSize:CGSizeMake(self.contentView.bounds.size.width-(self.contentInsets.left+self.contentInsets.right), 10000)
                                             options:(NSStringDrawingUsesLineFragmentOrigin|NSStringDrawingUsesFontLeading)
                                          attributes:attributes
                                             context:nil];
    
    return ceilf(boundingRect.size.height);
}


//==============================================================================
//
//==============================================================================
- (NSInteger)cellHeight
{
    CGFloat textLabelHeight = self.textLabel.bounds.size.height;
    if ([self.textLabel.text length]>0)
    {
        textLabelHeight = [self labelHeightWithText:self.textLabel.text
                                               font:self.textLabel.font
                                      lineBreakMode:self.textLabel.lineBreakMode];
    }
    
    CGFloat detailTextLabelHeight = self.detailTextLabel.bounds.size.height;
    if ([self.detailTextLabel.text length]>0)
    {
        detailTextLabelHeight = [self labelHeightWithText:self.detailTextLabel.text
                                                     font:self.detailTextLabel.font
                                      lineBreakMode:self.detailTextLabel.lineBreakMode];
    }
    
    return textLabelHeight+detailTextLabelHeight+(self.contentInsets.top+self.contentInsets.bottom+PPFitLabelSizeTableViewCellMargin);
}







////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    CGRect textLabelFrame = self.contentView.bounds;
    
    
    textLabelFrame.origin.x     = self.contentInsets.left;
    textLabelFrame.origin.y     = self.contentInsets.top;
    textLabelFrame.size.width   -= (self.contentInsets.left+self.contentInsets.right);
    textLabelFrame.size.height  = (self.contentView.bounds.size.height-(self.contentInsets.top+self.contentInsets.bottom+PPFitLabelSizeTableViewCellMargin))/2;
    
    if([self.textLabel.text length]>0)
    {
        textLabelFrame.size.height = [self labelHeightWithText:self.textLabel.text
                                                          font:self.textLabel.font
                                                 lineBreakMode:self.textLabel.lineBreakMode];
    }
    
    
    CGRect detailTextLabelFrame;
    detailTextLabelFrame.origin.x     = textLabelFrame.origin.x;
    detailTextLabelFrame.origin.y     = textLabelFrame.origin.y+textLabelFrame.size.height+PPFitLabelSizeTableViewCellMargin;
    detailTextLabelFrame.size.width   = textLabelFrame.size.width;
    detailTextLabelFrame.size.height  = textLabelFrame.size.height;
    
    if([self.detailTextLabel.text length]>0)
    {
        detailTextLabelFrame.size.height = [self labelHeightWithText:self.detailTextLabel.text
                                                                font:self.detailTextLabel.font
                                                       lineBreakMode:self.detailTextLabel.lineBreakMode];
    }
    
    
    //////////////////////////////////////////////////
    self.textLabel.frame = textLabelFrame;
    self.detailTextLabel.frame = detailTextLabelFrame;
}


@end
