//
//  PPDateTextFieldTableViewCell.m
//
//  Created by Howard.Lin on 13/10/11.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPDateTextFieldTableViewCell.h"

// Category
#import "NSDate+Format.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPDateTextFieldTableViewCell


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object


//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if((self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]))
    {
        _datePicker = [[UIDatePicker alloc] initWithFrame:CGRectZero];
        
        if (@available(iOS 13.4, *)) {
            _datePicker.preferredDatePickerStyle = UIDatePickerStyleWheels;
        }
//
//        if (@available(iOS 14.0, *)) {
//            self.datePicker.preferredDatePickerStyle = UIDatePickerStyleInline;
//        }
        
        _datePicker.datePickerMode = UIDatePickerModeDate;

        [_datePicker addTarget:self action:@selector(datePickerValueChanged:) forControlEvents:UIControlEventValueChanged];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_datePicker removeTarget:self action:@selector(datePickerValueChanged:) forControlEvents:UIControlEventValueChanged];
    [_datePicker release];
    _datePicker = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method For Inheriting

//================================================================================
//
//================================================================================
- (void)datePickerValueChanged:(id)object
{
    if(self.datePicker==object)
    {
        if(self.datePicker.datePickerMode==UIDatePickerModeDateAndTime)
        {
            self.textField.text = [self.datePicker.date stringWithFormat:NSDateFormat_Minute];
        }
        else
        {
            self.textField.text = [self.datePicker.date stringWithFormat:NSDateFormat_Day];
        }
        
        //////////////////////////////////////////////////
        
        [self textFieldDidChange];
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITextFieldDelegate Method

//================================================================================
//
//================================================================================
- (void)textFieldDidBeginEditing:(UITextField *)textField
{
    [super textFieldDidBeginEditing:textField];
    
    //////////////////////////////////////////////////

    textField.font = [UIFont systemFontOfSize:[UIFont systemFontSize]+1];
    
    //////////////////////////////////////////////////

    textField.inputView = self.datePicker;
}


//================================================================================
//
//================================================================================
- (void)textFieldDidEndEditing:(UITextField *)textField
{
    [super textFieldDidEndEditing];
    
    //////////////////////////////////////////////////

    textField.font = [UIFont systemFontOfSize:[UIFont systemFontSize]];
}


//================================================================================
//
//================================================================================
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    //只能由UIDatePicker輸入
    return NO;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)datePickerMaximumDateShowWithBirthDay:(BOOL)isBirthday
{
    // 取得現在的日期
    NSDate *nowDate = [NSDate new];
    
    if(isBirthday)
    {
        [self.datePicker setMaximumDate:nowDate];
    }
    else
    {
        [self.datePicker setMaximumDate:nil];
    }
    
    [nowDate release];
}


//================================================================================
//
//================================================================================
- (void)setDatePickerDateWithDateString:(NSString *)dateString format:(NSString *)format
{
    @autoreleasepool
    {
        do
        {
            if([dateString length]<=0 ||
               [format length]<=0)
            {
                break;
            }
            
            //////////////////////////////////////////////////

            NSDateFormatter *dateFormatter = [[[NSDateFormatter alloc] init] autorelease];
            
            if(dateFormatter==nil)
            {
                break;\
            }
            
            //////////////////////////////////////////////////

            [dateFormatter setDateFormat:format];
            
            NSDate *date = [dateFormatter dateFromString:dateString];
            
            if(date==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////

            [self.datePicker setDate:date];
        }
        while (0);
    }
}


//================================================================================
//
//================================================================================
- (void)reuse
{
    // cell 回收後，將 datePicker 更新, 防止鍵盤切換時產生 crash
    if(self.datePicker!=nil)
    {
        [self.datePicker removeTarget:self action:@selector(datePickerValueChanged:) forControlEvents:UIControlEventValueChanged];
        
        [_datePicker release];
        _datePicker = nil;
    }
    
    //////////////////////////////////////////////////

    _datePicker = [[UIDatePicker alloc] initWithFrame:CGRectZero];
    
    if(self.datePicker!=nil)
    {
        if (@available(iOS 13.4, *)) {
            self.datePicker.preferredDatePickerStyle = UIDatePickerStyleWheels;
        }
        
//        if (@available(iOS 14.0, *)) {
//            self.datePicker.preferredDatePickerStyle = UIDatePickerStyleInline;
//        }
//        
        self.datePicker.datePickerMode = UIDatePickerModeDate;
        
        [self.datePicker addTarget:self action:@selector(datePickerValueChanged:) forControlEvents:UIControlEventValueChanged];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////


#pragma mark - subclass

//==============================================================================
//
//==============================================================================
- (void)setEnable:(BOOL)enable
{
    [super setEnable:enable];
    
    self.datePicker.userInteractionEnabled = enable;
    self.datePicker.enabled = enable;
}
@end
