//
//  PPStorageSpaceSelectViewController.m
//  Pods
//
//  Created by Howard on 2015/8/3.
//
//

#import "PPStorageSpaceSelectViewController.h"

// Define
#import "PPStorageSpaceSelectViewController+ResourceDefine.h"
#import "PPStorageSpaceSelectViewController+PrivateParameterDefine.h"
#import "PPStorageSpaceSelectViewController+SettingKey.h"

// Model
#import "PPSpaceRowModel.h"

// View
#import "PPAlertView.h"
#import "PPBarView.h"
#import "PPButton.h"
#import "PPButtonTableViewCell.h"
#import "PPBusyView.h"
#import "PPTableView.h"
#import "PPNavigationBarView.h"

// Controller
#import "PPCloudController.h"
#import "PPStorageSpaceSelectSectionController.h"
#import "PPNetworkReachabilityController.h"
#import "PPSettingsController.h"

// Category
#import "NSError+Custom.h"
#import "PPButton+Factory.h"
#import "UIViewController+ShareApplication.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Interface

@interface PPStorageSpaceSelectViewController ()
<
PPButtonDelegate,
PPButtonTableViewCellDelegate,
PPCloudDelegate_Link,
PPCloudDelegate_Unlink,
PPCloudDelegate_LoadAccountInfo,
UITableViewDataSource,
UITableViewDelegate>

@property (nonatomic,assign) BOOL                                  deviceDidChanged;
@property (nonatomic,assign) BOOL                                  releaseCloudController;
@property (atomic,assign)    BOOL                                  autoSwitchToFileSelect; //切換進檔案視圖
@property (nonatomic,assign) UIDeviceOrientation                   originalDeviceOrientation;
@property (nonatomic,retain) PPStorageSpaceSelectSectionController *storageSpaceSelectSectionController;
@property (nonatomic,retain) PPTableView                           *storageSpaceSelectTableView;
@property (nonatomic,retain) PPButton                              *backButton;
@property (nonatomic,retain) PPBusyView                            *busyView;
@property (nonatomic,retain) NSMutableArray                        *accountInfoTask;
@property (nonatomic,retain) NSOperationQueue                      *fetchSpaceInformationOperationQueue;
@property (nonatomic,assign) PPStorageSpaceSelectSectionControllerRow curLinkSectionControllerRow;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - @implementation

@implementation PPStorageSpaceSelectViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        if([PPCloudController sharedCloudController]==nil)
        {
            _releaseCloudController = YES;
            
            //////////////////////////////////////////////////

            PPCloudController *cloudController = [[PPCloudController alloc] init];
            
            if(cloudController!=nil)
            {
                [PPCloudController setSharedCloudController:cloudController];
            }
            
            [cloudController release];

        }
        
        //////////////////////////////////////////////////
        
        _fetchSpaceInformationOperationQueue = [[NSOperationQueue alloc] init];
        
        if(_fetchSpaceInformationOperationQueue!=nil)
        {
            [_fetchSpaceInformationOperationQueue setMaxConcurrentOperationCount:1];
        }
        
        //////////////////////////////////////////////////

        _controllerTitle = [PSSSVC_MLS_Import retain];
        
        //////////////////////////////////////////////////

        _storageSpaceSelectSectionController = [[PPStorageSpaceSelectSectionController alloc] init];
        
        //////////////////////////////////////////////////

        _needFetchSpaceInformation = YES;
        
        //////////////////////////////////////////////////

        _tableViewcellHeight = PPStorageSpaceSelectSectionControllerCellHeight;
        
        //////////////////////////////////////////////////

        _accountInfoTask = [[NSMutableArray alloc] init];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_busyView removeFromSuperview];
    [_busyView release];
    _busyView = nil;
    
    [_accountInfoTask release];
    _accountInfoTask = nil;
    
    [_cloudKeyDictionary release];
    _cloudKeyDictionary = nil;
    
    //////////////////////////////////////////////////

    [_spaceTypeSelectArray release];
    _spaceTypeSelectArray = nil;
    
    //////////////////////////////////////////////////

    [_controllerTitle release];
    _controllerTitle = nil;
    
    [_exchangeServerName release];
    _exchangeServerName = nil;
    //////////////////////////////////////////////////

    [_navigationViewButtonHighlightedBackgroundColor release];
    _navigationViewButtonHighlightedBackgroundColor = nil;
    
    [_tableViewCellNormalTextColor release];
    _tableViewCellNormalTextColor = nil;
    
    [_tableViewCellNormalDetailTextColor release];
    _tableViewCellNormalDetailTextColor = nil;
    
    [_tableViewSeperatorColor release];
    _tableViewSeperatorColor = nil;
    
    [_tableViewCellHighlightedBackgroundColor release];
    _tableViewCellHighlightedBackgroundColor = nil;
    
    //////////////////////////////////////////////////

    [_backButton removeControlEvents:UIControlEventTouchUpInside];
    [_backButton removeFromSuperview];
    [_backButton release];
    _backButton = nil;
    
    //////////////////////////////////////////////////

    if(_releaseCloudController==YES)
    {
        [PPCloudController setSharedCloudController:nil];
    }
    
    //////////////////////////////////////////////////

    [_fetchSpaceInformationOperationQueue release];
    _fetchSpaceInformationOperationQueue = nil;
    
    [_storageSpaceSelectSectionController release];
    _storageSpaceSelectSectionController = nil;
    
    [_storageSpaceSelectTableView removeFromSuperview];
    [_storageSpaceSelectTableView release];
    _storageSpaceSelectTableView = nil;
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View's Event

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////

    self.storageSpaceSelectSectionController.exchangeServerName = self.exchangeServerName;
    
    //////////////////////////////////////////////////

    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(recvDeviceOrientationDidChangeNotification:)
                                                 name:UIDeviceOrientationDidChangeNotification
                                               object:nil];
    
    //////////////////////////////////////////////////

    // 處理旋轉問題
    [self adjustInterfaceOrientation];

    //////////////////////////////////////////////////

    for(id key in self.cloudKeyDictionary)
    {
        NSString *keyValue = [self.cloudKeyDictionary objectForKey:key];
        
        [PPCloudController setParameter:keyValue forKey:key];
    }
    
    //////////////////////////////////////////////////
    
    if(self.needFetchSpaceInformation==YES)
    {
        NSMutableArray *spaceSelectSectionControllerRows = [NSMutableArray array];
        
        if(spaceSelectSectionControllerRows!=nil)
        {
            if(self.spaceTypeSelectArray==nil ||
               self.spaceTypeSelectArray.count<=0)
            {
                self.spaceTypeSelectArray = @[@(PPStorageSpaceSelectControllerSpaceType_AddressBook),
                                              @(PPStorageSpaceSelectControllerSpaceType_iTune),
                                              @(PPStorageSpaceSelectControllerSpaceType_iCloud),
                                              @(PPStorageSpaceSelectControllerSpaceType_Dropbox),
                                              @(PPStorageSpaceSelectControllerSpaceType_GoogleDrive),
                                              @(PPStorageSpaceSelectControllerSpaceType_OneDrive),
                                              @(PPStorageSpaceSelectControllerSpaceType_Huawei),
                                              @(PPStorageSpaceSelectControllerSpaceType_Baidu),
                                              @(PPStorageSpaceSelectControllerSpaceType_Salesforce),
                                              @(PPStorageSpaceSelectControllerSpaceType_ExchangeServer)];
            }
            
            
            for(id object in self.spaceTypeSelectArray)
            {
                [spaceSelectSectionControllerRows addObject:@([self storageSpaceSelectSectionSpaceTypeFromStorageSpaceSelectSectionControllerRow:[object unsignedIntegerValue]])];
            }
            
            //////////////////////////////////////////////////

            [self.storageSpaceSelectSectionController fetchDefaultDataWithSpaceTypes:spaceSelectSectionControllerRows];
        }

        //////////////////////////////////////////////////

        self.needFetchSpaceInformation = NO;
    }
    
    //////////////////////////////////////////////////

    self.storageSpaceSelectTableView = [[[PPTableView alloc] init] autorelease];
    
    if(self.storageSpaceSelectTableView!=nil)
    {
        self.storageSpaceSelectTableView.dataSource = self;
        self.storageSpaceSelectTableView.delegate   = self;
        
        if(self.tableViewSeperatorColor!=nil)
        {
            self.storageSpaceSelectTableView.separatorColor = self.tableViewSeperatorColor;
        }
        
        [self.view addSubview:self.storageSpaceSelectTableView];
    }

    //////////////////////////////////////////////////

    if(self.navigationController!=nil)
    {
        PPNavigationBarView *navigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
        
        if(navigationBarView!=nil)
        {
            navigationBarView.style = PPBarViewStyle_CenteredAbsolute;

            navigationBarView.titleLabel.text = self.controllerTitle;
            
            //////////////////////////////////////////////////

            self.backButton = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                              tag:PPStorageSpaceSelectSectionControllerButtonTag_Back
                                                         delegate:self
                                            normalBackgroundColor:nil
                                       highlightedBackgroundColor:self.navigationViewButtonHighlightedBackgroundColor
                                                  imageEdgeInsets:self.navigationBarButtonImageInsets];
            
            if(_backButton!=nil)
            {
                [_backButton addControlEvents:UIControlEventTouchUpInside];
                
                //////////////////////////////////////////////////

                if(_backButton.imageView.image==nil)
                {
                    [_backButton setTitle:[@"MLS_Back" localizedFromTable:NSStringFromClass([_backButton class])] maxWidth:0.0];
                    
                    [navigationBarView setViews:@[_backButton] forBlockType:PPBarViewBlockType_Left];
                }
                else
                {
                    PPBarViewItemModel *itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_backButton];
                    
                    if(itemModel!=nil)
                    {
                        itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                        
                        [navigationBarView setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
                    }
                }
            }
            
            //////////////////////////////////////////////////

            UIBarButtonItem *leftBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:navigationBarView];
            
            if(leftBarButtonItem!=nil)
            {
                self.navigationItem.leftBarButtonItem = leftBarButtonItem;
            }
            
            [leftBarButtonItem release];
        }
        
        [navigationBarView release];
    }
    else
    {
        self.title = self.controllerTitle;
    }
}


//================================================================================
//
//================================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////

    [self showBusyView:YES withSuperView:self.view];
    
    //////////////////////////////////////////////////

    //開始跑空間資訊
    __block typeof(self) blockself = self;
    
    __block NSBlockOperation *fetchInfoOperation = [NSBlockOperation blockOperationWithBlock:^{
        
        do
        {
            if(fetchInfoOperation.isCancelled==YES)
            {
                break;
            }
            
            //////////////////////////////////////////////////

            @synchronized(blockself)
            {
                [blockself checkIsLink];
                
                //////////////////////////////////////////////////
                
                //改用陣列去紀錄需要更新的空間資訊
                [blockself checkAccountInfoTask];
                
                //////////////////////////////////////////////////
                
                if(blockself.accountInfoTask.count<=0)
                {
                    // 特殊作法，因為沒有需要刷新的帳號資訊，所以這邊要延遲 busyView 消失的時間，才不會讓畫面看起來閃一下
                    [NSThread sleepForTimeInterval:0.1];
                    
                    //////////////////////////////////////////////////
                    
                    dispatch_sync(dispatch_get_main_queue(), ^{
                        
                        [blockself showBusyView:NO withSuperView:nil];
                        
                    });
                }
                else
                {
                    [blockself startLoadAccountInfo];
                }
            }
        }
        while (0);
    }];
    
    if(fetchInfoOperation!=nil)
    {
        [self.fetchSpaceInformationOperationQueue cancelAllOperations];

        [self.fetchSpaceInformationOperationQueue addOperation:fetchInfoOperation];
    }
}


//================================================================================
//
//================================================================================
- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    
    //////////////////////////////////////////////////

    self.storageSpaceSelectTableView.frame = [self layoutFrame];
}


//================================================================================
//
//================================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    
    //////////////////////////////////////////////////

    [[NSNotificationCenter defaultCenter] removeObserver:self];

    //////////////////////////////////////////////////

    [self.fetchSpaceInformationOperationQueue cancelAllOperations];
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [super viewDidDisappear:animated];
    
    //////////////////////////////////////////////////

    [self restoreInterfaceOrientation];
    
    //////////////////////////////////////////////////

    self.storageSpaceSelectTableView.dataSource = nil;
    self.storageSpaceSelectTableView.delegate = nil;
    
    [self.storageSpaceSelectTableView removeFromSuperview];
    self.storageSpaceSelectTableView = nil;
    
    //////////////////////////////////////////////////

    self.navigationItem.leftBarButtonItem = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonTableViewCellDelegate Method

//================================================================================
//
//================================================================================
- (void)ppButtonTableViewCell:(PPButtonTableViewCell *)ppButtonTableViewCell ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    BOOL login = NO;
    
    if([ppButton.titleLabel.text compare:PSSSVC_MLS_LoginIn]==NSOrderedSame)
    {
        login = YES;
    }
    
    //////////////////////////////////////////////////
    
    __block typeof(self) blockself = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        
        [blockself login:login storageSpaceSelectSectionControllerRow:ppButton.tag];
    });

}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudDelegate_LoadAccountInfo

//================================================================================
//
//================================================================================
- (void)ppCloud:(PPCloud *)ppCloud loadAccountInfoFailedWithError:(NSError *)error userInfo:(id)userInfo
{
    //將task 移除
    [self.accountInfoTask removeObject:userInfo];

    //////////////////////////////////////////////////
    
    // 有登入成功，沒有取到帳號資訊，還是能進去檔案列表
    if(self.autoSwitchToFileSelect==YES &&
       [userInfo unsignedIntegerValue]==self.curLinkSectionControllerRow)
    {
        __block typeof(self) blockSelf = self;
        
        dispatch_async(dispatch_get_main_queue(), ^{
            [blockSelf showBusyView:NO withSuperView:nil];
        });
        
        //////////////////////////////////////////////////
        
        //決定選擇哪個空間之後，就直接取消讀取帳號資訊的動作
        [self.accountInfoTask removeAllObjects];
        
        //////////////////////////////////////////////////
     
        self.autoSwitchToFileSelect = NO;
        
        //////////////////////////////////////////////////

        [self decideStorageSpaceSelectSectionSpaceTypeFromStorageSpaceSelectSectionControllerRow:[userInfo unsignedIntegerValue]];
    }
    else if(self.accountInfoTask.count<=0)
    {
        __block typeof(self) blockSelf = self;
        
        dispatch_async(dispatch_get_main_queue(), ^{
            [blockSelf showBusyView:NO withSuperView:nil];
        });
    }
}


//================================================================================
//
//================================================================================
- (void)ppCloud:(PPCloud *)ppCloud loadedAccountInfo:(PPCloudAccountInfo *)accountInfo userInfo:(id)userInfo
{
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        //將task 移除
        [self.accountInfoTask removeObject:userInfo];
        
        //////////////////////////////////////////////////
        
        [self.storageSpaceSelectSectionController fetchAccountInfoWithStorageSpaceSelectSectionControllerRow:[userInfo unsignedIntegerValue]
                                                                                            cloudAccountInfo:accountInfo];
        
        //////////////////////////////////////////////////
        
        // MARK:取得帳號資訊成功, 寫回帳號名稱資訊
        [self recordAccountName:accountInfo.displayName withsStorageSpaceSelectSectionControllerRow:[userInfo unsignedIntegerValue]];
        
        //////////////////////////////////////////////////
        
        [self updateCellContentForStorageSpaceSelectSectionControllerRow:[userInfo unsignedIntegerValue]];
        
        //////////////////////////////////////////////////
        
        if(self.autoSwitchToFileSelect==YES)
        {
            self.autoSwitchToFileSelect = NO;
            
            //////////////////////////////////////////////////
            
            [self decideStorageSpaceSelectSectionSpaceTypeFromStorageSpaceSelectSectionControllerRow:[userInfo unsignedIntegerValue]];
        }
    });


}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloud_Link Delegate Method

//================================================================================
//
//================================================================================
- (void)ppCloud:(PPCloud *)ppCloud linkFailedWithError:(NSError *)error userInfo:(id)userInfo
{
    if(error.code!=PPCloudCommonError_CancelLogin)
    {
        [self showAlertWithError:error];
    }
}


//================================================================================
//
//================================================================================
- (void)ppCloud:(PPCloud *)ppCloud linkSuccessWithUserInfo:(id)userInfo
{
    // MARK: 登入成功

    [self showBusyView:YES withSuperView:nil];
    
    //////////////////////////////////////////////////

    self.autoSwitchToFileSelect = YES;
    
    //////////////////////////////////////////////////
    
    [PPCloudController loadAccountInfoWithDelegate:self
                                          userInfo:userInfo
                                        cloudClass:[ppCloud class]];
    
    //////////////////////////////////////////////////

    self.curLinkSectionControllerRow = [userInfo unsignedIntegerValue];
    
    [self.storageSpaceSelectSectionController fetchNeedFetchAccoutInfoWithPPStorageSpaceSelectSectionControllerRow:[userInfo unsignedIntegerValue]];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloud_unLink Delegate Method

//================================================================================
//
//================================================================================
- (void)ppCloud:(PPCloud *)ppCloud unlinkFailedWithError:(NSError *)error userInfo:(id)userInfo
{
    [self showAlertWithError:error];
}


//================================================================================
//
//================================================================================
- (void)ppCloud:(PPCloud *)ppCloud unlinkSuccessWithUserInfo:(id)userInfo
{
    // MARK:登出成功，清除帳號名稱資訊
    [self recordAccountName:@"" withsStorageSpaceSelectSectionControllerRow:[userInfo unsignedIntegerValue]];

    //////////////////////////////////////////////////

    //　清除帳號資訊
    [self.storageSpaceSelectSectionController fetchAccountInfoWithStorageSpaceSelectSectionControllerRow:[userInfo unsignedIntegerValue]
                                                                                        cloudAccountInfo:nil];

    
    //////////////////////////////////////////////////

    [self.storageSpaceSelectSectionController fetchNeedFetchAccoutInfoWithPPStorageSpaceSelectSectionControllerRow:[userInfo unsignedIntegerValue]];
    
    //////////////////////////////////////////////////

    [self updateCellContentForStorageSpaceSelectSectionControllerRow:[userInfo unsignedIntegerValue]];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDatasource Method

//================================================================================
//
//================================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return self.tableViewcellHeight;
}


//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return [self.storageSpaceSelectSectionController numberOfSectionsForSearching:NO];
}


//================================================================================
//
//================================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section;
{
    return [self.storageSpaceSelectSectionController numberOfRowsInSection:section forSearching:NO];
}


//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSString *identifier = nil;
    
    PPSpaceRowModel *rowModel = (PPSpaceRowModel *)[self.storageSpaceSelectSectionController rowModelAtIndexPath:indexPath forSearching:NO];
    
    //////////////////////////////////////////////////

    switch (rowModel.storageSpaceSelectSectionControllerRow)
    {
        case PPStorageSpaceSelectSectionControllerRow_Baidu:
        case PPStorageSpaceSelectSectionControllerRow_Dropbox:
        case PPStorageSpaceSelectSectionControllerRow_GoogleDrive:
        case PPStorageSpaceSelectSectionControllerRow_OneDrive:
        case PPStorageSpaceSelectSectionControllerRow_Huawei:
        {
            identifier = NSStringFromClass([PPButtonTableViewCell class]);
            break;
        }
        case PPStorageSpaceSelectSectionControllerRow_iCloud:
        case PPStorageSpaceSelectSectionControllerRow_iTune:
        case PPStorageSpaceSelectSectionControllerRow_AddressBook:
        case PPStorageSpaceSelectSectionControllerRow_Salesforce:
        case PPStorageSpaceSelectSectionControllerRow_ExchangeServer:
        case PPStorageSpaceSelectSectionControllerRow_Specific:
        default:
        {
            identifier = NSStringFromClass([PPTableViewCell class]);
            break;
        }
    }
    
    //////////////////////////////////////////////////

    UITableViewCell *tableViewCell = [tableView dequeueReusableCellWithIdentifier:identifier];
    
    if(tableViewCell==nil)
    {
        if([identifier compare:NSStringFromClass([PPButtonTableViewCell class])]==NSOrderedSame)
        {
            tableViewCell = [[[PPButtonTableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:identifier] autorelease];
        }
        else
        {
            tableViewCell = [[[PPTableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:identifier] autorelease];
        }
    }
    
    //////////////////////////////////////////////////

    if(tableViewCell!=nil)
    {
        NSString *textString = rowModel.text;
        if(rowModel.storageSpaceSelectSectionControllerRow==PPStorageSpaceSelectSectionControllerRow_Specific&&
           [self.delegate respondsToSelector:@selector(specificStringWithStorageSpaceSelectViewController:)])
        {
            textString = [self.delegate specificStringWithStorageSpaceSelectViewController:self];
        }
        
        tableViewCell.textLabel.text = textString;

        //////////////////////////////////////////////////

        if(self.tableViewCellNormalTextColor!=nil)
        {
            [tableViewCell.textLabel setTextColor:self.tableViewCellNormalTextColor];
        }
        
        //////////////////////////////////////////////////

        if(self.tableViewCellNormalDetailTextColor!=nil)
        {
            [tableViewCell.detailTextLabel setTextColor:self.tableViewCellNormalDetailTextColor];
        }
        
        //////////////////////////////////////////////////

        if(self.tableViewCellHighlightedBackgroundColor!=nil)
        {
            tableViewCell.selectionStyle = UITableViewCellSelectionStyleNone;
        }
        
        //////////////////////////////////////////////////

        if([tableViewCell isKindOfClass:[PPButtonTableViewCell class]]==YES)
        {
            PPButtonTableViewCell *buttonTableViewCell = (PPButtonTableViewCell *)tableViewCell;
            
            //////////////////////////////////////////////////
            
            NSString *buttonTitle = PSSSVC_MLS_LoginIn;
            
            if(rowModel.object!=nil &&
               [rowModel.object isKindOfClass:[NSNumber class]]==YES &&
               [rowModel.object unsignedIntegerValue]==YES)
            {
                buttonTitle = PSSSVC_MLS_LoginOut;
            }
            
            //////////////////////////////////////////////////
            
            [buttonTableViewCell setDelegate:self];
            
            [buttonTableViewCell.ppButtoSelect setImage:nil];
            [buttonTableViewCell.ppButtoSelect setTag:rowModel.storageSpaceSelectSectionControllerRow];
            [buttonTableViewCell.ppButtoSelect setTitleText:buttonTitle];
            
            //////////////////////////////////////////////////

            [buttonTableViewCell.ppButtoSelect setBackgroundImage:[UIImage imageWithColor:PSSSVC_LoginButtonNormalBakcgroundColor]
                                                         forState:UIControlStateNormal];
            [buttonTableViewCell.ppButtoSelect setBackgroundImage:[UIImage imageWithColor:PSSSVC_LoginButtonHighlightedBakcgroundColor]
                                                         forState:UIControlStateHighlighted];
            
            //////////////////////////////////////////////////

            buttonTableViewCell.ignoreCustomLabelFrame = YES;
        }
        else
        {
            PPTableViewCell *ppTableViewCell = (PPTableViewCell *)tableViewCell;
            
            //////////////////////////////////////////////////
            
            ppTableViewCell.ignoreCustomLabelFrame = YES;
            ppTableViewCell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        }
        
        //////////////////////////////////////////////////

        tableViewCell.detailTextLabel.text = rowModel.detailText;
    }
    
    return tableViewCell;
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    //////////////////////////////////////////////////
    
    __block typeof(self) blockself = self;
    
    do
    {
        if(blockself.delegate==nil ||
           [blockself.delegate respondsToSelector:@selector(storageSpaceSelectViewController:didStorageSpaceSelectControllerSpaceType:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPSpaceRowModel *rowModel = (PPSpaceRowModel *)[blockself.storageSpaceSelectSectionController rowModelAtIndexPath:indexPath
                                                                                                             forSearching:NO];
        
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([rowModel.object isKindOfClass:[NSNumber class]]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        BOOL login = [rowModel.object boolValue];
        
        if(rowModel.storageSpaceSelectSectionControllerRow!=PPStorageSpaceSelectSectionControllerRow_AddressBook &&
           rowModel.storageSpaceSelectSectionControllerRow!=PPStorageSpaceSelectSectionControllerRow_iTune &&
           rowModel.storageSpaceSelectSectionControllerRow!=PPStorageSpaceSelectSectionControllerRow_Specific &&
           [PPNetworkReachabilityController checkForInternetConnection]==NO)
        {
            
            dispatch_async(dispatch_get_main_queue(), ^{
                
                NSError *error = PPErrorMake(PPStorageSpaceSelectControllerErrorCode_NetworkDisconnected, PSSSVC_MLS_ErrorNetworkReachableNone, nil);
                
                [blockself showAlertWithError:error];
            });
        }
        else if(login==NO)
        {
            if(rowModel.storageSpaceSelectSectionControllerRow==PPStorageSpaceSelectControllerSpaceType_iCloud)
            {
                dispatch_async(dispatch_get_main_queue(), ^{
                    
                    NSString *message = PSSSVC_MLS_Login_iCloudFail;
                    
                    NSString *productName = [[[NSBundle mainBundle] infoDictionary] objectForKey:(NSString*)kCFBundleNameKey];
                    
                    if([productName length]>0)
                    {
                        message = [message stringByReplacingOccurrencesOfString:@"WorldCard" withString:productName];
                    }
                    
                    [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                         title:@""
                                       message:message
                             cancelButtonTitle:PSSSVC_MLS_OK
                             otherButtonTitles:nil];
                });
            }
            else
            {
                dispatch_async(dispatch_get_main_queue(), ^{
                    [blockself login:YES storageSpaceSelectSectionControllerRow:rowModel.storageSpaceSelectSectionControllerRow];
                });
            }
        }
        else
        {
            [self decideStorageSpaceSelectSectionSpaceTypeFromStorageSpaceSelectSectionControllerRow:rowModel.storageSpaceSelectSectionControllerRow];
        }
    }while (0);
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didHighlightRowAtIndexPath:(NSIndexPath *)indexPath
{
    if(self.tableViewCellHighlightedBackgroundColor!=nil)
    {
        UITableViewCell *tableViewCell = [tableView cellForRowAtIndexPath:indexPath];
        
        if(tableViewCell!=nil)
        {
            [tableViewCell setBackgroundColor:self.tableViewCellHighlightedBackgroundColor];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didUnhighlightRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *tableViewCell = [tableView cellForRowAtIndexPath:indexPath];
    
    if(tableViewCell!=nil)
    {
        [tableViewCell setBackgroundColor:[UIColor clearColor]];
    }
}







////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)login:(BOOL)login storageSpaceSelectSectionControllerRow:(PPStorageSpaceSelectSectionControllerRow)storageSpaceSelectSectionControllerRow
{
    if(storageSpaceSelectSectionControllerRow==PPStorageSpaceSelectSectionControllerRow_AddressBook ||
       storageSpaceSelectSectionControllerRow==PPStorageSpaceSelectSectionControllerRow_iTune ||
       [PPNetworkReachabilityController checkForInternetConnection]==YES)
    {
        switch (storageSpaceSelectSectionControllerRow)
        {
            case PPStorageSpaceSelectSectionControllerRow_Baidu:
            {
                break;
            }
            case PPStorageSpaceSelectSectionControllerRow_Dropbox:
            {
                if(login==YES)
                {
                    [PPCloudController linkFromController:self
                                                 delegate:self
                                                 userInfo:[NSNumber numberWithUnsignedInteger:PPStorageSpaceSelectSectionControllerRow_Dropbox]
                                               cloudClass:[PPCloud_Dropbox class]];
                }
                else
                {
                    [PPCloudController unlinkWithDelegate:self
                                                 userInfo:[NSNumber numberWithUnsignedInteger:PPStorageSpaceSelectSectionControllerRow_Dropbox]
                                               cloudClass:[PPCloud_Dropbox class]];
                }
                
                break;
            }
            case PPStorageSpaceSelectSectionControllerRow_GoogleDrive:
            {
                if(login==YES)
                {
                    [PPCloudController linkFromController:self
                                                 delegate:self
                                                 userInfo:[NSNumber numberWithUnsignedInteger:PPStorageSpaceSelectSectionControllerRow_GoogleDrive]
                                               cloudClass:[PPCloud_GoogleDrive class]];
                }
                else
                {
                    [PPCloudController unlinkWithDelegate:self
                                                 userInfo:[NSNumber numberWithUnsignedInteger:PPStorageSpaceSelectSectionControllerRow_GoogleDrive]
                                               cloudClass:[PPCloud_GoogleDrive class]];
                }
                
                break;
            }
            case PPStorageSpaceSelectSectionControllerRow_OneDrive:
            {
                if(login==YES)
                {
                    [PPCloudController linkFromController:self
                                                 delegate:self
                                                 userInfo:[NSNumber numberWithUnsignedInteger:PPStorageSpaceSelectSectionControllerRow_OneDrive]
                                               cloudClass:[PPCloud_OneDrive class]];
                }
                else
                {
                    [PPCloudController unlinkWithDelegate:self
                                                 userInfo:[NSNumber numberWithUnsignedInteger:PPStorageSpaceSelectSectionControllerRow_OneDrive]
                                               cloudClass:[PPCloud_OneDrive class]];
                }
                
                break;
            }
//            case PPStorageSpaceSelectSectionControllerRow_Huawei:
//            {
//                if(login==YES)
//                {
//                    [PPCloudController linkFromController:self
//                                                 delegate:self
//                                                 userInfo:[NSNumber numberWithUnsignedInteger:PPStorageSpaceSelectSectionControllerRow_Huawei]
//                                               cloudClass:[PPCloud_Huawei class]];
//                }
//                else
//                {
//                    [PPCloudController unlinkWithDelegate:self
//                                                 userInfo:[NSNumber numberWithUnsignedInteger:PPStorageSpaceSelectSectionControllerRow_Huawei]
//                                               cloudClass:[PPCloud_Huawei class]];
//                }
//
//                break;
//            }
            case PPStorageSpaceSelectSectionControllerRow_iCloud:
            {
                break;
            }
            case PPStorageSpaceSelectSectionControllerRow_iTune:
            {
                break;
            }
            case PPStorageSpaceSelectSectionControllerRow_AddressBook:
            {
                break;
            }
            case PPStorageSpaceSelectSectionControllerRow_Salesforce:
            case PPStorageSpaceSelectSectionControllerRow_ExchangeServer:
            {
                // !! Salesforce, exchange server 不論是不是 link，直接把點選告知外部
                
                [self decideStorageSpaceSelectSectionSpaceTypeFromStorageSpaceSelectSectionControllerRow:storageSpaceSelectSectionControllerRow];
                
                break;
            }
            default:
            {
                break;
            }
        }
    }
    else
    {
        NSError *error = PPErrorMake(PPStorageSpaceSelectControllerErrorCode_NetworkDisconnected, PSSSVC_MLS_ErrorNetworkReachableNone, nil);
        
        [self showAlertWithError:error];
    }
}


//================================================================================
//
//================================================================================
- (PPStorageSpaceSelectControllerSpaceType)storageSpaceSelectSectionSpaceTypeFromStorageSpaceSelectSectionControllerRow:(PPStorageSpaceSelectSectionControllerRow)storageSpaceSelectSectionControllerRow
{
    PPStorageSpaceSelectControllerSpaceType spaceType = PPStorageSpaceSelectControllerSpaceType_AddressBook;
    
    switch (storageSpaceSelectSectionControllerRow)
    {
        case PPStorageSpaceSelectSectionControllerRow_Baidu:
        {
            spaceType = PPStorageSpaceSelectControllerSpaceType_Baidu;
            break;
        }
        case PPStorageSpaceSelectSectionControllerRow_Dropbox:
        {
            spaceType = PPStorageSpaceSelectControllerSpaceType_Dropbox;
            break;
        }
        case PPStorageSpaceSelectSectionControllerRow_GoogleDrive:
        {
            spaceType = PPStorageSpaceSelectControllerSpaceType_GoogleDrive;
            break;
        }
        case PPStorageSpaceSelectSectionControllerRow_OneDrive:
        {
            spaceType = PPStorageSpaceSelectControllerSpaceType_OneDrive;
            break;
        }
        case PPStorageSpaceSelectSectionControllerRow_Huawei:
        {
            spaceType = PPStorageSpaceSelectControllerSpaceType_Huawei;
            break;
        }
        case PPStorageSpaceSelectSectionControllerRow_iCloud:
        {
            spaceType = PPStorageSpaceSelectControllerSpaceType_iCloud;
            break;
        }
        case PPStorageSpaceSelectSectionControllerRow_iTune:
        {
            spaceType = PPStorageSpaceSelectControllerSpaceType_iTune;
            break;
        }
        case PPStorageSpaceSelectSectionControllerRow_AddressBook:
        {
            spaceType = PPStorageSpaceSelectControllerSpaceType_AddressBook;
            break;
        }
        case PPStorageSpaceSelectSectionControllerRow_Salesforce:
        {
            spaceType = PPStorageSpaceSelectControllerSpaceType_Salesforce;
            break;
        }
        case PPStorageSpaceSelectSectionControllerRow_ExchangeServer:
        {
            spaceType = PPStorageSpaceSelectControllerSpaceType_ExchangeServer;
            break;
        }
        case PPStorageSpaceSelectSectionControllerRow_Specific:
        {
            spaceType = PPStorageSpaceSelectControllerSpaceType_Specific;
            break;
        }
        default:
        {
            
            break;
        }
    }
    
    return spaceType;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private InterfaceOrientation Method

//================================================================================
//
//================================================================================
- (void)adjustInterfaceOrientation
{
    //若其它頁面是橫式，回來時編輯是橫式，檢查mask，若不符合橫式要求，要強制轉直
    if(self.ppInterfaceOrientationController.mask==PPInterfaceOrientationControllerMask_Portrait ||
       self.ppInterfaceOrientationController.mask==PPInterfaceOrientationControllerMask_PortraitUpsideDown)
    {
        UIDeviceOrientation deviceOrientation = [UIDevice currentDevice].orientation;
        
        if((deviceOrientation == UIDeviceOrientationLandscapeLeft ||
            deviceOrientation == UIDeviceOrientationLandscapeRight) &&
           UIInterfaceOrientationIsLandscape(self.interfaceOrientation)==YES)
        {
            self.originalDeviceOrientation = deviceOrientation;
            
            [[UIDevice currentDevice] setValue:@(UIDeviceOrientationPortrait) forKey:@"orientation"];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)restoreInterfaceOrientation
{
    if(self.ppInterfaceOrientationController.mask==PPInterfaceOrientationControllerMask_Portrait ||
       self.ppInterfaceOrientationController.mask==PPInterfaceOrientationControllerMask_PortraitUpsideDown)
    {
        //因為有做強制旋轉的方向，所以返回時要做還原旋轉的方向，
        //此類別中，只對 UIDeviceOrientationLandscapeLeft, UIDeviceOrientationLandscapeRight 做強制轉直
        //所以檢查紀錄裝置方向有無異動，若異動則 Device 方向會在修正，就不用在做還原
        
        if(self.deviceDidChanged==YES)
        {
            self.deviceDidChanged = NO;
            
            [[UIDevice currentDevice] setValue:@(self.originalDeviceOrientation) forKey:@"orientation"];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private wait methods

//================================================================================
//
//================================================================================
- (void)waitUntilCloudOperationFinished
{
    NSTimeInterval timeInterval = 0.01;
    BOOL isMainThread = [NSThread isMainThread];
    
    // 確認條件
    while ([PPCloudController operationCount]>0)
    {
        if(isMainThread == YES)
        {
            @autoreleasepool
            {
                [[NSRunLoop currentRunLoop] runUntilDate:[NSDate dateWithTimeIntervalSinceNow:timeInterval]];
            }
        }
        else
        {
            [NSThread sleepForTimeInterval:timeInterval];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Notification Method

//================================================================================
//
//================================================================================
- (void)recvDeviceOrientationDidChangeNotification:(NSNotification *)notification
{
    //只需紀錄裝置方向有無在異動即可
    
    self.deviceDidChanged = YES;
    
    //////////////////////////////////////////////////
    
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UIDeviceOrientationDidChangeNotification object:nil];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Account Info Method

//================================================================================
//
//================================================================================
- (void)checkAccountInfoTask
{
    [self.accountInfoTask removeAllObjects];
    
    //////////////////////////////////////////////////

    for(NSUInteger row=0; row<[self.storageSpaceSelectSectionController rowObjectsCountForSearching:NO]; row++)
    {
        PPSpaceRowModel *spaceRowModel = (PPSpaceRowModel *)[self.storageSpaceSelectSectionController rowModelAtIndex:row forSearching:NO];
        
        //////////////////////////////////////////////////
        
        if([self.storageSpaceSelectSectionController needFetchAccoutInfoWithRow:row]==YES)
        {
            switch (spaceRowModel.storageSpaceSelectSectionControllerRow)
            {
                case PPStorageSpaceSelectSectionControllerRow_Baidu:
                {
                    break;
                }
                case PPStorageSpaceSelectSectionControllerRow_Dropbox:
                {
                    [self.accountInfoTask addObject:@(spaceRowModel.storageSpaceSelectSectionControllerRow)];

                    break;
                }
                case PPStorageSpaceSelectSectionControllerRow_GoogleDrive:
                {
                    [self.accountInfoTask addObject:@(spaceRowModel.storageSpaceSelectSectionControllerRow)];

                    break;
                }
                case PPStorageSpaceSelectSectionControllerRow_OneDrive:
                {
                    [self.accountInfoTask addObject:@(spaceRowModel.storageSpaceSelectSectionControllerRow)];
                    
                    break;
                }
                case PPStorageSpaceSelectSectionControllerRow_Huawei:
                {
                    [self.accountInfoTask addObject:@(spaceRowModel.storageSpaceSelectSectionControllerRow)];

                    break;
                }
                case PPStorageSpaceSelectSectionControllerRow_Salesforce:
                case PPStorageSpaceSelectSectionControllerRow_ExchangeServer:
                {
                    [self.accountInfoTask addObject:@(spaceRowModel.storageSpaceSelectSectionControllerRow)];
                    break;
                }
                case PPStorageSpaceSelectSectionControllerRow_iCloud:
                case PPStorageSpaceSelectSectionControllerRow_iTune:
                case PPStorageSpaceSelectSectionControllerRow_AddressBook:
                default:
                {
                    break;
                }
            }
        }
    }
}


//================================================================================
//
//================================================================================
- (void)startLoadAccountInfo
{
    for(NSUInteger taskIndex=0; taskIndex<self.accountInfoTask.count; taskIndex++)
    {
        NSUInteger storageSpaceSelectSectionControllerRow = [[self.accountInfoTask objectAtIndex:taskIndex] unsignedIntegerValue];
        
        switch (storageSpaceSelectSectionControllerRow)
        {
            case PPStorageSpaceSelectSectionControllerRow_Baidu:
            {
                break;
            }
            case PPStorageSpaceSelectSectionControllerRow_Dropbox:
            {
                [PPCloudController loadAccountInfoWithDelegate:self
                                                      userInfo:@(storageSpaceSelectSectionControllerRow)
                                                    cloudClass:[PPCloud_Dropbox class]];
                
                
                break;
            }
            case PPStorageSpaceSelectSectionControllerRow_GoogleDrive:
            {
                [PPCloudController loadAccountInfoWithDelegate:self
                                                      userInfo:@(storageSpaceSelectSectionControllerRow)
                                                    cloudClass:[PPCloud_GoogleDrive class]];
                
                break;
            }
            case PPStorageSpaceSelectSectionControllerRow_OneDrive:
            {
                [PPCloudController loadAccountInfoWithDelegate:self
                                                      userInfo:@(storageSpaceSelectSectionControllerRow)
                                                    cloudClass:[PPCloud_OneDrive class]];
                
                break;
            }
//            case PPStorageSpaceSelectSectionControllerRow_Huawei:
//            {
//                [PPCloudController loadAccountInfoWithDelegate:self
//                                                      userInfo:@(storageSpaceSelectSectionControllerRow)
//                                                    cloudClass:[PPCloud_Huawei class]];
//                break;
//            }
            case PPStorageSpaceSelectSectionControllerRow_Salesforce:
            {
                [self requestLoadAccountInfoWithSalesforce];
                
                break;
            }
            case PPStorageSpaceSelectSectionControllerRow_ExchangeServer:
            {
                [self requestLoadAccountInfoWithExchangeServer];
                
                break;
            }
            case PPStorageSpaceSelectSectionControllerRow_iCloud:
            case PPStorageSpaceSelectSectionControllerRow_iTune:
            case PPStorageSpaceSelectSectionControllerRow_AddressBook:
            default:
            {
                break;
            }
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private isLink Method

//================================================================================
//
//================================================================================
- (void)checkIsLink
{
    do
    {
        NSMutableArray *reloadIndexPathes = [NSMutableArray array];
        
        if(reloadIndexPathes==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        // isLink有些空間要連線檢查，改到 bg Thread 做
        
        @autoreleasepool
        {
            for(PPSectionModel *sectionModel in self.storageSpaceSelectSectionController.sectionModelsForDefault)
            {
                NSUInteger section = [self.storageSpaceSelectSectionController.sectionModelsForDefault indexOfObject:sectionModel];
                
                for(PPSpaceRowModel *rowModel in sectionModel.rowModels)
                {
                    NSUInteger row = [sectionModel.rowModels indexOfObject:rowModel];
                    rowModel.detailText = nil;
                    
                    //////////////////////////////////////////////////
                    
                    switch (rowModel.storageSpaceSelectSectionControllerRow)
                    {
                        case PPStorageSpaceSelectSectionControllerRow_Dropbox:
                        {
                            NSNumber *oldValue = rowModel.object;

                            rowModel.object = [NSNumber numberWithBool:[PPCloudController isLinkedWithCloudClass:[PPCloud_Dropbox class]]];
                            
                            if([rowModel.object boolValue]==YES)
                            {
                                rowModel.detailText = [PPSettingsController stringValueWithKey:PSSSVCSettingKey_DropboxAccountName];
                                
                                //////////////////////////////////////////////////
                                
                                [reloadIndexPathes addObject:[NSIndexPath indexPathForRow:row inSection:section]];
                            }
                            else
                            {
                                [PPSettingsController setStringValue:@"" withKey:PSSSVCSettingKey_DropboxAccountName];
                            }
                            
                            // !! 與之前不一致就要更新
                            if([oldValue boolValue]!=[rowModel.object boolValue])
                            {
                                [self updateCellContentForStorageSpaceSelectSectionControllerRow:PPStorageSpaceSelectSectionControllerRow_GoogleDrive];
                            }
                            break;
                        }
                        case PPStorageSpaceSelectSectionControllerRow_GoogleDrive:
                        {
                            NSNumber *oldValue = rowModel.object;
                            
                            rowModel.object = [NSNumber numberWithBool:[PPCloudController isLinkedWithCloudClass:[PPCloud_GoogleDrive class]]];
                            
                            if([rowModel.object boolValue]==YES)
                            {
                                rowModel.detailText = [PPSettingsController stringValueWithKey:PSSSVCSettingKey_GoogleDriveccountName];
                                
                                //////////////////////////////////////////////////
                                
                                [reloadIndexPathes addObject:[NSIndexPath indexPathForRow:row inSection:section]];
                            }
                            else
                            {
                                [PPSettingsController setStringValue:@"" withKey:PSSSVCSettingKey_GoogleDriveccountName];
                            }
                            
                            // !! 與之前不一致就要更新
                            if([oldValue boolValue]!=[rowModel.object boolValue])
                            {
                                [self updateCellContentForStorageSpaceSelectSectionControllerRow:PPStorageSpaceSelectSectionControllerRow_GoogleDrive];
                            }
                            break;
                        }
                        case PPStorageSpaceSelectSectionControllerRow_OneDrive:
                        {
                            NSNumber *oldValue = rowModel.object;

                            rowModel.object = [NSNumber numberWithBool:[PPCloudController isLinkedWithCloudClass:[PPCloud_OneDrive class]]];
                            
                            if([rowModel.object boolValue]==YES)
                            {
                                rowModel.detailText = [PPSettingsController stringValueWithKey:PSSSVCSettingKey_OneDriveAccountName];
                                
                                //////////////////////////////////////////////////
                                
                                [reloadIndexPathes addObject:[NSIndexPath indexPathForRow:row inSection:section]];
                            }
                            else
                            {
                                [PPSettingsController setStringValue:@"" withKey:PSSSVCSettingKey_OneDriveAccountName];
                            }
                            // !! 與之前不一致就要更新
                            if([oldValue boolValue]!=[rowModel.object boolValue])
                            {
                                [self updateCellContentForStorageSpaceSelectSectionControllerRow:PPStorageSpaceSelectSectionControllerRow_GoogleDrive];
                            }
                            break;
                        }
//                        case PPStorageSpaceSelectSectionControllerRow_Huawei:
//                        {
//                            rowModel.object = [NSNumber numberWithBool:[PPCloudController isLinkedWithCloudClass:[PPCloud_Huawei class]]];
//                            
//                            if([rowModel.object boolValue]==YES)
//                            {
//                                rowModel.detailText = [PPSettingsController stringValueWithKey:PSSSVCSettingKey_HwaweiAccountName];
//                                
//                                //////////////////////////////////////////////////
//                                
//                                [reloadIndexPathes addObject:[NSIndexPath indexPathForRow:row inSection:section]];
//                            }
//                            else
//                            {
//                                [PPSettingsController setStringValue:@"" withKey:PSSSVCSettingKey_HwaweiAccountName];
//                            }
//                            
//                            break;
//                        }
                        case PPStorageSpaceSelectSectionControllerRow_iCloud:
                        {
                            rowModel.text = PSSSVC_MLS_iCloud;
                            
                            rowModel.object = [NSNumber numberWithBool:[PPCloudController isLinkedWithCloudClass:[PPCloud_iCloud class]]];
                            
                            break;
                        }
                        case PPStorageSpaceSelectSectionControllerRow_Salesforce:
                        {
                            if([self.delegate respondsToSelector:@selector(storageSpaceSelectViewController:isLinkWithSpaceType:)]==YES)
                            {
                                rowModel.object = @([self.delegate storageSpaceSelectViewController:self
                                                                                isLinkWithSpaceType:PPStorageSpaceSelectControllerSpaceType_Salesforce]);
                                
                                //////////////////////////////////////////////////

                                if([rowModel.object boolValue]==YES)
                                {
                                    rowModel.detailText = [PPSettingsController stringValueWithKey:PSSSVCSettingKey_SalesforceAccountName];
                                    
                                    //////////////////////////////////////////////////
                                    
                                    [reloadIndexPathes addObject:[NSIndexPath indexPathForRow:row inSection:section]];
                                }
                                else
                                {
                                    [PPSettingsController setStringValue:@"" withKey:PSSSVCSettingKey_SalesforceAccountName];
                                }
                                
                            }
                            else
                            {
                                rowModel.object = @(NO);
                                
                                [PPSettingsController setStringValue:@"" withKey:PSSSVCSettingKey_SalesforceAccountName];
                            }
                            
                            break;
                        }
                        case PPStorageSpaceSelectSectionControllerRow_ExchangeServer:
                        {
                            if([self.delegate respondsToSelector:@selector(storageSpaceSelectViewController:isLinkWithSpaceType:)]==YES)
                            {
                                rowModel.object = @([self.delegate storageSpaceSelectViewController:self
                                                                                isLinkWithSpaceType:PPStorageSpaceSelectControllerSpaceType_ExchangeServer]);
                                
                                //////////////////////////////////////////////////
                                
                                if([rowModel.object boolValue]==YES)
                                {
                                    rowModel.detailText = [PPSettingsController stringValueWithKey:PSSSVCSettingKey_ExchangeServerAccountName];
                                    
                                    //////////////////////////////////////////////////
                                    
                                    [reloadIndexPathes addObject:[NSIndexPath indexPathForRow:row inSection:section]];
                                }
                                else
                                {
                                    [PPSettingsController setStringValue:@"" withKey:PSSSVCSettingKey_ExchangeServerAccountName];
                                }
                                
                            }
                            else
                            {
                                rowModel.object = @(NO);
                                
                                [PPSettingsController setStringValue:@"" withKey:PSSSVCSettingKey_SalesforceAccountName];
                            }
                            
                            break;
                        }
                        case PPStorageSpaceSelectSectionControllerRow_Baidu:
                        case PPStorageSpaceSelectSectionControllerRow_iTune:
                        case PPStorageSpaceSelectSectionControllerRow_AddressBook:
                        case PPStorageSpaceSelectSectionControllerRow_Specific:
                        default:
                        {
                            break;
                        }
                    }
                }
            }
            
            //////////////////////////////////////////////////
            
            if(reloadIndexPathes.count>0)
            {
                __block typeof(self) blockself = self;
                
                dispatch_sync(dispatch_get_main_queue(), ^{
                    [blockself.storageSpaceSelectTableView reloadRowsAtIndexPaths:reloadIndexPathes
                                                                 withRowAnimation:UITableViewRowAnimationNone];
                });
            }
            
            // autorelease pool
        }
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Update cell Method

//================================================================================
//
//================================================================================
- (void)updateCellContentForStorageSpaceSelectSectionControllerRow:(PPStorageSpaceSelectSectionControllerRow)storageSpaceSelectSectionControllerRow
{
    NSUInteger row = [self.storageSpaceSelectSectionController indexPathRowForStorageSpaceSelectSectionControllerRow:storageSpaceSelectSectionControllerRow];
    
    NSIndexPath *indexPath = [NSIndexPath indexPathForRow:row inSection:0];
    
    if(indexPath!=nil &&
       [self.storageSpaceSelectSectionController rowModelAtIndexPath:indexPath forSearching:NO]!=nil)
    {
        __block typeof(self) blockself = self;
        
        dispatch_async(dispatch_get_main_queue(), ^{
            
            if(blockself.storageSpaceSelectTableView!=nil)
            {
                [blockself.storageSpaceSelectTableView reloadRowsAtIndexPaths:@[indexPath]
                                                             withRowAnimation:UITableViewRowAnimationNone];
                
                if(blockself.autoSwitchToFileSelect==YES ||
                   blockself.accountInfoTask.count<=0)
                {
                    [blockself showBusyView:NO withSuperView:nil];
                }
            }
        });
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Record Account Name

//================================================================================
//
//================================================================================
- (void)recordAccountName:(NSString *)accountName withsStorageSpaceSelectSectionControllerRow:(PPStorageSpaceSelectSectionControllerRow)storageSpaceSelectSectionControllerRow
{
    switch (storageSpaceSelectSectionControllerRow)
    {
        case PPStorageSpaceSelectSectionControllerRow_Dropbox:
        {
            [PPSettingsController setStringValue:accountName withKey:PSSSVCSettingKey_DropboxAccountName];
            break;
        }
        case PPStorageSpaceSelectSectionControllerRow_GoogleDrive:
        {
            [PPSettingsController setStringValue:accountName withKey:PSSSVCSettingKey_GoogleDriveccountName];
            break;
        }
        case PPStorageSpaceSelectSectionControllerRow_OneDrive:
        {
            [PPSettingsController setStringValue:accountName withKey:PSSSVCSettingKey_OneDriveAccountName];
            break;
        }
        case PPStorageSpaceSelectSectionControllerRow_Huawei:
        {
            [PPSettingsController setStringValue:accountName withKey:PSSSVCSettingKey_HwaweiAccountName];
            break;
        }
        case PPStorageSpaceSelectSectionControllerRow_Salesforce:
        {
            [PPSettingsController setStringValue:accountName withKey:PSSSVCSettingKey_SalesforceAccountName];
            break;
        }
        case PPStorageSpaceSelectSectionControllerRow_ExchangeServer:
        {
            [PPSettingsController setStringValue:accountName withKey:PSSSVCSettingKey_ExchangeServerAccountName];
            break;
        }
        default:
        {
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Show BusyView Method

//================================================================================
//
//================================================================================
- (void)showBusyView:(BOOL)show withSuperView:(UIView *)superView
{
    if(show==YES && self.busyView==nil)
    {
        self.busyView = [[[PPBusyView alloc] initWithSuperView:superView] autorelease];
    }
    else
    {
        [self.busyView removeFromSuperview];
        self.busyView = nil;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private send delegate method

//================================================================================
//
//================================================================================
- (void)decideStorageSpaceSelectSectionSpaceTypeFromStorageSpaceSelectSectionControllerRow:(PPStorageSpaceSelectSectionControllerRow)storageSpaceSelectSectionControllerRow
{
    //決定選擇哪個空間之後，就直接取消讀取帳號資訊的動作
    [self.accountInfoTask removeAllObjects];
    
    //////////////////////////////////////////////////
    
    __block typeof(self) blockself = self;
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        [PPCloudController cancelAllOperations];
        
        //////////////////////////////////////////////////
        
        dispatch_async(dispatch_get_main_queue(), ^{

            [blockself.delegate storageSpaceSelectViewController:blockself
                        didStorageSpaceSelectControllerSpaceType:[blockself storageSpaceSelectSectionSpaceTypeFromStorageSpaceSelectSectionControllerRow:storageSpaceSelectSectionControllerRow]];
        });
    });

}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Salesforce Method

//================================================================================
//
//================================================================================
- (void)requestLoadAccountInfoWithSalesforce
{
    NSError *returnError = nil;
    NSString *accountName = nil;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(storageSpaceSelectViewController:accountNameWithSpaceType:error:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        accountName = [self.delegate storageSpaceSelectViewController:self
                                             accountNameWithSpaceType:PPStorageSpaceSelectControllerSpaceType_Salesforce
                                                                error:&returnError];
    }
    while (0);
    
    //////////////////////////////////////////////////
    
    // !! 將讀取帳號資訊流程導至和 PPCloud 空間所使用的流程一致
    
    __block typeof(self) blockself = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        if(accountName==nil)
        {
            [blockself ppCloud:nil
loadAccountInfoFailedWithError:returnError
                 userInfo:@(PPStorageSpaceSelectSectionControllerRow_Salesforce)];
        }
        else
        {
            PPCloudAccountInfo *accountInfo = [[PPCloudAccountInfo alloc] init];
            
            if(accountInfo!=nil)
            {
                accountInfo.displayName = accountName;
            }
            
            //////////////////////////////////////////////////
            
            [blockself ppCloud:nil
        loadedAccountInfo:accountInfo
                 userInfo:@(PPStorageSpaceSelectSectionControllerRow_Salesforce)];
            
            [accountInfo release];
        }
    });
 
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private ExchangeServer Method

//================================================================================
//
//================================================================================
- (void)requestLoadAccountInfoWithExchangeServer
{
    NSError *returnError = nil;
    NSString *accountName = nil;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(storageSpaceSelectViewController:accountNameWithSpaceType:error:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        accountName = [self.delegate storageSpaceSelectViewController:self
                                             accountNameWithSpaceType:PPStorageSpaceSelectControllerSpaceType_ExchangeServer
                                                                error:&returnError];
    }
    while (0);
    
    //////////////////////////////////////////////////
    
    // !! 將讀取帳號資訊流程導至和 PPCloud 空間所使用的流程一致
    
    __block typeof(self) blockself = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        if(accountName==nil)
        {
            [blockself ppCloud:nil
loadAccountInfoFailedWithError:returnError
                 userInfo:@(PPStorageSpaceSelectControllerSpaceType_ExchangeServer)];
        }
        else
        {
            PPCloudAccountInfo *accountInfo = [[PPCloudAccountInfo alloc] init];
            
            if(accountInfo!=nil)
            {
                accountInfo.displayName = accountName;
            }
            
            //////////////////////////////////////////////////
            
            [blockself ppCloud:nil
        loadedAccountInfo:accountInfo
                 userInfo:@(PPStorageSpaceSelectControllerSpaceType_ExchangeServer)];
            
            [accountInfo release];
        }
    });
 
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPAlertView Method

//================================================================================
//
//================================================================================
- (void)showAlertWithError:(NSError *)error
{
    BOOL showAlert = YES;
    
    if([self.delegate respondsToSelector:@selector(storageSpaceSelectViewControllerShowAlertWithError:)]==YES)
    {
        showAlert = [self.delegate storageSpaceSelectViewControllerShowAlertWithError:error];
    }
    
    //////////////////////////////////////////////////

    if(showAlert==YES)
    {
        NSString *message = nil;
        
        //////////////////////////////////////////////////
        
        if([self.delegate respondsToSelector:@selector(storageSpaceSelectViewControllerRequestErrorMessageWithError:)]==YES)
        {
            message = [self.delegate storageSpaceSelectViewControllerRequestErrorMessageWithError:error];
        }
        
        //////////////////////////////////////////////////

        //外部沒客製化錯誤訊息
        if([message length]<=0)
        {
            message = [error alertMessage];
        }
        
        //////////////////////////////////////////////////
        
        dispatch_async(dispatch_get_main_queue(), ^{
            PPAlertView *alertView = [[PPAlertView alloc] initWithTitle:@""
                                                                message:message
                                                               delegate:nil
                                                      cancelButtonTitle:PSSSVC_MLS_OK
                                                      otherButtonTitles:nil];
            
            [alertView show];
            
            [alertView release];
        });
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButton Delegate Method

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case PPStorageSpaceSelectSectionControllerButtonTag_Back:
        {
            
            if([self.delegate respondsToSelector:@selector(storageSpaceSelectViewControllerDidCancel:)]==YES)
            {
                //離開空間後，就直接取消讀取帳號資訊的動作
                [self.accountInfoTask removeAllObjects];
                
                //////////////////////////////////////////////////
                
                __block typeof(self) blockself = self;
                
                dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
                    
                    [PPCloudController cancelAllOperations];
                    
                    //////////////////////////////////////////////////
                    
                    dispatch_async(dispatch_get_main_queue(), ^{
                        
//                        [blockself waitUntilCloudOperationFinished];
                        
                        //////////////////////////////////////////////////
                        
                        [blockself.delegate storageSpaceSelectViewControllerDidCancel:self];
                    });
                });
            }
            
            break;
        }
        default:
        {
            break;
        }
    }
}





//================================================================================
//
//================================================================================
- (void)cleanAccountNameForSpaceType:(PPStorageSpaceSelectControllerSpaceType)spaceType
{
    switch (spaceType)
    {
        case PPStorageSpaceSelectControllerSpaceType_Huawei:
        {
            [PPSettingsController removeValueWithKey:PSSSVCSettingKey_HwaweiAccountName];
            
            break;
        }
        case PPStorageSpaceSelectControllerSpaceType_Dropbox:
        {
            [PPSettingsController removeValueWithKey:PSSSVCSettingKey_DropboxAccountName];
            
            break;
        }
        case PPStorageSpaceSelectControllerSpaceType_GoogleDrive:
        {
            [PPSettingsController removeValueWithKey:PSSSVCSettingKey_GoogleDriveccountName];
            
            break;
        }
        case PPStorageSpaceSelectControllerSpaceType_Salesforce:
        {
            [PPSettingsController removeValueWithKey:PSSSVCSettingKey_SalesforceAccountName];
         
            break;
        }
        default:
        {
            break;
        }
    }
}

@end
