//
//  PPStorageFileSelectViewController.m
//
//
//  Created by Howard.Lin on 2014/3/18.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "PPStorageFileSelectViewController.h"

// Define
#import "PPStorageFileSelectViewController+PrivateParameterDefine.h"
#import "PPStorageFileSelectViewController+ResourceDefine.h"

// View
#import "PPButton.h"
#import "PPCancelBusyView.h"
#import "PPTableView.h"
#import "PPTableViewCell.h"
#import "PPStorageFileSelectNavigationBarView.h"

// Controller
#import "PPBackgroundTaskController.h"
#import "PPSectionController.h"
#import "PPStorageFileFetch_Dropbox.h"
#import "PPStorageFileFetch_GoogleDrive.h"
#import "PPStorageFileFetch_OneDrive.h"
#import "PPStorageFileFetch_iTune.h"
#import "PPStorageFileFetch_iCloud.h"
#import "PPAlertController.h"

// Category
#import "NSError+Custom.h"
#import "NSString+Additions.h"
#import "UIViewController+ShareApplication.h"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPStorageFileSelectViewController ()
<
PPCancelBusyViewDelegate,
PPStorageFileFetchDelegate,
PPStorageFileSelectNavigationBarViewDelegate,
UITableViewDataSource,
UITableViewDelegate
>

@property (nonatomic,retain)   PPSectionController                      *storageFileSelectSectionController;
@property (nonatomic,retain)   PPStorageFileSelectNavigationBarView     *storageFileSelectNavigationBarView;
@property (nonatomic,retain)   PPStorageFileFetch                       *storageFileFetchObject;
@property (nonatomic,retain)   PPCancelBusyView                         *ppCancelBusyView;
@property (nonatomic,retain)   PPTableView                              *storageFileSelectTableView;
@property (nonatomic,retain)   UILabel                                  *headerTitleLabel;
@property (nonatomic,retain)   NSMutableArray                           *selectedFileArray;

@end

//////////////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPStorageFileSelectViewController

//////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)init
{
    do
    {
        if(self = [super init])
        {
            self.hidesBottomBarWhenPushed = YES;
            
            _storageFileSelectSectionController = [[PPSectionController alloc] init];
            
            //////////////////////////////////////////////////
            
            _selectedFileArray = [[NSMutableArray alloc] init];
            
            //////////////////////////////////////////////////
            
            _tableViewCellHeight = PPStorageFileSelectViewTableViewHeight;
            
            //////////////////////////////////////////////////
            
            _headerTitleLabelHeight = PPStorageFileSelectViewControllerLabelHeight;
            
            //////////////////////////////////////////////////
            
            _navigationViewButtonImageEdgeInsets = PPStorageFileSelectViewControllerButtonImageInsets;
        }
    }
    while (0);
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _delegate = nil;
    
    [_userInfo release];
    _userInfo = nil;
    
    [_storageFileSelectSectionController release];
    _storageFileSelectSectionController = nil;
    
    [_storageFileFetchObject release];
    _storageFileFetchObject = nil;
    
    [_ppCancelBusyView removeFromSuperview];
    [_ppCancelBusyView release];
    _ppCancelBusyView = nil;
    
    _storageFileSelectNavigationBarView.delegate = nil;
    [_storageFileSelectNavigationBarView removeFromSuperview];
    _storageFileSelectNavigationBarView = nil;
    
    _storageFileSelectTableView.dataSource = nil;
    _storageFileSelectTableView.delegate = nil;
    [_storageFileSelectTableView removeFromSuperview];
    [_storageFileSelectTableView release];
    _storageFileSelectTableView = nil;
    
    [_selectedFileArray removeAllObjects];
    [_selectedFileArray release];
    _selectedFileArray = nil;
    
    
    //////////////////////////////////////////////////
    
    [_extensionFileNameArray release];
    _extensionFileNameArray = nil;
    
    [_sectionTitleDictionary release];
    _sectionTitleDictionary = nil;
    
    [_controllerTitle release];
    _controllerTitle = nil;
    
    [_headerTitleLabelText release];
    _headerTitleLabelText = nil;
    
    [_navigationViewButtonHighlightedBackgroundColor release];
    _navigationViewButtonHighlightedBackgroundColor = nil;
    
    [_navigationViewButtonHighlightedTitleColor release];
    _navigationViewButtonHighlightedTitleColor = nil;
    
    [_navigationViewButtonNormalTitleColor release];
    _navigationViewButtonNormalTitleColor = nil;
    
    [_tableViewCellNormalTextColor release];
    _tableViewCellNormalTextColor = nil;
    
    [_tableViewCellNormalDetailTextColor release];
    _tableViewCellNormalDetailTextColor = nil;
    
    [_tableViewSeperatorColor release];
    _tableViewSeperatorColor = nil;
    
    [_tableViewCellHighlightedBackgroundColor release];
    _tableViewCellHighlightedBackgroundColor = nil;
    
    
    [_defaultRootFilePath release];
    _defaultRootFilePath = nil;
    
    [_headerTitleLabel release];
    _headerTitleLabel = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





//////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    [self showCancelBusyView:YES withSuperView:[UIApplication sharedApplication].keyWindow showButton:NO];
    
    //////////////////////////////////////////////////
    
    //暫存選取資訊，要重設
    [self.selectedFileArray removeAllObjects];
    
    //////////////////////////////////////////////////
    
    self.storageFileFetchObject = [self curStorageFileFetchForStorage];
    
    //////////////////////////////////////////////////
    
    if([self fetchSpaceFileList]==NO)
    {
        [self showCancelBusyView:NO withSuperView:nil showButton:NO];
    }
    
    //////////////////////////////////////////////////
    
    if(self.storageFileSelectNavigationBarView==nil)
    {
        _storageFileSelectNavigationBarView = [[PPStorageFileSelectNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    }
    
    if(self.storageFileSelectNavigationBarView!=nil)
    {
        [self.storageFileSelectNavigationBarView setDelegate:self];
        self.storageFileSelectNavigationBarView.backorDoneButton.hidden = self.hidenBackButton;
        self.storageFileSelectNavigationBarView.titleLabel.text = self.controllerTitle;
        
        //////////////////////////////////////////////////
        
        if(self.navigationViewButtonNormalTitleColor!=nil)
        {
            [self.storageFileSelectNavigationBarView.backorDoneButton setTitleColor:self.navigationViewButtonNormalTitleColor forState:UIControlStateNormal];
            
            [self.storageFileSelectNavigationBarView.editButton setTitleColor:self.navigationViewButtonNormalTitleColor forState:UIControlStateNormal];
            
            [self.storageFileSelectNavigationBarView.importButton setTitleColor:self.navigationViewButtonNormalTitleColor forState:UIControlStateNormal];
        }
        
        //////////////////////////////////////////////////
        
        if(self.navigationViewButtonHighlightedTitleColor!=nil)
        {
            [self.storageFileSelectNavigationBarView.backorDoneButton setTitleColor:self.navigationViewButtonHighlightedTitleColor forState:UIControlStateHighlighted];
            
            [self.storageFileSelectNavigationBarView.editButton setTitleColor:self.navigationViewButtonHighlightedTitleColor forState:UIControlStateHighlighted];
            
            [self.storageFileSelectNavigationBarView.importButton setTitleColor:self.navigationViewButtonHighlightedTitleColor forState:UIControlStateHighlighted];
        }
        
        //////////////////////////////////////////////////
        
        if(self.navigationViewButtonHighlightedBackgroundColor!=nil)
        {
            [self.storageFileSelectNavigationBarView.backorDoneButton setBackgroundImage:[UIImage imageWithColor:self.navigationViewButtonHighlightedBackgroundColor] forState:UIControlStateHighlighted];
            
            [self.storageFileSelectNavigationBarView.editButton setBackgroundImage:[UIImage imageWithColor:self.navigationViewButtonHighlightedBackgroundColor] forState:UIControlStateHighlighted];
            
            [self.storageFileSelectNavigationBarView.importButton setBackgroundImage:[UIImage imageWithColor:self.navigationViewButtonHighlightedBackgroundColor] forState:UIControlStateHighlighted];
        }
        
        //////////////////////////////////////////////////
        
        PPBarViewItemModel *itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.storageFileSelectNavigationBarView.backorDoneButton];
        
        if(itemModel!=nil)
        {
            if(self.storageFileSelectNavigationBarView.backorDoneButton.imageView.image==nil)
            {
                itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            }
            else
            {
                itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            }
            
            [self.storageFileSelectNavigationBarView setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
        }
        
        //////////////////////////////////////////////////
        
        self.storageFileSelectNavigationBarView.backorDoneButton.imageEdgeInsets = self.navigationViewButtonImageEdgeInsets;
        self.storageFileSelectNavigationBarView.editButton.imageEdgeInsets = self.navigationViewButtonImageEdgeInsets;
        self.storageFileSelectNavigationBarView.importButton.imageEdgeInsets = self.navigationViewButtonImageEdgeInsets;
        
        //////////////////////////////////////////////////
        
        PPBarViewItemModel * editItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.storageFileSelectNavigationBarView.editButton];
        
        if(editItemModel!=nil)
        {
            editItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            //////////////////////////////////////////////////
            
            if(self.multiSelection==YES)
            {
                PPBarViewItemModel * importItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.storageFileSelectNavigationBarView.importButton];
                
                if(importItemModel!=nil)
                {
                    importItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                    
                    //////////////////////////////////////////////////
                    
                    [self.storageFileSelectNavigationBarView setItemModels:@[editItemModel,importItemModel] forBlockType:PPBarViewBlockType_Right];
                }
            }
            else
            {
                [self.storageFileSelectNavigationBarView setItemModels:@[editItemModel] forBlockType:PPBarViewBlockType_Right];
            }
        }
    }
    
    //////////////////////////////////////////////////
    
    //覆蓋上方列
    if(self.storageFileSelectNavigationBarView!=nil
       && self.navigationController!=nil)
    {
        UIBarButtonItem *leftButtonItem = [[UIBarButtonItem alloc] initWithCustomView:self.storageFileSelectNavigationBarView];
        
        if(leftButtonItem!=nil)
        {
            self.navigationItem.leftBarButtonItem = leftButtonItem;
        }
        
        [leftButtonItem release];
    }
    
    //////////////////////////////////////////////////
    
    self.storageFileSelectTableView = [[[PPTableView alloc] initWithFrame:CGRectZero style:UITableViewStyleGrouped] autorelease];
    
    if(self.storageFileSelectTableView!=nil)
    {
        [self.storageFileSelectTableView setDataSource:self];
        [self.storageFileSelectTableView setDelegate:self];
        
        if(self.tableViewSeperatorColor!=nil)
        {
            self.storageFileSelectTableView.separatorColor = self.tableViewSeperatorColor;
        }
        
        self.storageFileSelectTableView.allowsMultipleSelection = self.multiSelection;
        
        [self.view addSubview:self.storageFileSelectTableView];
    }
    
    //////////////////////////////////////////////////
    
    self.headerTitleLabel = [[[UILabel alloc] init] autorelease];
    
    if(self.headerTitleLabel!=nil)
    {
        if(self.headerTitleLabelText!=nil)
        {
            [self.headerTitleLabel setText:[@"  " stringByAppendingString:self.headerTitleLabelText]];
            self.headerTitleLabel.hidden = NO;
        }
        else
        {
            self.headerTitleLabel.hidden = YES;
        }
        
        //////////////////////////////////////////////////
        
        self.storageFileSelectTableView.tableHeaderView = self.headerTitleLabel;
    }
}





//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self.storageFileSelectTableView setDataSource:nil];
    [self.storageFileSelectTableView setDelegate:nil];
    [self.storageFileSelectTableView removeFromSuperview];
    self.storageFileSelectTableView = nil;
    
    //////////////////////////////////////////////////
    
    [self.storageFileSelectNavigationBarView removeFromSuperview];
    self.storageFileSelectNavigationBarView = nil;
    
    //////////////////////////////////////////////////
    
    [self.headerTitleLabel removeFromSuperview];
    self.headerTitleLabel = nil;
    
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}


//================================================================================
//
//================================================================================
- (void)viewDidLayoutSubviews
{
    [super viewDidLayoutSubviews];
    
    //////////////////////////////////////////////////
    
    if(self.headerTitleLabel.hidden==NO)
    {
        self.storageFileSelectTableView.tableHeaderView = self.headerTitleLabel;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - layout of subview

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    self.storageFileSelectTableView.frame = [self layoutFrame];
    
    //////////////////////////////////////////////////
    
    self.headerTitleLabel.frame = CGRectMake(0, 0, self.view.bounds.size.width, self.headerTitleLabelHeight);
}





//////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCancelBusyViewDelegate Method

//================================================================================
//
//================================================================================
- (void)ppCancelBusyViewDidCancel:(PPCancelBusyView *)ppCancelBusyView
{
    if([self.delegate respondsToSelector:@selector(storageFileSelectViewControllerDidDismissBusyView:)]==YES)
    {
        [self.delegate storageFileSelectViewControllerDidDismissBusyView:self];
    }
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPStorageFileFetchDelegate

//================================================================================
//
//================================================================================
- (void)fetchedStorageFileSectionModels:(NSMutableArray *)storageFileSectionModels
{
    __block typeof(self) blockself = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        
        [blockself showCancelBusyView:NO withSuperView:nil showButton:NO];
    });
    
    //////////////////////////////////////////////////
    
    if(storageFileSectionModels==nil ||
       storageFileSectionModels.count<=0)
    {
        dispatch_async(dispatch_get_main_queue(), ^{
            
            blockself.storageFileSelectNavigationBarView.editButton.hidden = YES;
            
            //////////////////////////////////////////////////
            
            [self showAlertWithError:PPErrorMake(PPCloudCommonError_PathNotExist, @"File not found", nil) title:@""];
        });
    }
    else
    {
        [[self.storageFileSelectSectionController sectionModelsForDefault] addObjectsFromArray:storageFileSectionModels];
        
        //////////////////////////////////////////////////
        
        if([self.datasource respondsToSelector:@selector(storageFileSelectViewControllerRequestUpdateRowModel:)]==YES)
        {
            for(PPSectionModel *sectionModel in storageFileSectionModels)
            {
                for(PPRowModel *rowModel in sectionModel.rowModels)
                {
                    [self.datasource storageFileSelectViewControllerRequestUpdateRowModel:rowModel];
                }
            }
        }
        
        //////////////////////////////////////////////////
        
        dispatch_async(dispatch_get_main_queue(), ^{
            
            blockself.storageFileSelectNavigationBarView.editButton.hidden = NO;
            
            //////////////////////////////////////////////////
            
            if(blockself.storageFileSelectTableView!=nil)
            {
                [blockself.storageFileSelectTableView reloadData];
            }
        });
    }
}


//================================================================================
//
//================================================================================
- (void)downloadFileSuccessWithFilePath:(NSString *)filePath userInfo:(id)userInfo
{
    // 這邊要注意是不是為自動下載，若是自動下載，路徑要改成下載完的的位置
    if(self.autoDownload==YES)
    {
        NSInteger index = [userInfo integerValue];
        
        if(self.selectedFileArray.count>index && index>=0)
        {
            PPStorageFielSelectRowModel *rowModel = [self.selectedFileArray objectAtIndex:index];
            
            rowModel.object = filePath;
        }
    }
    
    //////////////////////////////////////////////////

    //已是最後一筆下載檔案
    if([userInfo unsignedIntegerValue]==self.selectedFileArray.count-1)
    {
        if([self.delegate respondsToSelector:@selector(storageFileSelectViewController:didSelectedFileArray:)]==YES)
        {
            [self.delegate storageFileSelectViewController:self
                                      didSelectedFileArray:self.selectedFileArray];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)downloadProgress:(CGFloat)progress forFile:(NSString *)destPath userInfo:(id)userInfo
{
    [PPBusyView postMessage:[NSString stringWithFormat:@"%@, %d%%",[[destPath lastPathComponent] stringByDeletingPathExtension],(int)(progress*100)]];
}


//================================================================================
//
//================================================================================
- (void)deleteFileSuccessWithFilePath:(NSString *)filePath userInfo:(id)userinfo
{
    do
    {
        if(userinfo==nil ||
           [userinfo isKindOfClass:[PPRowModel class]]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPRowModel *rowModel = userinfo;
        
        if([self.selectedFileArray containsObject:rowModel]==YES)
        {
            [self.selectedFileArray removeObject:rowModel];
        };
        
        //////////////////////////////////////////////////
        
        NSIndexPath *indexPath = [self.storageFileSelectSectionController indexPathForRowModel:rowModel forSearching:NO];
        
        if(indexPath==nil)
        {
            break;
        }
        else if([[self.storageFileSelectSectionController sectionModelsForSearching:NO] count]<=indexPath.section)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPSectionModel *sectionModel = [[self.storageFileSelectSectionController sectionModelsForSearching:NO] objectAtIndex:indexPath.section];
        
        if(sectionModel==nil)
        {
            break;
        }
        
        [sectionModel.rowModels removeObject:rowModel];
        
        //////////////////////////////////////////////////
        
        __block typeof(self) blockself = self;
        
        dispatch_async(dispatch_get_main_queue(), ^{
            
            [blockself showCancelBusyView:NO withSuperView:nil showButton:NO];
            
            //////////////////////////////////////////////////
            
            if(sectionModel.rowModels.count<=0)
            {
                [[blockself.storageFileSelectSectionController sectionModelsForSearching:NO] removeObject:sectionModel];
                
                [blockself.storageFileSelectTableView deleteSections:[NSIndexSet indexSetWithIndex:indexPath.section] withRowAnimation:UITableViewRowAnimationNone];
                
            }
            else
            {
                [blockself.storageFileSelectTableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationNone];
            }
        });
        
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)responseForError:(NSError *)error
{
    BOOL showAlertView = YES;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(storageFileSelectViewControllerShouldShowAlertError:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        showAlertView = [self.delegate storageFileSelectViewControllerShouldShowAlertError:error];
    }
    while (0);
    
    //////////////////////////////////////////////////
    
    __block typeof(self) blockself = self;
    
    if(showAlertView==YES)
    {
        dispatch_async(dispatch_get_main_queue(),
                       ^{
                           [blockself showCancelBusyView:NO withSuperView:nil showButton:NO];
                           [blockself showAlertWithError:error title:@""];
                       });
    }
    else
    {
        dispatch_async(dispatch_get_main_queue(),
                       ^{
                           [blockself showCancelBusyView:NO withSuperView:nil showButton:NO];
                       });
    }
}


//================================================================================
//
//================================================================================
- (NSInteger)cardCountFromFilePath:(NSString *)filePath
{
    NSInteger cardCount = NSNotFound;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(storageFileSelectViewControllerRequestCardCountFromFilePath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        cardCount = [self.delegate storageFileSelectViewControllerRequestCardCountFromFilePath:filePath];
    }
    while (0);
    
    return cardCount;
}





//////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPStorageFileSelectNavigationBarViewDelegate Method

//================================================================================
//
//================================================================================
- (void)storageFileSelectNavigationBarView:(PPStorageFileSelectNavigationBarView *)storageFileSelectNavigationBarView
                             responderView:(UIView *)responderView
                              controlEvent:(UIControlEvents)controlEvent
{
    switch (responderView.tag)
    {
        case PPStorageFileSelectNavigationBarViewButtonTag_Back:
        {
            if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(storageFileSelectViewControllerDidCancel:)]==YES)
            {
                [self.delegate storageFileSelectViewControllerDidCancel:self];
            }
            else
            {
                [self goBackAnimated:YES];
            }
            
            break;
        }
        case PPStorageFileSelectNavigationBarViewButtonTag_Edit:
        {
            self.storageFileSelectTableView.editing = YES;
            
            [self.storageFileSelectNavigationBarView setMode:PPStorageFileSelectNavigationBarViewMode_Edit];
            
            self.storageFileSelectNavigationBarView.backorDoneButton.hidden = NO;
            
            //////////////////////////////////////////////////
            
            [self.selectedFileArray removeAllObjects];
            
            //////////////////////////////////////////////////
            
            [self.storageFileSelectTableView reloadData];
            
            break;
        }
        case PPStorageFileSelectNavigationBarViewButtonTag_Done:
        {
            //若沒有資料則不顯示 編輯按鈕
            
            self.storageFileSelectTableView.editing = NO;
            
            if (self.multiSelection)
            {
                [self.storageFileSelectNavigationBarView setMode:PPStorageFileSelectNavigationBarViewMode_MultiChoiceBrowse];
            }
            else
            {
                [self.storageFileSelectNavigationBarView setMode:PPStorageFileSelectNavigationBarViewMode_SingleChoiceBrowse];
            }
            
            
            self.storageFileSelectNavigationBarView.backorDoneButton.hidden = self.hidenBackButton;
            
            //////////////////////////////////////////////////
            
            if([self.storageFileSelectSectionController rowObjectsCountForSearching:NO]<=0)
            {
                self.storageFileSelectNavigationBarView.editButton.hidden = YES;
            }
            else
            {
                self.storageFileSelectNavigationBarView.editButton.hidden = NO;
            }
            break;
        }
        case PPStorageFileSelectNavigationBarViewButtonTag_Import:
        {
            if(self.selectedFileArray.count<=0)
            {
                // 單選時，沒選擇任何檔案，直接丟出結果
                if([self.delegate respondsToSelector:@selector(storageFileSelectViewController:didSelectedFileArray:)]==YES)
                {
                    [self.delegate storageFileSelectViewController:self
                                              didSelectedFileArray:self.selectedFileArray];
                }
            }
            else
            {
                [self sendFileResult];
            }
            
            break;
        }
        default:
        {
            break;
        }
    }
}






//////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDataSource Method

//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return [self.storageFileSelectSectionController numberOfSectionsForSearching:NO];
}


//================================================================================
//
//================================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [self.storageFileSelectSectionController numberOfRowsInSection:section forSearching:NO];;
}





//////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDelegate Method

//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell     = nil;
    PPRowModel      *rowModel = nil;
    
    //////////////////////////////////////////////////
    
    if([self.storageFileSelectSectionController sectionModelsForSearching:NO].count>indexPath.section)
    {
        PPSectionModel *sectionModel = [[self.storageFileSelectSectionController sectionModelsForSearching:NO] objectAtIndex:indexPath.section];
        
        if(sectionModel!=nil && sectionModel.rowModels.count>indexPath.row)
        {
            rowModel = [sectionModel.rowModels objectAtIndex:indexPath.row];
        }
    }
    
    //////////////////////////////////////////////////
    
    NSString *cellIdentifier = PPStorageFileSelectViewControllerTableViewCell;
    
    if(rowModel!=nil && rowModel.detailText.length>0)
    {
        cellIdentifier = PPStorageFileSelectViewControllerTableViewSubTitleCell;
    }
    
    //////////////////////////////////////////////////
    
    cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
    
    if(cell==nil)
    {
        if([cellIdentifier isEqualToString:PPStorageFileSelectViewControllerTableViewSubTitleCell]==YES)
        {
            cell = [[[PPTableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:cellIdentifier] autorelease];
        }
        else
        {
            cell = [[[PPTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellIdentifier] autorelease];
        }
    }
    
    //////////////////////////////////////////////////
    
    PPTableViewCell *tableCell = (PPTableViewCell *)cell;
    
    tableCell.ignoreCustomLabelFrame = YES;
    
    //////////////////////////////////////////////////
    
    cell.textLabel.adjustsFontSizeToFitWidth = YES;
    
    if(rowModel.text!=nil)
    {
        cell.textLabel.text = rowModel.text;
    }
    else
    {
        cell.textLabel.text = NSLocalizedString(@"MLS_NoName", nil);
    }
    
    //////////////////////////////////////////////////
    
    if(rowModel.detailText!=nil)
    {
        cell.detailTextLabel.text = rowModel.detailText;
    }
    else
    {
        cell.detailTextLabel.text = NSLocalizedString(@"MLS_NoName", nil);
    }
    
    //////////////////////////////////////////////////
    
    if(self.tableViewCellNormalTextColor!=nil)
    {
        [cell.textLabel setTextColor:self.tableViewCellNormalTextColor];
    }
    
    if(self.tableViewCellNormalDetailTextColor!=nil)
    {
        [cell.detailTextLabel setTextColor:self.tableViewCellNormalDetailTextColor];
    }
    
    //////////////////////////////////////////////////
    
    //改用客製化顏色
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    
    //////////////////////////////////////////////////
    
    if(self.multiSelection==YES &&
       [self.selectedFileArray containsObject:rowModel])
    {
        cell.accessoryType = UITableViewCellAccessoryCheckmark;
    }
    else
    {
        cell.accessoryType = UITableViewCellAccessoryNone;
    }
    
    return cell;
}


//================================================================================
//
//================================================================================
- (UITableViewCellEditingStyle)tableView:(UITableView *)tableView editingStyleForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCellEditingStyle tableViewCellEditingStyle = UITableViewCellEditingStyleNone;
    
    if(self.storageFileSelectTableView.editing==YES)
    {
        tableViewCellEditingStyle = UITableViewCellEditingStyleDelete;
    }
    
    return tableViewCellEditingStyle;
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath
{
    // MARK: Howard 刪除檔案
    if(editingStyle==UITableViewCellEditingStyleDelete)
    {
        if([self.storageFileSelectSectionController sectionModelsForSearching:NO].count>indexPath.section)
        {
            PPSectionModel *sectionModel = [[self.storageFileSelectSectionController sectionModelsForSearching:NO] objectAtIndex:indexPath.section];
            
            do
            {
                if(sectionModel==nil ||
                   sectionModel.rowModels.count<=indexPath.row)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                PPRowModel *rowModel = [sectionModel.rowModels objectAtIndex:indexPath.row];
                
                if(rowModel==nil ||
                   [[rowModel object] isKindOfClass:[NSString class]]==NO)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                if(self.storageFileFetchObject==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                [self showCancelBusyView:YES withSuperView:[UIApplication sharedApplication].keyWindow showButton:NO];
                [self.storageFileFetchObject deleteFileFromPath:[rowModel object]
                                                       userInfo:rowModel];
            }
            while (0);
        }
    }
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if([self.storageFileSelectSectionController sectionModelsForSearching:NO].count>indexPath.section)
    {
        PPSectionModel *sectionModel = [[self.storageFileSelectSectionController sectionModelsForSearching:NO] objectAtIndex:indexPath.section];
        
        if(sectionModel!=nil && sectionModel.rowModels.count>indexPath.row)
        {
            PPRowModel *rowModel = [sectionModel.rowModels objectAtIndex:indexPath.row];
            
            //////////////////////////////////////////////////
            
            if([self.selectedFileArray containsObject:rowModel]==NO)
            {
                //單選的情況下，只會有一個element在裡面
                if(self.multiSelection==NO && [self.selectedFileArray count]>0)
                {
                    [self.selectedFileArray removeAllObjects];
                }
                
                [self.selectedFileArray addObject:rowModel];
            }
            else
            {
                [self.selectedFileArray removeObject:rowModel];
            }
            
            //////////////////////////////////////////////////
            
            __block typeof(self) blockself = self;
            
            dispatch_async(dispatch_get_main_queue(), ^{
                
                //單選情況下，有可能一次要異動2筆cell
                if([blockself multiSelection]==NO)
                {
                    [self sendFileResult];
                }
                else if(indexPath!=nil)
                {
                    [[blockself storageFileSelectTableView] reloadRowsAtIndexPaths:@[indexPath]
                                                                  withRowAnimation:UITableViewRowAnimationNone];
                }
            });
        }
    }
}


//================================================================================
//
//================================================================================
- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section
{
    return [self.storageFileSelectSectionController titleForHeaderInSection:section forSearching:NO];
}


//================================================================================
//
//================================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return self.tableViewCellHeight;
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didUnhighlightRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *tableViewCell = [tableView cellForRowAtIndexPath:indexPath];
    
    if(tableViewCell!=nil)
    {
        [tableViewCell setBackgroundColor:[UIColor whiteColor]];
    }
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didHighlightRowAtIndexPath:(NSIndexPath *)indexPath
{
    if(self.tableViewCellHighlightedBackgroundColor!=nil)
    {
        UITableViewCell *tableViewCell = [tableView cellForRowAtIndexPath:indexPath];
        
        if(tableViewCell!=nil)
        {
            [tableViewCell setBackgroundColor:self.tableViewCellHighlightedBackgroundColor];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView willDisplayHeaderView:(UIView *)view forSection:(NSInteger)section
{
    UITableViewHeaderFooterView *header = (UITableViewHeaderFooterView *)view;
    
    [header.textLabel setText:[self.storageFileSelectSectionController titleForHeaderInSection:section forSearching:NO]];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private PPStorageFileFetch Generate Method

//================================================================================
//
//================================================================================
- (PPStorageFileFetch *)curStorageFileFetchForStorage
{
    PPStorageFileFetch *storageFileFetch = nil;
    
    switch (self.storageFileSelectViewControllerSpaceType)
    {
        case PPStorageFileSelectViewControllerSpaceType_AddressBook:
        {
            storageFileFetch = [[PPStorageFileFetch_iTune alloc] init];
            break;
        }
        case PPStorageFileSelectViewControllerSpaceType_Baidu:
        {
            break;
        }
        case PPStorageFileSelectViewControllerSpaceType_Dropbox:
        {
            storageFileFetch = [[PPStorageFileFetch_Dropbox alloc] init];
            
            break;
        }
        case PPStorageFileSelectViewControllerSpaceType_GoogleDrive:
        {
            storageFileFetch = [[PPStorageFileFetch_GoogleDrive alloc] init];
            
            break;
        }
        case PPStorageFileSelectViewControllerSpaceType_OneDrive:
        {
            storageFileFetch = [[PPStorageFileFetch_OneDrive alloc] init];
            
            break;
        }
//        case PPStorageFileSelectViewControllerSpaceType_Huawei:
//        {
//            storageFileFetch = [[PPStorageFileFetch_Huawei alloc] init];
//            
//            break;
//        }
        case PPStorageFileSelectViewControllerSpaceType_iCloud:
        {
            storageFileFetch = [[PPStorageFileFetch_iCloud alloc] init];
            
            break;
        }
        case PPStorageFileSelectViewControllerSpaceType_iTune:
        {
            storageFileFetch = [[PPStorageFileFetch_iTune alloc] init];
            
            break;
        }
        default:
        {
            
            break;
        }
    }
    
    //////////////////////////////////////////////////
    
    return [storageFileFetch autorelease];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (BOOL)fetchSpaceFileList
{
    BOOL result = NO;
    
    do
    {
        if(self.storageFileFetchObject==nil)
        {
            break;
        }
        
        self.storageFileFetchObject.storageFileFetchDelegate = self;
        
        //////////////////////////////////////////////////
        
        if(self.defaultRootFilePath!=nil)
        {
            self.storageFileFetchObject.defaultFilePath = self.defaultRootFilePath;
        }
        
        self.storageFileFetchObject.extensionFileNames = self.extensionFileNameArray;
        
        self.storageFileFetchObject.sectionTitleDictionary = self.sectionTitleDictionary;
        
        //////////////////////////////////////////////////
        
        //重進畫面重新reload
        [[self.storageFileSelectSectionController sectionModelsForDefault] removeAllObjects];
        
        //////////////////////////////////////////////////
        
        result = [self.storageFileFetchObject fetchSectinoModels];
    }
    while(0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (void)sendFileResult
{
    switch (self.storageFileSelectViewControllerSpaceType)
    {
        case PPStorageFileSelectViewControllerSpaceType_AddressBook:
        case PPStorageFileSelectViewControllerSpaceType_iTune:
        {
            if([self.delegate respondsToSelector:@selector(storageFileSelectViewController:didSelectedFileArray:)]==YES)
            {
                [self.delegate storageFileSelectViewController:self
                                          didSelectedFileArray:self.selectedFileArray];
            }
            
            break;
        }
        case PPStorageFileSelectViewControllerSpaceType_iCloud:
        case PPStorageFileSelectViewControllerSpaceType_Huawei:
        case PPStorageFileSelectViewControllerSpaceType_GoogleDrive:
        case PPStorageFileSelectViewControllerSpaceType_OneDrive:
        case PPStorageFileSelectViewControllerSpaceType_Dropbox:
        {
            if(self.autoDownload==YES)
            {
                [self showCancelBusyView:YES
                           withSuperView:[UIApplication sharedApplication].keyWindow
                              showButton:NO];
                
                //////////////////////////////////////////////////
                
                //背景處理
                [PPBackgroundTaskController addTaskWithKey:NSStringFromClass([self class]) terminate:nil];
                
                //////////////////////////////////////////////////
                
                for(NSUInteger index=0; index<self.selectedFileArray.count; index++)
                {
                    PPStorageFielSelectRowModel *rowModel = [self.selectedFileArray objectAtIndex:index];
                    
                    [self.storageFileFetchObject downloadFileWithPath:rowModel.object
                                                               fileID:rowModel.fileID
                                                              useinfo:@(index)];
                }
                
                //////////////////////////////////////////////////
                
                [PPBackgroundTaskController removeTaskWithKey:NSStringFromClass([self class])];
            }
            else
            {
                if([self.delegate respondsToSelector:@selector(storageFileSelectViewController:didSelectedFileArray:)]==YES)
                {
                    [self.delegate storageFileSelectViewController:self
                                              didSelectedFileArray:self.selectedFileArray];
                }
            }
            
            break;
        }
        default:
        {
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Alert Method

//================================================================================
//
//================================================================================
- (void)showAlertWithError:(NSError *)error title:(NSString *)title
{
    if(error != nil)
    {
        NSString *message = nil;
        
        // 先跟外部詢問有沒有特別的解釋
        if([self.delegate respondsToSelector:@selector(storageFileSelectViewControllerRequestMessageWithError:)])
        {
            message = [self.delegate storageFileSelectViewControllerRequestMessageWithError:error];
        }
        
        //////////////////////////////////////////////////
        
        if([message length] == 0)
        {
            // 沒有的話就直接使用error code敘述
            if(error.code==PPCloudCommonError_PathNotExist)
            {
                message = PPSFSV_MLS_EmptyFile;
                
                if(self.defaultRootFilePath!=nil &&
                   self.defaultRootFilePath.length>0 &&
                   [self.defaultRootFilePath compare:@"/"]!=NSOrderedSame)
                {
                    //換路徑
                    message = [message stringByReplacingOccurrencesOfString:@"@1" withString:self.defaultRootFilePath];
                }
                else
                {
                    //換路徑
                    message = [message stringByReplacingOccurrencesOfString:@"(@1)" withString:@""];
                }
                
                //////////////////////////////////////////////////
                
                //換副檔名名稱
                message = [message stringByReplacingOccurrencesOfString:@"@2" withString:[self.extensionFileNameArray componentsJoinedByString:@" ,"]];
            }
            else
            {
                message = [error alertMessage];
            }
        }
        
        //////////////////////////////////////////////////
        
        if([PPAlertController canAlert]==YES)
        {
            // show alert
            __block typeof(self) blockSelf = self;
            
            PPAlertController *alertController = [PPAlertController alertControllerWithTitle:title message:message preferredStyle:UIAlertControllerStyleAlert];
            [alertController addAction:[UIAlertAction actionWithTitle:PPSFSV_MLS_OK style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
                
                if([blockSelf.delegate respondsToSelector:@selector(storageFileSelectViewControllerDidCancel:)]==YES)
                {
                    [blockSelf.delegate storageFileSelectViewControllerDidCancel:self];
                }
                else
                {
                    [blockSelf goRootAnimated:YES];
                }
            }]];
            [self presentViewController:alertController animated:YES completion:nil];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)showCancelBusyView:(BOOL)show withSuperView:(UIView *)superView showButton:(BOOL)showButton
{
    if(show==YES)
    {
        if(self.ppCancelBusyView==nil)
        {
            _ppCancelBusyView = [[PPCancelBusyView alloc] initWithSuperView:superView];
        }
        
        self.ppCancelBusyView.showCancelButton = showButton;
        
        self.ppCancelBusyView.delegate = self;
    }
    else
    {
        [self.ppCancelBusyView removeFromSuperview];
        self.ppCancelBusyView = nil;
    }
}


//================================================================================
//
//================================================================================
- (void)fetchSpaceFileListAndReloadTable
{
    [self.selectedFileArray removeAllObjects];
    
    [[self.storageFileSelectSectionController sectionModelsForDefault] removeAllObjects];
    
    [self fetchSpaceFileList];
    
    [self.storageFileSelectTableView reloadData];
}


//================================================================================
//
//================================================================================
- (void)deleteAllLocalSelectFile
{
    for (PPStorageFielSelectRowModel *rowModel in self.selectedFileArray)
    {
        [self.storageFileFetchObject deleteLocalFileFromPath:[rowModel object] userInfo:nil];
    }
    
    //////////////////////////////////////////////////
    
    [self.storageFileSelectTableView reloadData];
}
@end


