//
//  PPStorageFileFetch_Dropbox.m
//  Pods
//
//  Created by Howard on 2015/8/4.
//
//

#import "PPStorageFileFetch_Dropbox.h"
#import "PPCloud_Dropbox.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPStorageFileFetch_Dropbox


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance method

//================================================================================
//
//================================================================================
- (BOOL)fetchSectinoModels
{
    return [PPCloudController loadMetadata:self.defaultFilePath
                                  delegate:self
                                  userInfo:nil
                                cloudClass:[PPCloud_Dropbox class]];
}


//================================================================================
//
//================================================================================
- (void)downloadFileWithPath:(NSString *)path fileID:(NSString *)fileID useinfo:(id)userinfo;
{
    NSString *intoPath = [[PPPathController tempDirectory] stringByAppendingString:[NSString stringWithFormat:@"%@",[path lastPathComponent]]];
    
    [PPCloudController loadFileFromPath:path
                               orFileID:nil
                               intoPath:intoPath
                               delegate:self
                               userInfo:userinfo
                             cloudClass:[PPCloud_Dropbox class]];
}


//================================================================================
//
//================================================================================
- (void)deleteFileFromPath:(NSString *)path userInfo:(id)userInfo
{
    [PPCloudController deletePath:path
                         delegate:self
                         userInfo:userInfo
                       cloudClass:[PPCloud_Dropbox class]];
}



@end
