//
//  PPStorageFileFetch.m
//  
//
//  Created by Howard on 2015/8/4.
//
//

#import "PPStorageFileFetch.h"

static NSString *PPCloudFileDefine_DateTimeFormat = @"yyyyMMdd_HHmmss";

// Model

#import "GTLRDriveObjects.h"
#import "PPStorageFielSelectRowModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPStorageFileFetch

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (void)dealloc
{
    _storageFileFetchDelegate = nil;
    
    [_defaultFilePath release];
    _defaultFilePath = nil;
    
    [_extensionFileNames release];
    _extensionFileNames = nil;
    
    [_sectionTitleDictionary release];
    _sectionTitleDictionary = nil;

    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudDelegate_Delete Method

//================================================================================
//
//================================================================================
- (void)ppCloud:(PPCloud *)ppCloud deletePath:(NSString *)path userInfo:(id)userInfo
{
    PPLogFunction(@"deletePath:%@",path);
    
    do
    {
        if([self.storageFileFetchDelegate respondsToSelector:@selector(deleteFileSuccessWithFilePath:userInfo:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [self.storageFileFetchDelegate deleteFileSuccessWithFilePath:path userInfo:userInfo];
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)ppCloud:(PPCloud *)ppCloud deletePathFailedWithError:(NSError *)error userInfo:(id)userInfo
{
    PPLogFunction(@"deletePathFailedWithError:%@",error);
    
    do
    {
        if([self.storageFileFetchDelegate respondsToSelector:@selector(responseForError:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [self.storageFileFetchDelegate responseForError:error];
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudDelegate_LoadMetadata Method

//================================================================================
//
//================================================================================
- (void)ppCloud:(PPCloud *)ppCloud loadMetadataFailedWithError:(NSError *)error userInfo:(id)userInfo
{
    PPLogFunction(@"loadMetadataFailedWithError:%@",error);
    
    do
    {
        if([self.storageFileFetchDelegate respondsToSelector:@selector(responseForError:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [self.storageFileFetchDelegate responseForError:error];
    }
    while (0);
}

//================================================================================
//
//================================================================================
- (void)ppCloud:(PPCloud *)ppCloud loadedMetadata:(PPCloudMetadata *)metadata userInfo:(id)userInfo
{
    PPLogFunction(@"loadedMetadata.content:%@",metadata.contents);
    
    do
    {
        if([self.storageFileFetchDelegate respondsToSelector:@selector(fetchedStorageFileSectionModels:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSString *strDate = nil;

        // 華為拋出來是　String
        if([metadata.lastModifiedDate isKindOfClass:[NSString class]]==YES)
        {
            strDate = (NSString *)metadata.lastModifiedDate;
        }
        else
        {
            NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
            
            if(dateFormatter!=nil)
            {
                [dateFormatter setDateFormat:[[PPCloudFileDefine_DateTimeFormat componentsSeparatedByString:@"_"] firstObject]];
                
                strDate = [dateFormatter stringFromDate:metadata.lastModifiedDate];
            }
            
            [dateFormatter release];
        }
        
        //////////////////////////////////////////////////
        
        NSMutableArray *sectionModels = [self sectionModelsForMetadata:metadata date:strDate];
        
        [self.storageFileFetchDelegate fetchedStorageFileSectionModels:sectionModels];
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudDelegate_LoadFile Method

//================================================================================
//
//================================================================================
- (void)ppCloud:(PPCloud *)ppCloud loadedFile:(NSString *)destPath userInfo:(id)userInfo
{
    PPLogFunction(@"%s, loadedFile:%@",__func__,destPath);
    
    do
    {
        if([self.storageFileFetchDelegate respondsToSelector:@selector(downloadFileSuccessWithFilePath:userInfo:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [self.storageFileFetchDelegate downloadFileSuccessWithFilePath:destPath userInfo:userInfo];
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)ppCloud:(PPCloud *)ppCloud loadFileFailedWithError:(NSError *)error userInfo:(id)userInfo
{
    PPLogFunction(@"%s, error:%@",__func__,error);
    
    do
    {
        if([self.storageFileFetchDelegate respondsToSelector:@selector(responseForError:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [self.storageFileFetchDelegate responseForError:error];
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)ppCloud:(PPCloud *)ppCloud loadProgress:(CGFloat)progress forFile:(NSString *)destPath userInfo:(id)userInfo
{
    PPLogFunction(@"%s, forFile:%@, loadProgress:%f",__func__,destPath,progress);
    do
    {
        if([self.storageFileFetchDelegate respondsToSelector:@selector(downloadProgress:forFile:userInfo:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [self.storageFileFetchDelegate downloadProgress:progress forFile:destPath userInfo:userInfo];
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark -  Private Method

//================================================================================
//
//================================================================================
- (NSMutableArray *)sectionModelsForMetadata:(PPCloudMetadata *)cloudMetadata date:(NSString *)date
{
    NSMutableArray *sectionModels = nil;
    
    do
    {
        @autoreleasepool
        {
            NSArray *metadata = cloudMetadata.contents;
            
            if(metadata==nil ||
               metadata.count<=0)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            if(self.extensionFileNames==nil ||
               self.extensionFileNames.count<=0)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            sectionModels = [[NSMutableArray alloc] init];
            
            if(sectionModels==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            NSMutableArray *localMetadata = [NSMutableArray arrayWithArray:metadata];
            
            if(localMetadata==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            for(NSString *fileExtension in self.extensionFileNames)
            {
                PPSectionModel *sectionModel = [[PPSectionModel alloc] init];
                
                if(sectionModel==nil)
                {
                    break;
                }
                
                sectionModel.title = [self.sectionTitleDictionary objectForKey:fileExtension];
                
                //////////////////////////////////////////////////
                
                for(NSInteger metadataIndex=0; metadataIndex<localMetadata.count; metadataIndex++)
                {
                    NSString *filePath = [localMetadata objectAtIndex:metadataIndex];
                    
                    //找到要尋找的檔案
                    if([[filePath pathExtension] compare:fileExtension options:NSCaseInsensitiveSearch]==NSOrderedSame)
                    {
                        PPStorageFielSelectRowModel *rowModel = [[[PPStorageFielSelectRowModel alloc] init] autorelease];
                        
                        if(rowModel!=nil)
                        {
                            rowModel.row  = sectionModel.rowModels.count;
                            
                            NSString *fileName = [filePath lastPathComponent];
                            
                            //////////////////////////////////////////////////

                            if([fileExtension compare:@"wcxf"]==NSOrderedSame)
                            {
                                rowModel.text = [fileName stringByDeletingPathExtension];
                            }
                            else
                            {
                                rowModel.text = [fileName stringByDeletingPathExtension];
                            }
                            
                            //////////////////////////////////////////////////
                            
                            rowModel.object = filePath;
                            
                            if([cloudMetadata.cloudClassName isEqualToString:@"PPCloud_GoogleDrive"]==YES)
                            {
                                if([cloudMetadata.rawData isKindOfClass:[NSDictionary class]]==YES)
                                {
                                    GTLRDrive_FileList *driveFileList = [cloudMetadata.rawData objectForKey:NSStringFromClass([GTLRDrive_FileList class])];
                                    
                                    NSArray *infoDictionaries = driveFileList.files;
                                    
                                    if([infoDictionaries count]>metadataIndex)
                                    {
                                        GTLRDrive_File *file = [infoDictionaries objectAtIndex:metadataIndex];
                                        
                                        rowModel.fileID = file.identifier;
                                    }
                                }
                            }
                           
                            //////////////////////////////////////////////////
                            
                            [sectionModel.rowModels addObject:rowModel];
                        }
                        
                        //////////////////////////////////////////////////
                        
//                        [localMetadata removeObject:filePath];
//                        metadataIndex--;
                    }
                }
                
                //////////////////////////////////////////////////
                
                if(sectionModel.rowModels.count>0)
                {
                    [sectionModels addObject:sectionModel];
                }
                
                //////////////////////////////////////////////////

                [sectionModel release];
            }
        }
    }
    while (0);
    
    return [sectionModels autorelease];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Inherit method

//================================================================================
//
//================================================================================
- (void)deleteLocalFileFromPath:(NSString *)path userInfo:(id)userInfo
{
    NSError *returnError = nil;
    
    do
    {
        if(path==nil ||
           path.length<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        BOOL result = [[NSFileManager defaultManager] removeItemAtPath:path error:&returnError];
        
        if(result==NO)
        {
            if([self.storageFileFetchDelegate respondsToSelector:@selector(responseForError:)]==YES)
            {
                [self.storageFileFetchDelegate responseForError:returnError];
            }
        }
        else
        {
            if([self.storageFileFetchDelegate respondsToSelector:@selector(deleteFileSuccessWithFilePath:userInfo:)]==YES)
            {
                [self.storageFileFetchDelegate deleteFileSuccessWithFilePath:path userInfo:userInfo];
            }
        }
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)downloadFileWithPath:(NSString *)path fileID:(NSString *)fileID useinfo:(id)userinfo;
{
}


//================================================================================
//
//================================================================================
- (BOOL)fetchSectinoModels
{
    return YES;
}


//================================================================================
//
//================================================================================
- (void)downloadFileWithPath:(NSString *)path useinfo:(id)userinfo
{
    
}


//================================================================================
//
//================================================================================
- (void)deleteFileFromPath:(NSString *)path userInfo:(id)userInfo
{
    
}


@end
