//
//  PPSelectItemViewController.m
//  
//
//  Created by Mike.Shih on 13/9/24.
//  Copyright (c) 2013年 Mike.Shih. All rights reserved.
//

#import "PPSelectItemViewController.h"
#import "UIViewController+ShareApplication.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSInteger, PPSelectItemViewControllerButtonTag)
{
	PPSelectItemViewControllerButtonTag_Back = 1,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPSelectItemViewController()

@interface PPSelectItemViewController ()
@property(nonatomic,retain) PPButton            *ppButtonBack;
@property(nonatomic,retain) PPNavigationBarView *ppNavigationBarView;
@property(nonatomic,retain) PPTableView         *ppTableView;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPSelectItemViewController

////////////////////////////////////////////////////////////////////////////////////////////////////





#pragma mark - Creating, Copying, and Deallocating Objects


//==============================================================================
//
//==============================================================================
+ (void)initialize
{
    [[PPSelectItemViewController appearance] setTableViewBackgroundColor:[UIColor clearColor]];
}


//================================================================================
//
//================================================================================
- (id)init
{
    id object = nil;
    
    if((self=[super init]))
    {
        [[PPSelectItemViewController appearance] applyInvocationTo:self];
        
        //////////////////////////////////////////////////
        _ppSectionController = [[PPSectionController alloc] init];
        if(self.ppSectionController!=nil)
        {
            object = self;
        }
        
        //////////////////////////////////////////////////
        
        _defaultBarViewStyle = PPBarViewStyle_CenteredRelative;
        
        //////////////////////////////////////////////////

        _customNavigationBar = YES;
    }
    
    //////////////////////////////////////////////////
    
    if(object==nil)
    {
        [self release];
    }
	
    return object;
}

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.tableViewBackgroundColor = nil;
    
    if(self.ppSectionController!=nil)
    {
        [_ppSectionController release];
        _ppSectionController = nil;
    }
    
    [self.ppTableView removeFromSuperview];
    self.ppTableView = nil;
    
    //////////////////////////////////////////////////
    
    self.ppButtonBack = nil;
    
    //////////////////////////////////////////////////
    
    self.navigationItem.leftBarButtonItem = nil;
    self.title = self.ppNavigationBarView.titleLabel.text;
    self.ppNavigationBarView = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
	[super viewWillAppear:animated];
	
    //////////////////////////////////////////////////
    
    self.navigationController.navigationBarHidden = NO;
    
    //////////////////////////////////////////////////
    
    @autoreleasepool
    {
        do
        {
            if(self.navigationController==nil)
            {
                break;
            }

            //////////////////////////////////////////////////
            
            if(self.customNavigationBar==YES)
            {
                self.ppNavigationBarView = [[[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds] autorelease];
                if(self.ppNavigationBarView==nil)
                {
                    break;
                }
                
                self.ppNavigationBarView.style      = self.defaultBarViewStyle;
                self.ppNavigationBarView.tintColor  = self.navigationController.navigationBar.tintColor;
                self.ppNavigationBarView.titleLabel.text = self.title;
                self.title = nil;
                
                //////////////////////////////////////////////////
                
                UIBarButtonItem *leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
                if(leftBarButtonItem==nil)
                {
                    break;
                }
                
                self.navigationItem.leftBarButtonItem = leftBarButtonItem;
                
                //////////////////////////////////////////////////
                
                if(self.hidenPPButtonBack==NO)
                {
                    PPBarViewBlockModel *customBlockModel = nil;
                    PPBarViewItemModel *customItemModel = nil;
                    
                    // get block model or item model
                    if ([self.delegate respondsToSelector:@selector(closeBlockModelForSelectItemViewController:)])
                    {
                        customBlockModel = [self.delegate closeBlockModelForSelectItemViewController:self];
                    }
                    else if ([self.delegate respondsToSelector:@selector(closeItemModelForSelectItemViewController:)])
                    {
                        customItemModel = [self.delegate closeItemModelForSelectItemViewController:self];
                    }
                    
                    //////////////////////////////////////////////////
                    if (customBlockModel) //有block model
                    {
                        [self.ppNavigationBarView setBlockModel:customBlockModel forType:PPBarViewBlockType_Left];
                    }
                    else if (customItemModel) // 有item model
                    {
                        [self.ppNavigationBarView setItemModels:@[customItemModel] forBlockType:PPBarViewBlockType_Left];
                    }
                    else //沒有block model, item model
                    {
                        //////////////////////////////////////////////////
                        // Get buttonClose by delegate or default, if not respond to delegate.
                        if(self.delegate != nil &&
                           [self.delegate respondsToSelector:@selector(buttonCloseForSelectItemViewController:)]==YES)
                        {
                            self.ppButtonBack = [self.delegate buttonCloseForSelectItemViewController:self];
                        }
                        else
                        {
                            PPButton *ppButtonBack = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
                            
                            if( ppButtonBack != nil)
                            {
                                self.ppButtonBack = ppButtonBack;
                                [self.ppButtonBack setBackgroundImageWithName:ImageNamePPButtonBackgroundForBack];
                                [self.ppButtonBack setTitle:NSLocalizedStringFromTable(@"MLS_Back", NSStringFromClass(self.ppButtonBack.class), nil) maxWidth:0];
                                [ppButtonBack release];
                            }
                            
                        }
                        
                        if(self.ppButtonBack != nil)
                        {
                            [self.ppButtonBack addControlEvents:UIControlEventTouchUpInside];
                            self.ppButtonBack.delegate    = self;
                            self.ppButtonBack.tag         = PPSelectItemViewControllerButtonTag_Back;
                            [self.ppNavigationBarView setViews:@[self.ppButtonBack]
                                                  forBlockType:PPBarViewBlockType_Left];
                        }
                    }
                }
                
                //////////////////////////////////////////////////
                // 右邊按鈕
                PPBarViewBlockModel *rightBlockModel = nil;
                
                if ([self.delegate respondsToSelector:@selector(rightBlockModelForSelectItemViewController:)])
                {
                    rightBlockModel = [self.delegate rightBlockModelForSelectItemViewController:self];
                }
                
                if (rightBlockModel) //有block model
                {
                    [self.ppNavigationBarView setBlockModel:rightBlockModel forType:PPBarViewBlockType_Right];
                }
                
            }
            else
            {
                [self.navigationController.navigationItem setTitle:self.title];
            }
         
            
        }while(0);
        
        //////////////////////////////////////////////////
        
        do
        {
            self.ppTableView = [[[PPTableView alloc] initWithFrame:self.view.bounds style:UITableViewStyleGrouped] autorelease];
            if(self.ppTableView==nil)
            {
                break;
            }
            
            self.ppTableView.alwaysBounceHorizontal	= NO;
            self.ppTableView.alwaysBounceVertical   = NO;
            self.ppTableView.dataSource             = self;
            self.ppTableView.delegate               = self;
            self.ppTableView.separatorStyle         = UITableViewCellSeparatorStyleSingleLine;
            self.ppTableView.backgroundColor        = self.tableViewBackgroundColor;
            
            //////////////////////////////////////////////////

            if ([self.ppTableView respondsToSelector:@selector(setSeparatorInset:)])
            {
                [self.ppTableView setSeparatorInset:UIEdgeInsetsZero];
            }

            //////////////////////////////////////////////////

            [self.view addSubview:self.ppTableView];
            
        }while(0);
    }
}

//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
	[self.ppTableView removeFromSuperview];
    self.ppTableView = nil;
    
    //////////////////////////////////////////////////
    
    self.ppButtonBack = nil;
    
    //////////////////////////////////////////////////
    
    self.navigationItem.leftBarButtonItem = nil;
    self.title = self.ppNavigationBarView.titleLabel.text;
    self.ppNavigationBarView = nil;
    
    //////////////////////////////////////////////////
    
	[super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Overriding Methods

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
	self.ppTableView.frame = [self layoutFrame];
}


//==============================================================================
//
//==============================================================================
- (void)setTableViewBackgroundColor:(UIColor *)tableViewBackgroundColor
{
    [tableViewBackgroundColor retain];
    [_tableViewBackgroundColor release];
    _tableViewBackgroundColor = tableViewBackgroundColor;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - public


//==============================================================================
//
//==============================================================================
- (void)reloadTable
{
    [self.ppTableView reloadData];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
	switch(ppButton.tag)
	{
		case PPSelectItemViewControllerButtonTag_Back:
		{
            [self goBackAnimated:YES];
			break;
		}
		default:
		{
			break;
		}
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDataSource

//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *tableViewCell = nil;
    
    if([self.delegate respondsToSelector:@selector(ppSelectItemViewController:tableView:cellForRowAtIndexPath:)]==YES)
    {
        tableViewCell = [self.delegate ppSelectItemViewController:self tableView:tableView cellForRowAtIndexPath:indexPath];
    }
    
    //////////////////////////////////////////////////

    do
    {
        if(tableViewCell!=nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        PPRowModel *rowModel = [self.ppSectionController rowModelAtIndexPath:indexPath forSearching:self.searchDisplayController.isActive];

        //////////////////////////////////////////////////
        
        PPTableViewCell *ppTableViewCell = (PPTableViewCell *)[tableView dequeueReusableCellWithIdentifier:NSStringFromClass([PPTableViewCell class])];
        
        if(ppTableViewCell==nil)
        {
            ppTableViewCell = [[[PPTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                                      reuseIdentifier:NSStringFromClass([PPTableViewCell class])] autorelease];
            
            ppTableViewCell.detailTextLabel.adjustsFontSizeToFitWidth   = YES;
            ppTableViewCell.textLabel.adjustsFontSizeToFitWidth         = YES;
        }
        
        if (rowModel)
        {
            ppTableViewCell.accessoryType           = (rowModel.object!=nil?UITableViewCellAccessoryCheckmark:UITableViewCellAccessoryNone);
            ppTableViewCell.detailTextLabel.text    = rowModel.detailText;
            ppTableViewCell.textLabel.text          = rowModel.text;
        }
        
        tableViewCell = ppTableViewCell;
        
    }while(0);

   
    return tableViewCell;
}

//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return [self.ppSectionController numberOfSectionsForSearching:self.searchDisplayController.isActive];
}

//================================================================================
//
//================================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
	return [self.ppSectionController numberOfRowsInSection:section forSearching:self.searchDisplayController.isActive];
}

//================================================================================
//
//================================================================================
- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section
{
    return [self.ppSectionController titleForHeaderInSection:section forSearching:self.searchDisplayController.isActive];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDelegate

//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    //////////////////////////////////////////////////
    
    do
    {
        NSMutableArray *sectionModels = [self.ppSectionController sectionModelsForSearching:self.searchDisplayController.isActive];
        if(sectionModels==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        for(PPSectionModel *sectionModel in sectionModels)
        {
            for(PPRowModel *rowModel in sectionModel.rowModels)
            {
                NSIndexPath *currentIndexPath = [NSIndexPath indexPathForRow:[sectionModel.rowModels indexOfObject:rowModel]
                                                                   inSection:[sectionModels indexOfObject:sectionModel]];
                //////////////////////////////////////////////////
                
                if(currentIndexPath.section==indexPath.section && currentIndexPath.row==indexPath.row)
                {
                    if(rowModel.object==nil)
                    {
                        if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppSelectItemViewController:selectRowModel:sectionModel:)]==YES)
                        {
                            [self.delegate ppSelectItemViewController:self selectRowModel:rowModel sectionModel:sectionModel];
                        }
                        
                        rowModel.object = [NSNumber numberWithBool:YES];
                    }
                    
                    //////////////////////////////////////////////////
                    
                    [tableView cellForRowAtIndexPath:currentIndexPath].accessoryType = UITableViewCellAccessoryCheckmark;
                }
                else
                {
                    if(rowModel.object!=nil)
                    {
                        rowModel.object = nil;
                    }
                    
                    //////////////////////////////////////////////////
                    
                    [tableView cellForRowAtIndexPath:currentIndexPath].accessoryType = UITableViewCellAccessoryNone;
                }
            }
        }
        
    }while(0);
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPAppearance protocol methods

//================================================================================
//
//================================================================================
+ (id)appearance
{
    // MARK: 實作+appearance的方式固定如下
    return [PPAppearance appearanceForClass:[self class]];
}

@end
