//
//  PPIndexSectionController.m
//  
//
//  Created by Mike on 13/5/30.
//  Copyright (c) 2013年 Mike.Shih. All rights reserved.
//

#import "PPIndexSectionController.h"

@implementation PPIndexSectionController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize	style = style_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//================================================================================
//
//================================================================================
- (NSArray *)indexs
{
    NSArray *indexs = nil;
    
    switch(self.style)
    {
        case PPIndexSectionControllerStyle_English:
        case PPIndexSectionControllerStyle_Zhuyin:
        case PPIndexSectionControllerStyle_Hanpin:
        case PPIndexSectionControllerStyle_Stroke:
        case PPIndexSectionControllerStyle_Hiragana:
        case PPIndexSectionControllerStyle_Hangul:
        case PPIndexSectionControllerStyle_Swedish:
        case PPIndexSectionControllerStyle_Thai:
        {
            indexs = [PPIndexingController indexsForStyle:(PPIndexingStyle)self.style];
            break;
        }
        case PPIndexSectionControllerStyle_ThaiAndEnglish:
        {
            NSMutableArray *thaiAndEnglishIndexs = [[NSMutableArray alloc] init];
            if(thaiAndEnglishIndexs!=nil)
            {
                NSArray *thaiIndexs   = [PPIndexingController indexsForStyle:PPIndexingStyle_Thai];
                for(NSString *thaiIndex in thaiIndexs)
                {
                    if([thaiIndex compare:PPIndexStringOfOther]!=NSOrderedSame)
                    {
                        [thaiAndEnglishIndexs addObject:thaiIndex];
                    }
                }
                
                //////////////////////////////////////////////////
                
                NSArray *englishIndexs  = [PPIndexingController indexsForStyle:PPIndexingStyle_English];
                for(NSString *englishIndex in englishIndexs)
                {
                    if([englishIndex compare:PPIndexStringOfOther]!=NSOrderedSame)
                    {
                        [thaiAndEnglishIndexs addObject:englishIndex];
                    }
                }
                
                //////////////////////////////////////////////////
                
                [thaiAndEnglishIndexs addObject:PPIndexStringOfOther];
                
                indexs = [NSArray arrayWithArray:thaiAndEnglishIndexs];
                
                //////////////////////////////////////////////////
                
                [thaiAndEnglishIndexs release];
            }
            
            break;
        }
        case PPIndexSectionControllerStyle_ZhuyinAndEnglish:
        {
            NSMutableArray *strokeAndEnglishIndexs = [[NSMutableArray alloc] init];
            if(strokeAndEnglishIndexs!=nil)
            {
                NSArray *strokeIndexs   = [PPIndexingController indexsForStyle:PPIndexingStyle_Zhuyin];
                for(NSString *strokeIndex in strokeIndexs)
                {
                    if([strokeIndex compare:PPIndexStringOfOther]!=NSOrderedSame)
                    {
                        [strokeAndEnglishIndexs addObject:strokeIndex];
                    }
                }
                
                //////////////////////////////////////////////////
                
                NSArray *englishIndexs  = [PPIndexingController indexsForStyle:PPIndexingStyle_English];
                for(NSString *englishIndex in englishIndexs)
                {
                    if([englishIndex compare:PPIndexStringOfOther]!=NSOrderedSame)
                    {
                        [strokeAndEnglishIndexs addObject:englishIndex];
                    }
                }
                
                //////////////////////////////////////////////////
                
                [strokeAndEnglishIndexs addObject:PPIndexStringOfOther];
                
                indexs = [NSArray arrayWithArray:strokeAndEnglishIndexs];
                
                //////////////////////////////////////////////////
                
                [strokeAndEnglishIndexs release];
            }
            
            break;
        }
        case PPIndexSectionControllerStyle_StrokeAndEnglish:
        {
            NSMutableArray *strokeAndEnglishIndexs = [[NSMutableArray alloc] init];
            if(strokeAndEnglishIndexs!=nil)
            {
                NSArray *strokeIndexs   = [PPIndexingController indexsForStyle:PPIndexingStyle_Stroke];
                for(NSString *strokeIndex in strokeIndexs)
                {
                    if([strokeIndex compare:PPIndexStringOfOther]!=NSOrderedSame)
                    {
                        [strokeAndEnglishIndexs addObject:strokeIndex];
                    }
                }
                
                //////////////////////////////////////////////////
                
                NSArray *englishIndexs  = [PPIndexingController indexsForStyle:PPIndexingStyle_English];
                for(NSString *englishIndex in englishIndexs)
                {
                    if([englishIndex compare:PPIndexStringOfOther]!=NSOrderedSame)
                    {
                        [strokeAndEnglishIndexs addObject:englishIndex];
                    }
                }
                
                //////////////////////////////////////////////////
                
                [strokeAndEnglishIndexs addObject:PPIndexStringOfOther];
                
                indexs = [NSArray arrayWithArray:strokeAndEnglishIndexs];
                
                //////////////////////////////////////////////////
                
                [strokeAndEnglishIndexs release];
            }
            
            break;
        }
        case PPIndexSectionControllerStyle_HiraganaAndEnglish:
        {
            NSMutableArray *strokeAndEnglishIndexs = [[NSMutableArray alloc] init];
            if(strokeAndEnglishIndexs!=nil)
            {
                NSArray *strokeIndexs   = [PPIndexingController indexsForStyle:PPIndexingStyle_Hiragana];
                for(NSString *strokeIndex in strokeIndexs)
                {
                    if([strokeIndex compare:PPIndexStringOfOther]!=NSOrderedSame)
                    {
                        [strokeAndEnglishIndexs addObject:strokeIndex];
                    }
                }
                
                //////////////////////////////////////////////////
                
                NSArray *englishIndexs  = [PPIndexingController indexsForStyle:PPIndexingStyle_English];
                for(NSString *englishIndex in englishIndexs)
                {
                    if([englishIndex compare:PPIndexStringOfOther]!=NSOrderedSame)
                    {
                        [strokeAndEnglishIndexs addObject:englishIndex];
                    }
                }
                
                //////////////////////////////////////////////////
                
                [strokeAndEnglishIndexs addObject:PPIndexStringOfOther];
                
                indexs = [NSArray arrayWithArray:strokeAndEnglishIndexs];
                
                //////////////////////////////////////////////////
                
                [strokeAndEnglishIndexs release];
            }
            
            break;
        }
        case PPIndexSectionControllerStyle_HangulAndEnglish:
        {
            NSMutableArray *strokeAndEnglishIndexs = [[NSMutableArray alloc] init];
            if(strokeAndEnglishIndexs!=nil)
            {
                NSArray *strokeIndexs   = [PPIndexingController indexsForStyle:PPIndexingStyle_Hangul];
                for(NSString *strokeIndex in strokeIndexs)
                {
                    if([strokeIndex compare:PPIndexStringOfOther]!=NSOrderedSame)
                    {
                        [strokeAndEnglishIndexs addObject:strokeIndex];
                    }
                }
                
                //////////////////////////////////////////////////
                
                NSArray *englishIndexs  = [PPIndexingController indexsForStyle:PPIndexingStyle_English];
                for(NSString *englishIndex in englishIndexs)
                {
                    if([englishIndex compare:PPIndexStringOfOther]!=NSOrderedSame)
                    {
                        [strokeAndEnglishIndexs addObject:englishIndex];
                    }
                }
                
                //////////////////////////////////////////////////
                
                [strokeAndEnglishIndexs addObject:PPIndexStringOfOther];
                
                indexs = [NSArray arrayWithArray:strokeAndEnglishIndexs];
                
                //////////////////////////////////////////////////
                
                [strokeAndEnglishIndexs release];
            }
            
            break;
        }
        case PPIndexSectionControllerStyle_Time:
        case PPIndexSectionControllerStyle_None:
        default:
        {
            break;
        }
    }
    
    return indexs;
}

//================================================================================
//
//================================================================================
- (NSArray *)sectionIndexTitles
{
    NSMutableArray *sectionIndexTitles = [[[NSMutableArray alloc] init] autorelease];
    
    @autoreleasepool
    {
        do
        {
            if(sectionIndexTitles==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            switch(self.style)
            {
                case PPIndexSectionControllerStyle_English:
                case PPIndexSectionControllerStyle_Hanpin:
                {
                    [sectionIndexTitles addObjectsFromArray:[NSArray arrayWithObjects:
                                                             @"A",
                                                             @"B",
                                                             @"C",
                                                             @"D",
                                                             @"E",
                                                             @"F",
                                                             @"G",
                                                             @"H",
                                                             @"I",
                                                             @"J",
                                                             @"K",
                                                             @"L",
                                                             @"M",
                                                             @"N",
                                                             @"O",
                                                             @"P",
                                                             @"Q",
                                                             @"R",
                                                             @"S",
                                                             @"T",
                                                             @"U",
                                                             @"V",
                                                             @"W",
                                                             @"X",
                                                             @"Y",
                                                             @"Z",
                                                             nil]];
                    break;
                }
                case PPIndexSectionControllerStyle_Zhuyin:
                {
                    [sectionIndexTitles addObjectsFromArray:[NSArray arrayWithObjects:
                                                             @"ㄅ",
                                                             @"•",
                                                             @"ㄉ",
                                                             @"•",
                                                             @"ㄍ",
                                                             @"•",
                                                             @"ㄐ",
                                                             @"•",
                                                             @"ㄓ",
                                                             @"•",
                                                             @"ㄗ",
                                                             @"•",
                                                             @"ㄚ",
                                                             @"•",
                                                             @"ㄞ",
                                                             @"•",
                                                             @"ㄢ",
                                                             @"•",
                                                             @"ㄦ",
                                                             @"•",
                                                             @"ㄧ",
                                                             nil]];
                    break;
                }
                case PPIndexSectionControllerStyle_Hiragana:
                {
                    [sectionIndexTitles addObjectsFromArray:[NSArray arrayWithObjects:
                                                             @"あ",
                                                             @"•",
                                                             @"か",
                                                             @"•",
                                                             @"さ",
                                                             @"•",
                                                             @"た",
                                                             @"•",
                                                             @"な",
                                                             @"•",
                                                             @"は",
                                                             @"•",
                                                             @"ま",
                                                             @"•",
                                                             @"や",
                                                             @"•",
                                                             @"ら",
                                                             @"•",
                                                             @"わ",
                                                             nil]];
                    break;
                }
                case PPIndexSectionControllerStyle_Hangul:
                {
                    [sectionIndexTitles addObjectsFromArray:[NSArray arrayWithObjects:
                                                             @"ㄱ",
                                                             @"ㄲ",
                                                             @"ㄴ",
                                                             @"ㄷ",
                                                             @"ㄸ",
                                                             @"ㄹ",
                                                             @"ㅁ",
                                                             @"ㅂ",
                                                             @"ㅃ",
                                                             @"ㅅ",
                                                             @"ㅆ",
                                                             @"ㅇ",
                                                             @"ㅈ",
                                                             @"ㅉ",
                                                             @"ㅊ",
                                                             @"ㅋ",
                                                             @"ㅌ",
                                                             @"ㅍ",
                                                             @"ㅎ",
                                                             nil]];
                    break;
                }
                case PPIndexSectionControllerStyle_Stroke:
                {
                    [sectionIndexTitles addObjectsFromArray:[NSArray arrayWithObjects:
                                                             @"1",
                                                             @"•",
                                                             @"4",
                                                             @"•",
                                                             @"7",
                                                             @"•",
                                                             @"10",
                                                             @"•",
                                                             @"13",
                                                             @"•",
                                                             @"16",
                                                             @"•",
                                                             @"19",
                                                             @"•",
                                                             @"22",
                                                             @"•",
                                                             @"25",
                                                             @"•",
                                                             @"28",
                                                             nil]];
                    break;
                }
                case PPIndexSectionControllerStyle_ZhuyinAndEnglish:
                {
                    [sectionIndexTitles addObjectsFromArray:[NSArray arrayWithObjects:
                                                             @"ㄅ",
                                                             @"•",
                                                             @"ㄉ",
                                                             @"•",
                                                             @"ㄍ",
                                                             @"•",
                                                             @"ㄐ",
                                                             @"•",
                                                             @"ㄓ",
                                                             @"•",
                                                             @"ㄗ",
                                                             @"•",
                                                             @"ㄚ",
                                                             @"•",
                                                             @"ㄞ",
                                                             @"•",
                                                             @"ㄢ",
                                                             @"•",
                                                             @"ㄦ",
                                                             @"•",
                                                             @"ㄧ",
                                                             @"•",
                                                             @"A",
                                                             @"•",
                                                             @"E",
                                                             @"•",
                                                             @"I",
                                                             @"•",
                                                             @"M",
                                                             @"•",
                                                             @"R",
                                                             @"•",
                                                             @"V",
                                                             @"•",
                                                             @"Z",
                                                             nil]];
                    break;
                }
                case PPIndexSectionControllerStyle_StrokeAndEnglish:
                {
                    [sectionIndexTitles addObjectsFromArray:[NSArray arrayWithObjects:
                                                             @"1",
                                                             @"•",
                                                             @"4",
                                                             @"•",
                                                             @"7",
                                                             @"•",
                                                             @"10",
                                                             @"•",
                                                             @"13",
                                                             @"•",
                                                             @"16",
                                                             @"•",
                                                             @"19",
                                                             @"•",
                                                             @"22",
                                                             @"•",
                                                             @"25",
                                                             @"•",
                                                             @"A",
                                                             @"•",
                                                             @"E",
                                                             @"•",
                                                             @"I",
                                                             @"•",
                                                             @"M",
                                                             @"•",
                                                             @"R",
                                                             @"•",
                                                             @"V",
                                                             @"•",
                                                             @"Z",
                                                             nil]];
                    break;
                }
                case PPIndexSectionControllerStyle_HiraganaAndEnglish:
                {
                    [sectionIndexTitles addObjectsFromArray:[NSArray arrayWithObjects:
                                                             @"あ",
                                                             @"•",
                                                             @"か",
                                                             @"•",
                                                             @"さ",
                                                             @"•",
                                                             @"た",
                                                             @"•",
                                                             @"な",
                                                             @"•",
                                                             @"は",
                                                             @"•",
                                                             @"ま",
                                                             @"•",
                                                             @"や",
                                                             @"•",
                                                             @"ら",
                                                             @"•",
                                                             @"わ",
                                                             @"•",
                                                             @"A",
                                                             @"•",
                                                             @"E",
                                                             @"•",
                                                             @"I",
                                                             @"•",
                                                             @"M",
                                                             @"•",
                                                             @"R",
                                                             @"•",
                                                             @"V",
                                                             @"•",
                                                             @"Z",
                                                             nil]];
                    break;
                }
                case PPIndexSectionControllerStyle_HangulAndEnglish:
                {
                    [sectionIndexTitles addObjectsFromArray:[NSArray arrayWithObjects:
                                                             @"ᄀ",
                                                             @"ᄁ",
                                                             @"ᄂ",
                                                             @"ᄃ",
                                                             @"ᄄ",
                                                             @"ᄅ",
                                                             @"ᄆ",
                                                             @"ᄇ",
                                                             @"ᄈ",
                                                             @"ᄉ",
                                                             @"ᄊ",
                                                             @"ᄋ",
                                                             @"ᄌ",
                                                             @"ᄍ",
                                                             @"ᄎ",
                                                             @"ᄏ",
                                                             @"ᄐ",
                                                             @"ᄑ",
                                                             @"ᄒ",
                                                             @"•",
                                                             @"A",
                                                             @"•",
                                                             @"E",
                                                             @"•",
                                                             @"I",
                                                             @"•",
                                                             @"M",
                                                             @"•",
                                                             @"R",
                                                             @"•",
                                                             @"V",
                                                             @"•",
                                                             @"Z",
                                                             nil]];
                    break;
                }
                case PPIndexSectionControllerStyle_ThaiAndEnglish:
                {
                    [sectionIndexTitles addObjectsFromArray:[NSArray arrayWithObjects:
                                                             @"ก",
                                                             @"•",
                                                             @"ฆ",
                                                             @"•",
                                                             @"ซ",
                                                             @"•",
                                                             @"ฐ",
                                                             @"•",
                                                             @"ต",
                                                             @"•",
                                                             @"บ",
                                                             @"•",
                                                             @"ฟ",
                                                             @"•",
                                                             @"ล",
                                                             @"•",
                                                             @"ห",
                                                             @"•",
                                                             @"A",
                                                             @"•",
                                                             @"E",
                                                             @"•",
                                                             @"I",
                                                             @"•",
                                                             @"M",
                                                             @"•",
                                                             @"R",
                                                             @"•",
                                                             @"V",
                                                             @"•",
                                                             @"Z",
                                                             nil]];
                    break;
                }
                case PPIndexSectionControllerStyle_Swedish:
                {
                    [sectionIndexTitles addObjectsFromArray:[NSArray arrayWithObjects:
                                                             @"A",
                                                             @"B",
                                                             @"C",
                                                             @"D",
                                                             @"E",
                                                             @"F",
                                                             @"G",
                                                             @"H",
                                                             @"I",
                                                             @"J",
                                                             @"K",
                                                             @"L",
                                                             @"M",
                                                             @"N",
                                                             @"O",
                                                             @"P",
                                                             @"Q",
                                                             @"R",
                                                             @"S",
                                                             @"T",
                                                             @"U",
                                                             @"V",
                                                             @"W",
                                                             @"X",
                                                             @"Y",
                                                             @"Z",
                                                             @"Å",
                                                             @"Ä",
                                                             @"Ö",
                                                             nil]];
                    break;
                }
                case PPIndexSectionControllerStyle_Time:
                case PPIndexSectionControllerStyle_None:
                default:
                {
                    break;
                }
            }
            
            //////////////////////////////////////////////////
            
            [sectionIndexTitles addObject:PPIndexStringOfOther];
            
        }while(0);
    }
    
    //////////////////////////////////////////////////
    
    if([sectionIndexTitles count]==0)
    {
        sectionIndexTitles = nil;
    }
    
    //////////////////////////////////////////////////
    
    return sectionIndexTitles;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Overwrite Methods

//================================================================================
//
//================================================================================
- (NSInteger)sectionForSectionIndexTitle:(NSString *)title forSearching:(BOOL)searching
{
    NSInteger section = PPSectionNULL;
    
    do
    {
        if(title==nil || [title isEqualToString:@"•"])
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSMutableArray *sectionModels = [self sectionModelsForSearching:searching];
        if(sectionModels==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSUInteger sectionModelsCount = [sectionModels count];
        
        //////////////////////////////////////////////////
        //只有一個section,就不用找了
        
        if(sectionModelsCount==1)
        {
            section = 0;
            break;
        }
        
        //////////////////////////////////////////////////
		//Other一定是在最後面
        
		if([title isEqualToString:PPIndexStringOfOther]==YES)
		{
			return sectionModelsCount-1;
		}
        
        //////////////////////////////////////////////////
		
        NSArray *indexs = [self indexs];
        if(indexs==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        //先找出要找的title在indexs的位置,然後反向尋找最接近的Section
        
        if([indexs indexOfObject:title]!=NSNotFound)
        {
            for(NSInteger titleIndex=[indexs indexOfObject:title]; titleIndex>=0; titleIndex--)
            {
                for(PPSectionModel *sectionModel in sectionModels)
                {
                    if([sectionModel title]==nil)
                    {
                        break;
                    }
                    //檢查是否有符合的Section存在
                    else if([[sectionModel title] isEqualToString:[indexs objectAtIndex:titleIndex]]==YES)
                    {
                        section = [sectionModels indexOfObject:sectionModel];
                        
                        break;
                    }
                }
                
                if(section!=PPSectionNULL)
                {
                    break;
                }
            }
        }
    }while(0);
	
	return section;
}

@end
