//
//  PPSectionHeaderView.m
//  
//
//  Created by Mike on 13/5/28.
//  Copyright (c) 2013年 Mike.Shih. All rights reserved.
//

#import "PPSectionHeaderView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPSectionHeaderView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize textLabel   = textLabel_;
@synthesize gap         = gap_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    if((self = [super initWithFrame:frame])) 
    {
        gap_ = PPSectionHeaderViewDefaultGapPlain;
        
        //////////////////////////////////////////////////
        
        textLabel_ = [[UILabel alloc] init];
		if(self.textLabel!=nil)
        {
            self.textLabel.backgroundColor	= [UIColor clearColor];
            
            [self addSubview:self.textLabel];
        }
    }
    
    return self;
}

//================================================================================
//
//================================================================================
-(id)initWithImage:(UIImage *)image
{
    if((self = [self initWithFrame:CGRectZero])) 
    {
        self.image = image;
    }
    
    return self;
}

//================================================================================
//
//================================================================================
- (void)dealloc 
{
	[self.textLabel removeFromSuperview];
	[textLabel_ release];
	
    //////////////////////////////////////////////////

    [super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
	[super layoutSubviews];
    
    //////////////////////////////////////////////////
	
	self.textLabel.frame = CGRectMake(self.gap, 0, self.bounds.size.width-(self.gap*2), self.bounds.size.height);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//================================================================================
//
//================================================================================
- (void)setGap:(CGFloat)gap
{
    if(self.gap!=gap) 
    {
        gap_ = gap;
        
        [self layoutSubviews];
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

//================================================================================
//
//================================================================================
+ (CGFloat)defaultGapPlain
{
    return PPSectionHeaderViewDefaultGapPlain;
}

//================================================================================
//
//================================================================================
+ (CGFloat)defaultGapGroup
{
    CGFloat gap = 0;
    
    if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
    {
        gap = PPSectionHeaderViewDefaultGapGroupedForiPad;
    }
    else 
    {
        gap = PPSectionHeaderViewDefaultGapGroupedForiPhone;
    }
    
    return gap;
}

@end
