//
//  PPSalesforceLoginView.m
//  Pods
//
//  Created by sanhue on 2016/9/19.
//
//

#import "PPSalesforceLoginView.h"
#import "SalesforceParamHelper.h"
#import "NSURL+SFAdditions.h"

#import "PPLogControllerExtension.h"

//#define SHOWLOG

#if TARGET_OS_IPHONE
#import "PPBusyView.h"
#endif

//這個要在salesforce後台設定才能用
static NSString * const OAuthRedirectURI    = @"testsfdc:///mobilesdk/detect/oauth/done";
static NSString * const OAuthProtocol       = @"https";
static NSString * const OAuthBaseURL        = @"login.salesforce.com";

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark copy from SalesforceSDK, SFOAuthCoordinator.m
// Public constants

const NSTimeInterval kSFOAuthDefaultTimeout                     = 120.0; // seconds
NSString * const     kPPSFOAuthErrorDomain                        = @"com.salesforce.OAuth.ErrorDomain";

// Private constants

static NSString * const kSFOAuthEndPointAuthorize               = @"/services/oauth2/authorize";    // user agent flow
static NSString * const kSFOAuthEndPointToken                   = @"/services/oauth2/token";            // web server flow
static NSString * const kSFOAuthEndPointUserInfo                = @"/services/oauth2/userinfo";    // user agent flow

// Advanced auth constants
static NSString * const kSFOAuthClientId                        = @"client_id";
static NSString * const kSFOAuthClientSecret                    = @"client_secret";
static NSString * const kSFOAuthRedirectUri                     = @"redirect_uri";

static NSString * const kSFOAuthDisplay                         = @"display";
static NSString * const kSFOAuthDisplayTouch                    = @"touch";
static NSString * const kSFOAuthResponseType                    = @"response_type";
static NSString * const kSFOAuthResponseTypeToken               = @"token";
static NSString * const kSFOAuthResponseTypeCode                = @"code";
static NSString * const kSFOAuthPrompt                          = @"prompt";
static NSString * const kSFOAuthPromptLogin                     = @"login";
static NSString * const kSFOAuthPromptConsent                   = @"consent";
static NSString * const kSFOAuthPromptSelectAccount             = @"select_account";

// get token
static NSString * const kSFOAuthGrantType                       = @"grant_type";
static NSString * const kSFOAuthApprovalCode                    = @"code";
static NSString * const kSFOAuthGrantTypeAuthCode               = @"authorization_code";
static NSString * const kSFOAuthFormat                          = @"format";
static NSString * const kSFOAuthFormatJSON                      = @"json";

static NSUInteger kSFOAuthReponseBufferLength                   = 512; // bytes

static NSString * const kHttpMethodPost                         = @"POST";
static NSString * const kHttpHeaderContentType                  = @"Content-Type";
static NSString * const kHttpPostContentType                    = @"application/x-www-form-urlencoded";


// user info
static NSString * const kSFOAuthResponseUserName                = @"username";
static NSString * const kSFOAuthResponseFullName                = @"display_name";
static NSString * const kSFOAuthResponseNickName                = @"nick_name";

// response param key
static NSString * const kSFOAuthError                           = @"error";
static NSString * const kSFOAuthErrorDescription                = @"error_description";

NSString * const kSFOAuthAccessToken                     = @"access_token";
NSString * const kSFOAuthIdentityUrl                     = @"id";
NSString * const kSFOAuthInstanceUrl                     = @"instance_url";
NSString * const kSFOAuthIssuedAt                        = @"issued_at";
NSString * const kSFOAuthRefreshToken                    = @"refresh_token";
NSString * const kSFOAuthAPI                             = @"api";
NSString * const kSFOAuthScope                           = @"scope";
NSString * const kSFOAuthSignature                       = @"signature";
NSString * const kSFOAuthTokenType                       = @"token_type";
NSString * const kSFOAuthUserAccount                     = @"UserAccount";
NSString * const kSFOAuthExportMode                      = @"crmExportMode";

NSString * const kSFOAuthFullName                        = @"Fullname";
NSString * const kSFOAuthNickName                        = @"Nickname";

// OAuth Error Descriptions
// see https://na1.salesforce.com/help/doc/en/remoteaccess_oauth_refresh_token_flow.htm

static NSString * const kSFECParameter = @"ec";

static NSString * const kPPSFOAuthErrorTypeMalformedResponse          = @"malformed_response";
static NSString * const kPPSFOAuthErrorTypeAccessDenied               = @"access_denied";
static NSString * const kPPSFOAuthErrorTypeInvalidClientId            = @"invalid_client_id"; // invalid_client_id:'client identifier invalid'
// this may be returned when the refresh token is revoked
// TODO: needs clarification
static NSString * const kPPSFOAuthErrorTypeInvalidClient              = @"invalid_client";    // invalid_client:'invalid client credentials'
// this is returned when refresh token is revoked
static NSString * const kPPSFOAuthErrorTypeInvalidClientCredentials   = @"invalid_client_credentials"; // this is documented but hasn't been witnessed
static NSString * const kPPSFOAuthErrorTypeInvalidGrant               = @"invalid_grant";
static NSString * const kPPSFOAuthErrorTypeInvalidRequest             = @"invalid_request";
static NSString * const kPPSFOAuthErrorTypeInactiveUser               = @"inactive_user";
static NSString * const kPPSFOAuthErrorTypeInactiveOrg                = @"inactive_org";
static NSString * const kPPSFOAuthErrorTypeRateLimitExceeded          = @"rate_limit_exceeded";
static NSString * const kPPSFOAuthErrorTypeUnsupportedResponseType    = @"unsupported_response_type";
static NSString * const kPPSFOAuthErrorTypeTimeout                    = @"auth_timeout";
static NSString * const kPPSFOAuthErrorTypeWrongVersion               = @"wrong_version";     // credentials do not match current Connected App version in the org
static NSString * const kPPSFOAuthErrorTypeBrowserLaunchFailed        = @"browser_launch_failed";
static NSString * const kPPSFOAuthErrorTypeUnknownAdvancedAuthConfig  = @"unknown_advanced_auth_config";
static NSString * const kPPSFOAuthErrorTypeJWTLaunchFailed            = @"jwt_launch_failed";
static NSString * const kPPSFOAuthErrorTypeFetchUserInfoFailed        = @"fetch_userinfo_failed";

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface PPSalesforceLoginView () <WKNavigationDelegate>

@property (nonatomic, retain) NSString  *clientID;
@property (nonatomic, retain) NSString  *clientSecret;
@property (nonatomic, retain) NSString  *redirectURI;

#if TARGET_OS_IPHONE
@property (nonatomic, retain) PPBusyView *busyIndicator;
#else
@property (nonatomic, retain) NSProgressIndicator *busyIndicator;
#endif

@property (nonatomic, copy) PPSFLoginCompleteHandler loginCompleteHandler;


@end


//#define USE_USER_AGENT_FLOW
////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation PPSalesforceLoginView





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)initWithClientID:(NSString *)clientID
{
    return [self initWithClientID:clientID secret:nil];
}


//==============================================================================
//
//==============================================================================
- (instancetype)initWithClientID:(NSString *)clientID secret:(NSString *)secret
{
    self = [super initWithFrame:CGRectZero];
    if (self)
    {
        [self setNavigationDelegate:self];
        
        self.clientID = clientID;
        self.clientSecret = secret;
        self.redirectURI = OAuthRedirectURI;
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.navigationDelegate = nil;
    
    self.clientID = nil;
    self.clientSecret = nil;
    self.scopes = nil;
    self.customDomain = nil;
    self.loginCompleteHandler = nil;
    self.requestAuthTokenHandler = nil;
    self.sendLoginActionHandler = nil;
    
    self.redirectURI = nil;
    [self.busyIndicator removeFromSuperview];
    self.busyIndicator = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private


//==============================================================================
//
//==============================================================================
- (NSMutableString *)oauthConnectionURL
{
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    // E.g. https://login.salesforce.com/services/oauth2/authorize
    //      ?client_id=<Connected App ID>&redirect_uri=<Connected App Redirect URI>&display=touch
    // !! 沒有加scope時預設會用後台設定的權限執行，有scope則會以local的scope會主要求權限
    NSString *baseURL = OAuthBaseURL;
    if ([self.customDomain length]>0)
    {
        baseURL = self.customDomain;
    }
    
#ifdef USE_USER_AGENT_FLOW
    NSMutableString *oauthConnectionURL =  [[NSMutableString alloc] initWithFormat:@"%@://%@%@?%@=%@&%@=%@&%@=%@&%@=%@",
                                            OAuthProtocol, baseURL, kSFOAuthEndPointAuthorize,
                                            kSFOAuthClientId, self.clientID,
                                            kSFOAuthRedirectUri, self.redirectURI,
                                            kSFOAuthDisplay, kSFOAuthDisplayTouch,
                                            kSFOAuthResponseType, kSFOAuthResponseTypeToken];
#else
    NSMutableString *oauthConnectionURL =  [[NSMutableString alloc] initWithFormat:@"%@://%@%@?%@=%@&%@=%@&%@=%@&%@=%@",
                                            OAuthProtocol, baseURL, kSFOAuthEndPointAuthorize,
                                            kSFOAuthClientId, self.clientID,
                                            kSFOAuthRedirectUri, self.redirectURI,
                                            kSFOAuthDisplay, kSFOAuthDisplayTouch,
                                            kSFOAuthResponseType, kSFOAuthResponseTypeCode];

#endif
    NSString *scopeString = [self scopeQueryParamString];
    if (scopeString != nil) {
        [oauthConnectionURL appendString:scopeString];
    }
    return [oauthConnectionURL autorelease];
}


//==============================================================================
//
//==============================================================================
- (NSString *)tokenAuthURL
{
    NSString *baseURL = OAuthBaseURL;
    if ([self.customDomain length]>0)
    {
        baseURL = self.customDomain;
    }
    NSMutableString *oauthConnectionURL =  [[NSMutableString alloc] initWithFormat:@"%@://%@%@",
                                            OAuthProtocol, baseURL, kSFOAuthEndPointToken];
    
    return [oauthConnectionURL autorelease];
}



//==============================================================================
//
//==============================================================================
- (NSString *)scopeQueryParamString
{
    return nil;
    NSMutableSet *scopes = (self.scopes.count > 0 ? [NSMutableSet setWithSet:self.scopes] : [NSMutableSet set]);
    [scopes addObject:kSFOAuthRefreshToken];
    [scopes addObject:kSFOAuthAPI];
    NSString *scopeStr = [self stringByURLEncodingFromString:[[scopes allObjects] componentsJoinedByString:@" "]];
    return [NSString stringWithFormat:@"&%@=%@", kSFOAuthScope, scopeStr];
}


//==============================================================================
//
//==============================================================================
- (NSString *)stringByURLEncodingFromString:(NSString *)string
{
    if ([string length]==0)
    {
        return string;
    }
    NSCharacterSet *urlAllowedCharacterSet = [[NSCharacterSet characterSetWithCharactersInString:@" \"#%/:<>?@[\\]^`{|}&:/=+"] invertedSet];
    return [string stringByAddingPercentEncodingWithAllowedCharacters:urlAllowedCharacterSet];
}



//==============================================================================
//
//==============================================================================
- (void)loadURL:(NSString*)url withCookie:(BOOL)enableCookie
{
     PPLogFuncIn(@" url:%@ (%@", url, enableCookie?@"YES":@"NO");

    NSMutableURLRequest *request = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:url]];
    [request setHTTPShouldHandleCookies:enableCookie];
    [request setCachePolicy:NSURLRequestReloadIgnoringLocalCacheData]; // don't use cache
    
    [self loadRequest:request];
     PPLogFuncOut();

}


//==============================================================================
//
//==============================================================================
- (BOOL) isRedirectURL:(NSString *) requestUrlString
{
    return [[requestUrlString lowercaseString] hasPrefix:[self.redirectURI lowercaseString]];
}


//==============================================================================
// 由Code取得token
//==============================================================================
- (NSMutableDictionary *)loginTokenWithCode:(NSString *)code error:(NSError **)error
{
    NSString *url = [self tokenAuthURL];
    
    NSError *returnError = nil;
    NSURLResponse *response = nil;
    
    NSMutableURLRequest *urlRequest = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:url]];
    [urlRequest setHTTPMethod:kHttpMethodPost];
    [urlRequest setValue:kHttpPostContentType forHTTPHeaderField:kHttpHeaderContentType];
    [urlRequest setHTTPShouldHandleCookies:NO];

    NSMutableString *params = [[[NSMutableString alloc] initWithFormat:@"%@=%@&%@=%@&%@=%@&%@=%@",
                                kSFOAuthFormat, kSFOAuthFormatJSON,
                                kSFOAuthRedirectUri, self.redirectURI,
                                kSFOAuthClientId, self.clientID,
                                kSFOAuthClientSecret, self.clientSecret
                                ] autorelease] ;
    
    if([code length]>0)
    {
        [params appendFormat:@"&%@=%@&%@=%@", kSFOAuthGrantType, kSFOAuthGrantTypeAuthCode, kSFOAuthApprovalCode, code];
    }

    NSData *encodedBody = [params dataUsingEncoding:NSUTF8StringEncoding];
    [urlRequest setHTTPBody:encodedBody];
    
    NSData *downloadedData = [NSURLConnection sendSynchronousRequest:urlRequest returningResponse:&response error:&returnError];
    
    if (returnError!=nil)
    {
        if(error!=nil)
        {
            *error = [[self class] errorWithType:kPPSFOAuthErrorTypeFetchUserInfoFailed
                                     description:@"無法取得有效的帳號資訊"
                                          object:returnError];
            
        }
        
        // PPLogFuncOut(@" 無法取得有效的帳號資訊(%@)", returnError);
        return nil;
    }
    
    //////////////////////////////////////////////////
    // 取得user account
    NSDictionary *jsonSerialization = [NSJSONSerialization JSONObjectWithData:downloadedData
                                                                      options:NSJSONReadingAllowFragments
                                                                        error:&returnError];
    
    if (jsonSerialization == nil)
    {
        if(error!=nil)
        {
            *error = [[self class] errorWithType:kPPSFOAuthErrorTypeFetchUserInfoFailed
                                     description:@"無法解析json"
                                          object:returnError];
            
        }
        
        // PPLogFuncOut(@" 無法取得有效的帳號資訊(%@)", returnError);
        return nil;
    }
    else
    {
//        NSLog(@"jsonSerialization:%@", jsonSerialization);
        if (nil != jsonSerialization[kSFOAuthError])
        {
            if(error!=nil)
            {
                *error = [[self class] errorWithType:jsonSerialization[kSFOAuthError]
                                         description:jsonSerialization[kSFOAuthErrorDescription]
                                              object:jsonSerialization];
                
                // PPLogFuncOut(@" 無法取得有效的帳號資訊(%@)", *error);
            }
            return nil;
        }
    }
    return [NSMutableDictionary dictionaryWithDictionary:jsonSerialization];
}


//==============================================================================
//
//==============================================================================
- (NSMutableDictionary *)accountInfoWithParams:(NSMutableDictionary *)params error:(NSError **)error
{
    NSMutableDictionary *accountInfo = [NSMutableDictionary dictionary];
    
    NSError *returnError = nil;
    NSURLResponse *response = nil;

    NSString *userInfoURL = [params objectForKey:kSFOAuthIdentityUrl];
    
    NSMutableURLRequest *urlRequest = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:userInfoURL]];
    [urlRequest setValue:[NSString stringWithFormat:@"%@ %@", [params objectForKey:kSFOAuthTokenType], [params objectForKey:kSFOAuthAccessToken]]
      forHTTPHeaderField:@"Authorization"];
    
    NSData *downloadedData = [NSURLConnection sendSynchronousRequest:urlRequest returningResponse:&response error:&returnError];
    
    if (returnError!=nil)
    {
        if(error!=nil)
        {
            *error = [[self class] errorWithType:kPPSFOAuthErrorTypeFetchUserInfoFailed
                                     description:@"無法取得有效的帳號資訊"
                                          object:returnError];
            
        }
        
        // PPLogFuncOut(@" 無法取得有效的帳號資訊(%@)", returnError);
        return nil;
    }
    
    //////////////////////////////////////////////////
    // 取得user account
    NSDictionary *jsonSerialization = [NSJSONSerialization JSONObjectWithData:downloadedData
                                                                      options:NSJSONReadingAllowFragments
                                                                        error:&returnError];
    
    if (jsonSerialization == nil)
    {
        if(error!=nil)
        {
            *error = [[self class] errorWithType:kPPSFOAuthErrorTypeFetchUserInfoFailed
                                     description:@"無法取得有效的帳號資訊"
                                          object:returnError];
            
        }
        
        // PPLogFuncOut(@" 無法取得有效的帳號資訊(%@)", returnError);
        return nil;
    }
    else
    {
        NSString *userAccount = [jsonSerialization objectForKey:kSFOAuthResponseUserName];
        
        if ([userAccount length]>0)
        {
            [accountInfo setValue:userAccount forKey:kSFOAuthUserAccount];
        }
        
        // WC for salesforce需要顯示
        NSString *nickName = [jsonSerialization objectForKey:kSFOAuthResponseNickName];
        if ([nickName length]>0)
        {
            [accountInfo setValue:nickName forKey:kSFOAuthNickName];
        }
        
        // WC for salesforce需要顯示
        NSString *fullName = [jsonSerialization objectForKey:kSFOAuthResponseFullName];
        if ([fullName length]>0)
        {
            [accountInfo setValue:fullName forKey:kSFOAuthFullName];
        }
    }
    
    return accountInfo;
}


//==============================================================================
//
//==============================================================================
- (void)handleUserAgentResponse:(NSURL *)requestUrl
{
    // PPLogFuncIn(@"begin %@", requestUrl);
    NSString *response = nil;
    
    // Check for a response in the URL fragment first, then fall back to the query string.
    if ([requestUrl fragment])
    {
        response = [requestUrl fragment];
    }
    else if ([requestUrl query])
    {
        response = [requestUrl query];
    }
    else
    {
        
        NSError *error = [[self class] errorWithType:kPPSFOAuthErrorTypeMalformedResponse
                                         description:@"redirect response has no payload"
                                              object:nil];
        
        if(self.loginCompleteHandler)
        {
            self.loginCompleteHandler(nil, error);
            // PPLogFuncInfo(@"parse requestUrl error:%@", error);
        }
        response = nil;
        return;
    }
    
    if (response)
    {
        // PPLogFuncInfo(@"response:%@", response);

        NSMutableDictionary *params = [SalesforceParamHelper parseQueryString:response];
        NSString *error = params[kSFOAuthError];
        
        if (nil == error)
        {
            // PPLogFuncInfo(@" >>取得帳號資訊");
            // MARK: 取得帳號資訊
            NSError *error = nil;
            NSMutableDictionary *accountInfo = [self accountInfoWithParams:params error:&error];
            
            if(error!=nil)
            {
                if (self.loginCompleteHandler)
                {
                    self.loginCompleteHandler (nil, error);
                }
                return ;
            }
            
            // 取得的帳號資訊加入params
            [params addEntriesFromDictionary:accountInfo];
            
            //////////////////////////////////////////////////

            if (self.loginCompleteHandler)
            {
                self.loginCompleteHandler (params, nil);
            }
            // PPLogFuncInfo(@" <<取得帳號資訊 (%@)",params);
        }
        else
        {
            NSError *finalError;
            NSError *error = [[self class] errorWithType:params[kSFOAuthError]
                                             description:params[kSFOAuthErrorDescription] object:nil];
            
            // add any additional relevant info to the userInfo dictionary
            
            if (kPPSFOAuthErrorInvalidClientId == error.code)
            {
                NSMutableDictionary *dict = [NSMutableDictionary dictionaryWithDictionary:error.userInfo];
                dict[kSFOAuthClientId] = self.clientID;
                finalError = [NSError errorWithDomain:error.domain code:error.code userInfo:dict];
            }
            else
            {
                finalError = error;
            }
            
            if(self.loginCompleteHandler)
            {
                self.loginCompleteHandler(nil, finalError);
            }
            // PPLogFuncOut(@" auth error:%@, finalError:%@", error, finalError);
        }
    }
    // PPLogFuncOut();
}


//==============================================================================
//
//==============================================================================
- (void)handleWebServerResponse:(NSURL *)requestUrl
{
    NSString *response = nil;

    
    NSError *error = [[self class] checkFrontdoorResponseForErrors:requestUrl];

    if(error)
    {
        __block typeof(self) blockSelf = self;
        [error retain];
        dispatch_async(dispatch_get_main_queue(), ^{
            if (blockSelf.loginCompleteHandler)
            {
                blockSelf.loginCompleteHandler (nil, error);
                [error release];
            }
        });
        return ;
    }
    else
    {
        // MARK: 取得Token
        NSError *error = nil;
        response = [requestUrl fragment]?:[requestUrl query];
        
        NSMutableDictionary *params = [SalesforceParamHelper parseQueryString:response];

        NSMutableDictionary *loginToken = nil;
        
        // 如果有實作，由外部取得
        if(self.requestAuthTokenHandler)
        {
            loginToken = self.requestAuthTokenHandler(params[kSFOAuthResponseTypeCode], &error);
        }
        
        // !!如果外部沒有取得token, 用標準流程去取
        if(loginToken==nil)
        {
            loginToken = [self loginTokenWithCode:params[kSFOAuthResponseTypeCode] error:&error];
        }
        
        if(error!=nil)
        {
            __block typeof(self) blockSelf = self;
            [error retain];
            dispatch_async(dispatch_get_main_queue(), ^{
                if (blockSelf.loginCompleteHandler)
                {
                    blockSelf.loginCompleteHandler (nil, error);
                    [error release];
                }
            });
            return ;
        }
        
        
        // MARK: 取得帳號資訊
        NSMutableDictionary *accountInfo = [self accountInfoWithParams:loginToken error:&error];
        
        if(error!=nil)
        {
            __block typeof(self) blockSelf = self;
            [error retain];
            dispatch_async(dispatch_get_main_queue(), ^{
                if (blockSelf.loginCompleteHandler)
                {
                    blockSelf.loginCompleteHandler (nil, error);
                    [error release];
                }
            });
            return ;
        }
        
        // 取得的帳號資訊加入params
        [loginToken addEntriesFromDictionary:accountInfo];
        
        //////////////////////////////////////////////////
        
        __block typeof(self) blockSelf = self;
        [loginToken retain];
        dispatch_async(dispatch_get_main_queue(), ^{
            if (blockSelf.loginCompleteHandler)
            {
                blockSelf.loginCompleteHandler (loginToken, nil);
                [loginToken release];
            }
        });
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - public methods


//==============================================================================
//
//==============================================================================
- (void)setBusy:(NSNumber *)busy
{
#if TARGET_OS_IPHONE
    [self setUserInteractionEnabled:![busy boolValue]];
#endif
    
    if ([busy boolValue]==YES)
    {
        if(self.busyIndicator)
        {
            [self.busyIndicator removeFromSuperview];
            self.busyIndicator = nil;
        }
        
#if TARGET_OS_IPHONE
        self.busyIndicator = [[[PPBusyView alloc] initWithSuperView:self] autorelease];
#else
        CGSize indicatorSize = CGSizeMake(50, 50);
        CGRect indicatorFrame = CGRectMake((self.bounds.size.width-indicatorSize.width)/2,
                                           (self.bounds.size.height-indicatorSize.height)/2,
                                           indicatorSize.width,
                                           indicatorSize.height);
        self.busyIndicator = [[[NSProgressIndicator alloc] initWithFrame:indicatorFrame] autorelease];
        self.busyIndicator.style = NSProgressIndicatorSpinningStyle;
        [self addSubview:self.busyIndicator];
        [self.busyIndicator startAnimation:self];
#endif
        
    }
    else
    {
        if(self.busyIndicator)
        {
            [self.busyIndicator removeFromSuperview];
            self.busyIndicator = nil;
        }
        
    }
}



//==============================================================================
//
//==============================================================================
- (void)showOAuthViewWithCompleteHandler:(PPSFLoginCompleteHandler)completeHandler;
{
//    [self setBusy:@(YES)];
//    
    self.loginCompleteHandler = completeHandler;
    
    [self reloadOrigin];
}


//==============================================================================
//
//==============================================================================
- (void)reloadOrigin
{
    __block typeof(self) blockSelf = self;
    dispatch_async(dispatch_get_main_queue(), ^{
        [blockSelf loadURL:[self oauthConnectionURL] withCookie:NO];
    });
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WKNavigationDelegate (User-Agent Token Flow)


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView decidePolicyForNavigationAction:(WKNavigationAction *)navigationAction decisionHandler:(void (^)(WKNavigationActionPolicy))decisionHandler
{
#ifdef SHOWLOG
    NSLog(@"%s - %@", __PRETTY_FUNCTION__, navigationAction);
#endif
    // PPLogFuncIn(@" %@", navigationAction.request.URL);

    // !! salesforce忘記密碼要這樣處理，才會有畫面
    if (navigationAction.navigationType==WKNavigationTypeLinkActivated)
    {
        decisionHandler(WKNavigationActionPolicyCancel);
        [self loadRequest:navigationAction.request];
        // PPLogFuncOut(@" salesforce忘記密碼");
        return ;
    }
    
    //////////////////////////////////////////////////
    NSURL *url = navigationAction.request.URL;
    
    NSString *requestUrl = [url absoluteString];
    
    if ([self isRedirectURL:requestUrl])
    {
        // 先call decisionHandler, 再做後面的動作，不然如果handleUserAgentResponse進到結束流程，這邊會當掉
        decisionHandler(WKNavigationActionPolicyCancel);
        __block typeof(self) blockSelf = self;
        
        // 通知外部開始進行登入流程處理
        if(self.sendLoginActionHandler!=nil)
        {
            self.sendLoginActionHandler();
        }
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            
#ifdef USE_USER_AGENT_FLOW
            [blockSelf handleUserAgentResponse:url];
#else
            [blockSelf handleWebServerResponse:url];
#endif
        });

        // PPLogFuncOut();
        return ;
    }
    decisionHandler(WKNavigationActionPolicyAllow);
    // PPLogFuncOut();
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView decidePolicyForNavigationResponse:(WKNavigationResponse *)navigationResponse decisionHandler:(void (^)(WKNavigationResponsePolicy))decisionHandler
{
#ifdef SHOWLOG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
    // PPLogFuncIn(@" - %@", navigationResponse);
    decisionHandler(WKNavigationResponsePolicyAllow);
    // PPLogFuncOut();
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didStartProvisionalNavigation:(WKNavigation *)navigation
{
    // PPLogFuncIn(@" - %@", navigation);
    [self setBusy:@(YES)];
    
#ifdef SHOWLOG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
    // PPLogFuncOut();
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didReceiveServerRedirectForProvisionalNavigation:(null_unspecified WKNavigation *)navigation
{
    // PPLogFuncIn(@" - %@", navigation);
#ifdef SHOWLOG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
    // PPLogFuncOut();
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didFailProvisionalNavigation:(WKNavigation *)navigation withError:(NSError *)error
{
    // PPLogFuncIn(@" - %@", navigation);
#ifdef SHOWLOG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
    
    if ([error.domain isEqualToString:NSURLErrorDomain] && error.code == NSURLErrorCancelled)
    {
        // NSURLErrorCancelled is reported when a page has a redirect OR if you load
        // a new URL in the WebView before the previous one came back. We can just
        // ignore these since they aren't real errors.
        // http://stackoverflow.com/questions/1024748/how-do-i-fix-nsurlerrordomain-error-999-in-iphone-3-0-os
        // PPLogFuncOut(@"canceled");
        return;
    }
    
    if(self.loginCompleteHandler)
    {
        self.loginCompleteHandler(nil, error);
    }
    // PPLogFuncOut(@" (%@)", error);
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didCommitNavigation:(null_unspecified WKNavigation *)navigation
{
    // PPLogFuncIn(@" - %@", navigation);
#ifdef SHOWLOG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
    // PPLogFuncOut();
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didFinishNavigation:(WKNavigation *)navigation
{
    // PPLogFuncIn(@" - %@", navigation);
#ifdef SHOWLOG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
    [self setBusy:@(NO)];
    
    // PPLogFuncOut();
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didFailNavigation:(WKNavigation *)navigation withError:(NSError *)error
{
    // PPLogFuncIn(@" - %@", navigation);
#ifdef SHOWLOG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
    
    [self setBusy:@(NO)];
    if ([error.domain isEqualToString:NSURLErrorDomain] && error.code == NSURLErrorCancelled)
    {
        // NSURLErrorCancelled is reported when a page has a redirect OR if you load
        // a new URL in the WebView before the previous one came back. We can just
        // ignore these since they aren't real errors.
        // http://stackoverflow.com/questions/1024748/how-do-i-fix-nsurlerrordomain-error-999-in-iphone-3-0-os
        // PPLogFuncOut(@" canceled");
        return;
    }
    
    if(self.loginCompleteHandler)
    {
        self.loginCompleteHandler(nil, error);
    }
    // PPLogFuncOut(@" (%@)", error);
}


//==============================================================================
//
//==============================================================================
//- (void)webView:(WKWebView *)webView didReceiveAuthenticationChallenge:(NSURLAuthenticationChallenge *)challenge completionHandler:(void (^)(NSURLSessionAuthChallengeDisposition disposition, NSURLCredential * _Nullable credential))completionHandler
//{
//#ifdef SHOWLOG
//    NSLog(@"%s", __PRETTY_FUNCTION__);
//#endif
//    
//    completionHandler(NSURLSessionAuthChallengePerformDefaultHandling, nil);
//}


//==============================================================================
//
//==============================================================================
- (void)webViewWebContentProcessDidTerminate:(WKWebView *)webView
{
    // PPLogFuncIn();
#ifdef SHOWLOG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
    // PPLogFuncOut();
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Utilities
+ (NSError *)checkFrontdoorResponseForErrors:(NSURL *)requestUrl
{
    NSError *error = nil;
    NSString *ecValue = [requestUrl valueForParameterName:kSFECParameter];
    BOOL foundValidEcValue = ([ecValue isEqualToString:@"301"] || [ecValue isEqualToString:@"302"]);
    NSString *errorCode = [requestUrl valueForParameterName:kSFOAuthError];
    NSString *errorDescription = [requestUrl valueForParameterName:kSFOAuthErrorDescription];
    if (foundValidEcValue) {
        error = [[self class] errorWithType:kPPSFOAuthErrorTypeMalformedResponse description:@"IDP Authcode redirect response encountered an ec=301 or 302 redirect" object:nil];
    } else if (errorCode) {
        error = [[self class] errorWithType:errorCode
                                description:errorDescription object:nil];
    } else if (![requestUrl fragment] && ![requestUrl query]){
        error = [[self class] errorWithType:kPPSFOAuthErrorTypeMalformedResponse description:@"IDP Authcode redirect response has no payload" object:nil];
    }
    return error;
}

//==============================================================================
//
//==============================================================================
+ (NSError *)errorWithType:(NSString *)type description:(NSString *)description object:(id)object
{
    NSAssert(type, @"error type can't be nil");
    
    NSInteger code = kPPSFOAuthErrorUnknown;
    if ([type isEqualToString:kPPSFOAuthErrorTypeAccessDenied]) {
        code = kPPSFOAuthErrorAccessDenied;
    } else if ([type isEqualToString:kPPSFOAuthErrorTypeMalformedResponse]) {
        code = kPPSFOAuthErrorMalformed;
    } else if ([type isEqualToString:kPPSFOAuthErrorTypeInvalidClientId]) {
        code = kPPSFOAuthErrorInvalidClientId;
    } else if ([type isEqualToString:kPPSFOAuthErrorTypeInvalidClient]) {
        code = kPPSFOAuthErrorInvalidClientCredentials;
    } else if ([type isEqualToString:kPPSFOAuthErrorTypeInvalidClientCredentials]) {
        code = kPPSFOAuthErrorInvalidClientCredentials;
    } else if ([type isEqualToString:kPPSFOAuthErrorTypeInvalidGrant]) {
        code = kPPSFOAuthErrorInvalidGrant;
    } else if ([type isEqualToString:kPPSFOAuthErrorTypeInvalidRequest]) {
        code = kPPSFOAuthErrorInvalidRequest;
    } else if ([type isEqualToString:kPPSFOAuthErrorTypeInactiveUser]) {
        code = kPPSFOAuthErrorInactiveUser;
    }  else if ([type isEqualToString:kPPSFOAuthErrorTypeInactiveOrg]) {
        code = kPPSFOAuthErrorInactiveOrg;
    }  else if ([type isEqualToString:kPPSFOAuthErrorTypeRateLimitExceeded]) {
        code = kPPSFOAuthErrorRateLimitExceeded;
    }  else if ([type isEqualToString:kPPSFOAuthErrorTypeUnsupportedResponseType]) {
        code = kPPSFOAuthErrorUnsupportedResponseType;
    } else if ([type isEqualToString:kPPSFOAuthErrorTypeTimeout]) {
        code = kPPSFOAuthErrorTimeout;
    } else if ([type isEqualToString:kPPSFOAuthErrorTypeWrongVersion]) {
        code = kPPSFOAuthErrorWrongVersion;
    } else if ([type isEqualToString:kPPSFOAuthErrorTypeBrowserLaunchFailed]) {
        code = kPPSFOAuthErrorBrowserLaunchFailed;
    } else if ([type isEqualToString:kPPSFOAuthErrorTypeUnknownAdvancedAuthConfig]) {
        code = kPPSFOAuthErrorUnknownAdvancedAuthConfig;
    } else if ([type isEqualToString:kPPSFOAuthErrorTypeJWTLaunchFailed]) {
        code = kPPSFOAuthErrorJWTInvalidGrant;
    } else if ([type isEqualToString:kPPSFOAuthErrorTypeFetchUserInfoFailed]) {
        code = kPPSFOAuthErrorFetchUserAccountFailed;
    }

    
    NSMutableDictionary *dict = [NSMutableDictionary dictionaryWithDictionary:@{kSFOAuthError: type,
                                                                                NSLocalizedDescriptionKey: description}];
    if(object)
    {
        // NSErrorCustom_Key_Object from NSError+Custom
        [dict setObject:object forKey:@"NSErrorCustom_Key_Object"];
    }
    NSError *error = [NSError errorWithDomain:kPPSFOAuthErrorDomain code:code userInfo:dict];
    return error;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Deprecated


//==============================================================================
// 改用identifier url, 所以用不到了
//==============================================================================
- (NSMutableString *)userInfoConnectionURLWithAccessToken:(NSString *)accessToken
{
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    // E.g. https://login.salesforce.com/services/oauth2/userinfo?access_token=<accessToken>&format=json
    
    NSMutableString *oauthConnectionURL =  [[NSMutableString alloc] initWithFormat:@"%@://%@%@?%@=%@&%@=%@",
                                            OAuthProtocol, OAuthBaseURL, kSFOAuthEndPointUserInfo,
                                            kSFOAuthAccessToken, accessToken,
                                            kSFOAuthFormat, kSFOAuthFormatJSON];
    
    
    return [oauthConnectionURL autorelease];
}

@end

