//
//  PPRestObject.h
//  
//
//  Created by Mike on 13/7/19.
//  Copyright (c) 2013年 penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "RestKit.h"
#import "RKObjectMappingOperationDataSource.h"

@interface PPRestObject : NSObject<NSCopying>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (id)initWithJsonString:(NSString *)jsonString error:(NSError **)error;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (NSString *)jsonStringWithError:(NSError **)error;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Intended For Subclasses Method

/**
 * Restkit request mappings.
 *
 * @return RestKit request mappings.
 */
+ (RKObjectMapping *)requestMapping;

/**
 * Restkit response mappings.
 * mapping:{@"json defined string":@"propertyName"}
 * @return RestKit response mappings.
 */
+ (RKObjectMapping *)responseMapping;

@end
