//
//  PromotionViewController.m
//  Worldictionary
//
//  Created by sanhue cheng on 13/3/26.
//
//

#import "PPPromotionViewController.h"
#import "PPWebView.h"
#import "PPNavigationBarView.h"
#import "PPButton.h"
#import "PPSupportController.h"
#import "UIViewController+ShareApplication.h"
#import "PPNavigationController.h"

#define PromotionViewController_ButtonHeight 40

@interface PPPromotionViewController ()
@property (nonatomic, retain) PPWebView *ppWebView;
@property (nonatomic, retain) PPBarView *ppToolbar;
@property (nonatomic, retain) PPButton *ppButtonRemind;
@property (nonatomic, retain) PPButton *ppButtonClose;
@property (nonatomic, retain) NSArray *layoutConstraints;

@property (nonatomic, retain) NSURL *promotionURL;
@property (nonatomic, copy) PromotionCompletionHandler handler;

@property (nonatomic, assign) NSUInteger buttonID;
@property (nonatomic, assign) BOOL openLinkOutOfApp;
@end

@implementation PPPromotionViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - init/dealloc


//==============================================================================
//
//==============================================================================
- (id)initWithURL:(NSURL*)url completion:(PromotionCompletionHandler)completion
{
    self = [super init];
    if (self)
    {
        [[NSURLCache sharedURLCache] removeAllCachedResponses];

        self.promotionStyle     = PromotionStyle_Remind;
        
        self.handler = completion;
        self.promotionURL = url;
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.layoutConstraints = nil;
    

    [self.ppWebView removeFromSuperview];
    self.ppWebView = nil;

    self.navigationItem.leftBarButtonItem = nil;

    [self.ppToolbar removeFromSuperview];
    self.ppToolbar = nil;
    
    self.ppButtonClose = nil;
    self.ppButtonRemind = nil;
    
    self.handler = nil;
    self.promotionURL = nil;
    
    [super dealloc];
}

/////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - view life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];

    //////////////////////////////////////////////////
    // 建立按鍵
    if(self.ppButtonClose==nil)
    {
        self.ppButtonClose = [[[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect] autorelease];
    }
    if(self.ppButtonClose)
    {
        self.ppButtonClose.delegate      = self;
        self.ppButtonClose.tag           = PPPromotionButtonID_Close;
        [self.ppButtonClose addControlEvents:UIControlEventTouchUpInside];
        [self.ppButtonClose setBackgroundImageWithName:ImageNamePPButtonBackgroundForNavigationBar];
        [self.ppButtonClose setTitle:NSLocalizedStringFromTable(@"MLS_Close", NSStringFromClass(self.class), nil)  maxWidth:0];
    }
    
    
    if(self.promotionStyle==PromotionStyle_Remind)
    {
        if(self.ppButtonRemind==nil)
        {
            self.ppButtonRemind = [[[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect] autorelease];
        }
        if(self.ppButtonRemind)
        {
            self.ppButtonRemind.delegate      = self;
            self.ppButtonRemind.tag           = PPPromotionButtonID_Remind;
            [self.ppButtonRemind addControlEvents:UIControlEventTouchUpInside];
            [self.ppButtonRemind setBackgroundImageWithName:ImageNamePPButtonBackgroundForNavigationBar];
            [self.ppButtonRemind setTitle:NSLocalizedStringFromTable(@"MLS_RemindLater", NSStringFromClass(self.class), nil) maxWidth:0];
        }
    }

    //////////////////////////////////////////////////
    // 建立toolbar
    if(self.navigationController.navigationBar==nil)
    {
        if(self.ppToolbar==nil)
        {
            self.ppToolbar = [[[PPBarView alloc] init] autorelease];
        }
        [self.ppToolbar setTranslatesAutoresizingMaskIntoConstraints:NO];
        self.ppToolbar.backgroundImageView.image = [UIImage imageWithName:ImageNamePPBarViewBackgroundForNavigationBar];
        self.ppToolbar.style = PPBarViewStyle_Average;

        [self.view addSubview:self.ppToolbar];
    
        // 加入按鍵
        if(self.promotionStyle==PromotionStyle_Remind)
        {
            [self.ppToolbar setViews:@[self.ppButtonClose, self.ppButtonRemind] forBlockType:PPBarViewBlockType_Center];
        }
        else
        {
            [self.ppToolbar setViews:@[self.ppButtonClose] forBlockType:PPBarViewBlockType_Center];
        }

    }
    else
    {
        //建立toolbar
        if(self.ppToolbar==nil)
        {
            self.ppToolbar = [[[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds] autorelease];
        }
        self.ppToolbar.style = PPBarViewStyle_CenteredAbsolute;
        
        // 加入按鍵
        [self.ppToolbar setViews:@[self.ppButtonClose] forBlockType:PPBarViewBlockType_Left];
        
        if(self.promotionStyle==PromotionStyle_Remind)
        {
            [self.ppToolbar setViews:@[self.ppButtonRemind] forBlockType:PPBarViewBlockType_Right];
        }
        
        if(self.navigationController!=nil)
        {
            UIBarButtonItem *leftBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:self.ppToolbar];
            if(leftBarButtonItem!=nil)
            {
                self.navigationItem.leftBarButtonItem = leftBarButtonItem;
                [leftBarButtonItem release];
            }
        }
    }
    
    
    //////////////////////////////////////////////////
    //建立webview
    if(self.ppWebView==nil)
    {
        self.ppWebView = [[[PPWebView alloc] initWithFrame:CGRectZero] autorelease];
    }
    
    if (self.ppWebView)
    {
        [self.ppWebView setTranslatesAutoresizingMaskIntoConstraints:NO];
        self.ppWebView.openLinkInNewWindow = self.openLinkOutOfApp;
        
        if(self.promotionURL!=nil)
        {
            NSURLRequest * request = [[NSURLRequest alloc] initWithURL:self.promotionURL
                                                           cachePolicy:NSURLRequestReloadIgnoringCacheData
                                                       timeoutInterval:60];
            [self.ppWebView loadRequest:request];
            [request release];
        }
        [self.view addSubview:self.ppWebView];
    }
    
    [self.view setNeedsUpdateConstraints];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];


}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    /////////////////////////////////////////////////////////////////////////////////////////
    
    self.navigationItem.leftBarButtonItem = nil;
    
    [self.ppToolbar removeFromSuperview];
    self.ppToolbar = nil;
    
    self.ppButtonClose = nil;
    self.ppButtonRemind = nil;
    
    [self.ppWebView removeFromSuperview];
    self.ppWebView = nil;

    if(self.handler!=nil)
    {
        self.handler(self.buttonID);
    }
    
    /////////////////////////////////////////////////////////////////////////////////////////
    [super viewDidDisappear:animated];
    
}


//==============================================================================
//
//==============================================================================
- (void)viewSafeAreaInsetsDidChange
{
    [super viewSafeAreaInsetsDidChange];
    
    //////////////////////////////////////////////////
    [self resetLayoutConstraints];
}


//==============================================================================
//
//==============================================================================
- (void)updateViewConstraints
{
    [super updateViewConstraints];
    
    //////////////////////////////////////////////////
    [self resetLayoutConstraints];
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - layout constraints


//==============================================================================
//
//==============================================================================
- (void)resetLayoutConstraints
{
    if(self.ppToolbar==nil ||
       self.ppWebView==nil)
    {        
        return;
    }
    
    [self removeLayoutConstraints];
    
    //////////////////////////////////////////////////
    NSDictionary *views = @{@"ppToolBar":self.ppToolbar,
                            @"ppWebView":self.ppWebView,
                            @"topLayoutGuide":self.topLayoutGuide,
    };
    
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    
    if (self.navigationController==nil)
    {
        NSInteger toolBarHeight = PPBarViewDefaultHeightForNavigationBarNormal;
        
        if(@available(iOS 11, *))
        {
            self.ppToolbar.addtionBlockEdgeInsets = UIEdgeInsetsMake(0, 0, self.view.safeAreaInsets.bottom, 0);
            toolBarHeight += self.view.safeAreaInsets.bottom;
        }
        
        NSDictionary *metrics = @{@"ToolBarHeight":@(toolBarHeight)};
        

        [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[ppWebView]|"
                                                                                       options:NSLayoutFormatDirectionLeftToRight
                                                                                       metrics:metrics
                                                                                         views:views]];
        [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[ppToolBar]|"
                                                                                       options:NSLayoutFormatDirectionLeftToRight
                                                                                       metrics:metrics
                                                                                         views:views]];

        [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[topLayoutGuide][ppWebView][ppToolBar(ToolBarHeight)]|"
                                                                                       options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                       metrics:metrics
                                                                                         views:views]];
    }
    else
    {
        NSDictionary *metrics = nil;
        
        [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[ppWebView]|"
                                                                                       options:NSLayoutFormatDirectionLeftToRight
                                                                                       metrics:metrics
                                                                                         views:views]];
        [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[ppWebView]|"
                                                                                       options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                       metrics:metrics
                                                                                         views:views]];
    }

    
    //////////////////////////////////////////////////
    if ([layoutConstraints count])
    {
        self.layoutConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.view addConstraints:self.layoutConstraints];
        [self.view layoutIfNeeded];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeLayoutConstraints
{
    if (self.layoutConstraints)
    {
        [self.view removeConstraints:self.layoutConstraints];
        self.layoutConstraints = nil;
    }
}


////////////////////////////////////////////////////////////////////////////////////////////////////
// layout for ios7


//==============================================================================
//
//==============================================================================
//- (void)layoutSubviews
//{
//    [super layoutSubviews];
//
//    ////////////////////////////////////////////////////////////////////////////////////////
//
//    CGRect layoutFrame = [self layoutFrame];
//
//    NSInteger buttonHeight = PromotionViewController_ButtonHeight;
//    CGRect toolbarViewFrame = CGRectMake(0, 0, layoutFrame.size.width, PPBarViewDefaultHeightForNavigationBarNormal);
//    CGRect webviewFrame = layoutFrame;
//
//
//    if(self.navigationController.navigationBar==nil)
//    {
//        // 沒有navigation bar for iphone
//        ppButtonClose_.frame    = CGRectMake(0, 0, (layoutFrame.size.width)/3, buttonHeight);
//        ppButtonRemind_.frame   = CGRectMake(0, 0, (layoutFrame.size.width)/3, buttonHeight);
//
//        webviewFrame.size.height -= PPBarViewDefaultHeightForNavigationBarNormal;
//        toolbarViewFrame.origin.y = webviewFrame.origin.y + webviewFrame.size.height;
//
//        // toolbar 需要設定 frame, navigationBar 不需要
//        ppToolbar_.frame = toolbarViewFrame;
//    }
//
//    ppWebView_.frame = webviewFrame;
//}





/////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    [self goBackAnimated:YES];
    
    self.buttonID = ppButton.tag;
}





/////////////////////////////////////////////////////////////////////////////////////////
#pragma mark -  class methods


//==============================================================================
//
//==============================================================================
+ (NSString *)promotionURLStringWithLicence:(NSString*)licence
{
    NSString *urlString = [NSString stringWithFormat:@"http://mobile.penpower.net/index.asp?%@",[PPSupportController moreAppsURLParamsWithLicense:licence]];
    
    return [urlString stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding];
}


//==============================================================================
//
//==============================================================================
+ (void)showPromotionURL:(NSURL *)promotionURL
      fromViewController:(UIViewController*)viewController
             withLicence:(NSString*)licence
          promotionStyle:(PromotionStyle)style
        openLinkOutOfApp:(BOOL)openLinkOutOfApp
              completion:(PromotionCompletionHandler)completion
{
    if(viewController!=nil)
    {
        PPPromotionViewController * promotionViewController =
        [[PPPromotionViewController alloc] initWithURL:promotionURL completion:completion];
        
        promotionViewController.promotionStyle = style;
        promotionViewController.openLinkOutOfApp = openLinkOutOfApp;
        
        [viewController presentViewController:promotionViewController animated:YES completion:nil];
        [promotionViewController release];
    }
}


//==============================================================================
//
//==============================================================================
+ (void)showPromotionFromViewController:(UIViewController*)viewController
                            withLicence:(NSString*)licence
                         promotionStyle:(PromotionStyle)style
                       openLinkOutOfApp:(BOOL)openLinkOutOfApp
                             completion:(PromotionCompletionHandler)completion
{
    NSString *urlString = [PPPromotionViewController promotionURLStringWithLicence:licence];
    NSURL * promotionURL = [NSURL URLWithString:urlString];
    
    [self showPromotionURL:promotionURL
        fromViewController:viewController
               withLicence:licence
            promotionStyle:style
          openLinkOutOfApp:openLinkOutOfApp
                completion:completion];
}


//==============================================================================
//
//==============================================================================
+ (void)showPromotionFromViewController:(UIViewController*)viewController
                            withLicence:(NSString*)licence
                         promotionStyle:(PromotionStyle)style
                             completion:(PromotionCompletionHandler)completion
{
    [self showPromotionFromViewController:viewController
                              withLicence:licence
                           promotionStyle:style
                         openLinkOutOfApp:NO
                               completion:completion];
}



//==============================================================================
//
//==============================================================================
+ (void)showiPadPromotionURL:(NSURL *)promotionURL
          fromViewController:(UIViewController *)aViewController
                 withLicence:(NSString*)licence
                       style:(PromotionStyle)aStyle
                  viewBounds:(CGRect)viewBounds
            openLinkOutOfApp:(BOOL)openLinkOutOfApp
                  completion:(PromotionCompletionHandler)aCompletionHandler
{
    if(aViewController!=nil)
    {
        PPPromotionViewController *promotionViewController =
        [[PPPromotionViewController alloc] initWithURL:promotionURL completion:aCompletionHandler];
        
        promotionViewController.promotionStyle = aStyle;
        promotionViewController.openLinkOutOfApp = openLinkOutOfApp;
        
        PPNavigationController *navigationController =
        [[PPNavigationController alloc] initWithRootViewController:promotionViewController];
        
        navigationController.modalPresentationStyle = UIModalPresentationFormSheet;
        navigationController.modalTransitionStyle = UIModalTransitionStyleCrossDissolve;
        navigationController.navigationBar.barStyle = [UINavigationBar appearance].barStyle;
        
        if ([navigationController respondsToSelector:@selector(preferredContentSize)])
        {
            navigationController.preferredContentSize =  CGSizeMake(viewBounds.size.width, viewBounds.size.height-navigationController.navigationBar.frame.size.height) ;
        }
        
        [aViewController presentViewController:navigationController animated:YES completion:nil];
        
        navigationController.view.superview.bounds = viewBounds;
        
        [promotionViewController release];
        [navigationController release];
    }
}



//==============================================================================
//
//==============================================================================
+ (void)showiPadPromotionFromViewController:(UIViewController *)aViewController
                                withLicence:(NSString*)licence
                                      style:(PromotionStyle)aStyle
                                 viewBounds:(CGRect)viewBounds
                           openLinkOutOfApp:(BOOL)openLinkOutOfApp
                                 completion:(PromotionCompletionHandler)aCompletionHandler
{
    NSString *urlString = [PPPromotionViewController promotionURLStringWithLicence:licence];
    NSURL * promotionURL = [NSURL URLWithString:urlString];
    
    [self showiPadPromotionURL:promotionURL
            fromViewController:aViewController
                   withLicence:licence
                         style:aStyle
                    viewBounds:viewBounds
              openLinkOutOfApp:openLinkOutOfApp
                    completion:aCompletionHandler];
}


//==============================================================================
//
//==============================================================================
+ (void)showiPadPromotionFromViewController:(UIViewController *)aViewController
                                withLicence:(NSString*)licence
                                      style:(PromotionStyle)aStyle
                                 viewBounds:(CGRect)viewBounds
                                 completion:(PromotionCompletionHandler)aCompletionHandler
{
    [self showiPadPromotionFromViewController:aViewController
                                  withLicence:licence
                                        style:aStyle
                                   viewBounds:viewBounds
                             openLinkOutOfApp:NO
                                   completion:aCompletionHandler];
}

@end
