//
//  PPOperation.m
//  
//
//  Created by Mike on 13/5/13.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPOperation.h"

@interface PPOperation()

@property (atomic,assign) BOOL privateExecuting;
@property (atomic,assign) BOOL privateFinished;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPOperation

@synthesize privateExecuting = _privateExecuting;
@synthesize privateFinished = _privateFinished;
@synthesize privateConcurrent = _privateConcurrent;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
	if((self = [super init]))
	{
        _privateExecuting = NO;
		_privateFinished  = NO;
	}
	
	return self;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (BOOL)isConcurrent
{
    return self.privateConcurrent;
}


//================================================================================
//
//================================================================================
- (BOOL)isExecuting
{
	return self.privateExecuting;
}


//================================================================================
//
//================================================================================
- (BOOL)isFinished
{
	return self.privateFinished;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//================================================================================
//
//================================================================================
- (void)completion
{
	[self setExecuting:NO];
	[self setFinished:YES];
}


//================================================================================
//
//================================================================================
- (void)setExecuting:(BOOL)executing
{
    @synchronized(self)
    {
        [self willChangeValueForKey:@"isExecuting"];
        _privateExecuting = executing;
        [self didChangeValueForKey:@"isExecuting"];
    }

}


//================================================================================
//
//================================================================================
- (void)setFinished:(BOOL)finished
{
    @synchronized(self)
    {
        [self willChangeValueForKey:@"isFinished"];
        _privateFinished = finished;
        [self didChangeValueForKey:@"isFinished"];
    }
}


//================================================================================
//
//================================================================================
- (void)waitWithTimeInterval:(NSTimeInterval)timeInterval
{
    if([[NSThread currentThread] isMainThread])
    {
        @autoreleasepool
        {
            [[NSRunLoop currentRunLoop] runUntilDate:[NSDate dateWithTimeIntervalSinceNow:timeInterval]];
        }
    }
    else
    {
        [NSThread sleepForTimeInterval:timeInterval];
    }
}

@end
