//
//  PPNavigationController.m
//  
//
//  Created by Mike on 13/5/8.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPNavigationController.h"
#import "PPCustomHeightNavigationBar.h"


static NSNumber *PPNavigationController_ModelPresentationStyle = nil;

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation PPNavigationController






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - override init


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    PPNavigationController *navigationController = [super initWithNavigationBarClass:[PPCustomHeightNavigationBar class] toolbarClass:nil];
    
    if(navigationController)
    {        
        if(PPNavigationController_ModelPresentationStyle!=nil)
        {
            navigationController.modalPresentationStyle = (UIModalPresentationStyle)[PPNavigationController_ModelPresentationStyle integerValue];
        }
    }
    
    return navigationController;
}


//==============================================================================
//
//==============================================================================
- (instancetype)initWithRootViewController:(UIViewController *)rootViewController
{
    PPNavigationController *navigationController = [super initWithNavigationBarClass:[PPCustomHeightNavigationBar class] toolbarClass:nil];
    
    if(rootViewController!=nil)
    {
        [navigationController setViewControllers:@[rootViewController]];
    }
    
    if(PPNavigationController_ModelPresentationStyle!=nil)
    {
        navigationController.modalPresentationStyle = (UIModalPresentationStyle)[PPNavigationController_ModelPresentationStyle integerValue];
    }
    
    return navigationController;
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];

    //////////////////////////////////////////////////

    [self customAppearance];
//    [self.view setNeedsUpdateConstraints];
    
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
   [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////

}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}


//================================================================================
//
//================================================================================
- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    //////////////////////////////////////////////////
    if([[[UIDevice currentDevice] systemVersion] floatValue]>=11.0)
    {
        UIBarButtonItem *leftBarButtonItem = [self topViewController].navigationItem.leftBarButtonItem;
        
        if([leftBarButtonItem.customView isKindOfClass:NSClassFromString(@"PPNavigationBarView")]==YES)
        {
            [leftBarButtonItem.customView setFrame:self.navigationBar.bounds];
        }
    }
    // !! 有些畫面在push進來時不會跑到layoutSubviews所以這邊再call一次
//    [self.navigationBar layoutSubviews];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidLayoutSubviews
{
    [super viewDidLayoutSubviews];
    
    //////////////////////////////////////////////////
    // !! 有些畫面在push進來時不會跑到layoutSubviews所以這邊再call一次
    [self.navigationBar layoutSubviews];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Presenting Another View Controller’s Content

//================================================================================
//
//================================================================================
- (BOOL)disablesAutomaticKeyboardDismissal  
{  
    if(self.modalPresentationStyle==UIModalPresentationFormSheet) 
    {
        return NO;
    }
    
    return [super disablesAutomaticKeyboardDismissal];  
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Rotation Events

//================================================================================
//
//================================================================================
- (UIInterfaceOrientationMask)supportedInterfaceOrientations
{
    // MARK: Howard, 這邊要注意 visibleViewController 和 topViewController 可能不同，當 visibleViewController dismiss時，應該要回傳的是 topViewController 的方向，目前這寫法在橫式元件退開時，若下面那層是直式元件且被 PPNavigationController 包起來時，方向會異常
//    return [self.visibleViewController supportedInterfaceOrientations];
    
    return [self.topViewController supportedInterfaceOrientations];
}

//================================================================================
//
//================================================================================
- (BOOL)shouldAutorotate
{
    return [self.visibleViewController shouldAutorotate];
}


//================================================================================
//
//================================================================================
-(UIStatusBarStyle)preferredStatusBarStyle
{
    return [[self.viewControllers lastObject] preferredStatusBarStyle];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Override Method

//================================================================================
//
//================================================================================
- (void)customAppearance
{
    // do nothing
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Default appearance method


//==============================================================================
//
//==============================================================================
+ (void)setDefaultModalPresentationStyle:(UIModalPresentationStyle)style
{
    PPNavigationController_ModelPresentationStyle = [@(style) retain];
}


@end
