//
//  PPCustomHeightNavigationBar.m
//  WorldCardMobileEN
//
//  Created by sanhue on 2018/7/30.
//  Copyright © 2018年 penpower. All rights reserved.
//

#import "PPCustomHeightNavigationBar.h"
////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPCustomHeightNavigationBar





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self)
    {
    }
    return self;
}



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private

//================================================================================
//
//================================================================================
- (BOOL)navigationBarForView:(UIView *)view
{
    BOOL result = NO;
    
    Class class = [view class];
    
    while (class)
    {
        if([NSStringFromClass(class) isEqualToString:@"PPNavigationBarView"]==YES ||
           [NSStringFromClass(class) isEqualToString:@"PPTitleView"]==YES ||
           [NSStringFromClass(class) isEqualToString:@"PPBarView"]==YES)
        {
            result = YES;
            
            break;
        }
        
        class = [class superclass];
        
    };
    
    return result;
}


//================================================================================
//
//================================================================================
- (BOOL)findPPNavigationBarViewWithHierarchicalViews:(NSMutableArray *)hierarchicalViews superView:(UIView *)superView
{
    BOOL result = NO;
    
    for(UIView *subView in superView.subviews)
    {
        //尋找子視圖的途中將模糊視圖隱藏
        if([subView isKindOfClass:[UIVisualEffectView class]]==YES)
        {
            if(self.barTintColor==[UIColor clearColor])
            {
                subView.hidden = YES;
            }
            else
            {
                subView.hidden = !self.translucent;
            }
        }
        // bottom line 1 px hiden
        else if([subView isKindOfClass:[UIImageView class]]==YES &&
                subView.bounds.size.height<=1)
        {
            UIImageView *imageView = (UIImageView *)subView;
        
            subView.hidden = !imageView.image;
        }
        // !! 不管有沒有加入PPNavigationBar都會有 contentView，所以要強制加入
        else if([NSStringFromClass([subView class]) containsString:@"UINavigationBarContentView"])
        {
            [hierarchicalViews addObject:subView];
        }
        //////////////////////////////////////////////////
        
        if([self navigationBarForView:subView]==YES)
        {
            [hierarchicalViews addObject:subView];
            
            result = YES;
            break;
        }
        else
        {
            [hierarchicalViews addObject:subView];
            
            result = [self findPPNavigationBarViewWithHierarchicalViews:hierarchicalViews superView:subView];
            
            if(result==YES)
            {
                break;
            }
            // not found
            [hierarchicalViews removeLastObject];
        }
    }
    
    return result;
}


//==============================================================================
//
//==============================================================================
- (UIView *)hitTest:(CGPoint)point withEvent:(UIEvent *)event
{
    UIView *hitView = [super hitTest:point withEvent:event];
    return hitView;
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - override


//==============================================================================
// 
//==============================================================================
//- (void)setFrame:(CGRect)frame
//{
//    CGFloat customHeight = [self customHeight];
//
//    if ([UIApplication sharedApplication].isStatusBarHidden==NO)
//    {
//        CGRect statusBarFrame = [[UIApplication sharedApplication] statusBarFrame];
//        frame.origin.y = statusBarFrame.size.height;
//    }
//
//    frame.size.height = customHeight;
//    [super setFrame:frame];
//}

//==============================================================================
//
//==============================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    do
    {
//        CGFloat customHeight = [self customHeight];
//
//        if(customHeight<=0)
//        {
//            //!!不指定高度時，如果不針對 subView 做 layout, 整個 View 的 Frame 會錯亂，所以給予最小值 44
//            customHeight = UINavigationBar_MinimumHeight;
//        }

        CGRect navigationBarFrame = self.bounds;
        if(navigationBarFrame.size.width==0)
        {
            navigationBarFrame.size.width = [[self superview] frame].size.width;
            navigationBarFrame.size.height = [[self superview] frame].size.height;

            [self setFrame:navigationBarFrame];
        }

        //////////////////////////////////////////////////
        NSMutableArray <UIView *> *subViews = [NSMutableArray array];
        
        [self findPPNavigationBarViewWithHierarchicalViews:subViews superView:self];
//        NSLog(@"%@", subViews);
        
        for(UIView *subView in subViews)
        {
            // !! 修正UINavigationBarStackView的layout constraints
            if ([NSStringFromClass([subView class]) containsString:@"UINavigationBarContentView"])
            {
                UIView *contentView = subView;
                UIView *stackView = nil;
                for (UIView *contentViewSubView in subView.subviews)
                {
                    if ([NSStringFromClass([contentViewSubView class]) containsString:@"BarStackView"])
                    {
                        stackView = contentViewSubView;
                        break;
                    }
                }
                
                if(stackView)
                {
                    stackView.translatesAutoresizingMaskIntoConstraints = NO;
                    [contentView removeConstraints:contentView.constraints];

                    //////////////////////////////////////////////////
                    NSMutableArray *adjustConstaints = [NSMutableArray array];
                    NSDictionary *metrics = @{@"horzMargin":@(0)};
                    [adjustConstaints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|-(horzMargin)-[subView]-(horzMargin)-|"
                                                                                                  options:NSLayoutFormatDirectionLeftToRight
                                                                                                  metrics:metrics
                                                                                                    views:@{@"subView":stackView}]];
                    [adjustConstaints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[subView]|"
                                                                                                  options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                                  metrics:metrics
                                                                                                    views:@{@"subView":stackView}]];
                    
                    [contentView addConstraints:adjustConstaints];

                }
                
                contentView.frame = self.bounds;
            }
            
            //////////////////////////////////////////////////
            // !! ios 10以下要設定subview的大小
            if ([[[UIDevice currentDevice] systemVersion] floatValue]<11.0)
            {
                subView.frame = self.bounds;
            }
//            NSLog(@"subView: %@", subView);
//            NSLog(@"subView.constraints:%@", subView.constraints);
            
            if ([[[UIDevice currentDevice] systemVersion] floatValue]<13.0)
            {
                if(@available(iOS 11.0, *))
                {
                    subView.directionalLayoutMargins = NSDirectionalEdgeInsetsZero;
                }

                subView.layoutMargins = UIEdgeInsetsZero;
            }
        }
        
//        for (UIView *subview in self.subviews)
//        {
//            if(@available(iOS 11.0, *))
//            {
//                if ([NSStringFromClass([subview class]) containsString:@"UINavigationBarContentView"])
//                {
//                    UIView *contentView = subview;
//                    for (UIView *contentViewSubView in contentView.subviews)
//                    {
//                        // 高度置中
//                        CGRect subviewFrame = contentViewSubView.frame;
//                        subviewFrame.origin.y = (customHeight-subviewFrame.size.height)/2;
//                        contentViewSubView.frame = subviewFrame;
//                        [contentViewSubView layoutSubviews];
//                    }
//                }
//            }
//            else
//            {
//                if ([NSStringFromClass([subview class]) containsString:@"UINavigationItem"]==YES||
//                    [NSStringFromClass([subview class]) containsString:@"IndicatorView"]==YES)
//                {
//                    // 高度置中
//                    CGRect subviewFrame = subview.frame;
//                    subviewFrame.origin.y = (customHeight-subviewFrame.size.height)/2;
//                    subview.frame = subviewFrame;
//                    [subview layoutSubviews];
//                }
//            }
//        }
        
        //////////////////////////////////////////////
        
        //       UIBackground
        UIView *backgroundView = [self.subviews firstObject];
        
        CGRect backgroundFrame = backgroundView.frame;
        
        CGRect statusBarFrame = [[UIApplication sharedApplication] statusBarFrame];
        
        backgroundFrame.origin.y = -statusBarFrame.size.height;
        backgroundFrame.size.height = statusBarFrame.size.height+self.bounds.size.height;//+customHeight;
        backgroundFrame.size.width = self.bounds.size.width;
        backgroundView.frame = backgroundFrame;
        
        ////////////////////////////////////////////////

        if(self.translucent==NO)
        {
            backgroundView.backgroundColor = self.barTintColor;
        }
    }
    while (0);
    
}


@end
