//
//  PPMemTool.c
//


#import <stdio.h>
#import <stdlib.h>
#import <mach/mach.h>
#import <mach/mach_host.h>
#import <mach/mach_time.h>
#import <sys/sysctl.h>
#import <unistd.h>


//================================================================================
//
//================================================================================
extern unsigned int PPMT_GetFreeMemorySize()
{
    mach_port_t host_port;
    mach_msg_type_number_t host_size;
    vm_size_t pagesize;
    
    host_port = mach_host_self();
    host_size = sizeof(vm_statistics_data_t) / sizeof(integer_t);
    host_page_size(host_port, &pagesize);        
	
    vm_statistics_data_t vm_stat;
	
    if (host_statistics(host_port, HOST_VM_INFO, (host_info_t)&vm_stat, &host_size) != KERN_SUCCESS)
        printf("Failed to fetch vm statistics");
	
    // Stats in bytes
//    natural_t mem_used = (vm_stat.active_count +
//                          vm_stat.inactive_count +
//                          vm_stat.wire_count) * pagesize;
//    natural_t mem_free = vm_stat.free_count * pagesize;
//    natural_t mem_total = mem_used + mem_free;
    
	natural_t mem_free = (natural_t)(vm_stat.free_count * pagesize);

//    char msg[1024] = "";
//	sprintf(msg, "used: %.2f free: %.2f total: %.2f\n", (float)mem_used/1024/1024, (float)mem_free/1024/1024, (float)mem_total/1024/1024);
//	printf(msg);
	
	return mem_free;
}


//================================================================================
//
//================================================================================
extern int PPMT_RequestFreeMemory(unsigned int nNeededSize)
{
#ifdef _DUMP_MSG	
	printf("PPMT_RequestFreeMemory begin\n");
#endif	

	unsigned int	sizeBeforeFree = 0;
	unsigned int	sizeAfterFree = 0;
	size_t			freeSize;
	void*			allocMem;
	uint64_t		timeStart;
	uint64_t		timeCheck;

	
	timeStart = mach_absolute_time();	// 記錄動作開始時間
	sizeAfterFree = PPMT_GetFreeMemorySize();

	while(sizeAfterFree < nNeededSize)
	{
		sizeBeforeFree = PPMT_GetFreeMemorySize();		
		freeSize = sizeBeforeFree-2048;
		allocMem = malloc(freeSize);
		bzero(allocMem, freeSize);
		free(allocMem);
		
		sizeAfterFree = PPMT_GetFreeMemorySize();
		timeCheck = mach_absolute_time();
		
#ifdef _DUMP_MSG		
		printf("released:%.2f free:%.2f time:%d\n", (float)(sizeAfterFree-sizeBeforeFree)/1024/1024, (float)(sizeAfterFree)/1024/1024, (int)(timeCheck-timeStart));
#endif		
		
		
		// 時間檢查，避免一直無法釋放造成無窮回圈 (最多執行5秒)
		if(timeCheck-timeStart > 5000000)
			break;
		else usleep(1000); //microseconds
	}
	
#ifdef _DUMP_MSG	
	printf("PPMT_RequestFreeMemory end\n");
#endif	
	
	return (sizeAfterFree >= nNeededSize) ? 1 : 0;
}


//================================================================================
//
//================================================================================
extern int PPMT_GetAllPID()
{		
	int                i;
	int                treesize;
	struct kinfo_proc *pinfo;
	size_t             bufSize = 0;
	int mib[4] = { CTL_KERN, KERN_PROC, KERN_PROC_ALL, 0 };
	
    
	if(sysctl(mib, 4, NULL, &bufSize, NULL, 0) < 0)
    {
		printf("system statistic error -- sysctl failed");
		return FALSE;
	}
	
	//pinfo = (struct kinfo_proc *)xcalloc(1, bufSize);
	pinfo = (struct kinfo_proc *)malloc(bufSize);
	
	if(sysctl(mib, 4, pinfo, &bufSize, NULL, 0))
    {
		printf("system statistic error -- sysctl failed");
		free(pinfo);
		return FALSE;
	}
	
	treesize = (int)(bufSize / sizeof(struct kinfo_proc));
	
	for(i = 0; i < treesize; i++)
	{
		printf("pid:%4d \tname:%s\n", pinfo[i].kp_proc.p_pid, pinfo[i].kp_proc.p_comm);
	}
	
	free(pinfo);
	return 0;
}
