//
//  PPMakeVirtualCardController.h
//
//  Created by Howard.Lin on 14/1/17.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "CrossPlatformDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPMakeVirtualCardControllerMainType)
{
    PPMakeVirtualCardControllerMainType_Name,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPMakeVirtualCardControllerSubType)
{
    PPMakeVirtualCardControllerSubType_Address_Work,
    PPMakeVirtualCardControllerSubType_Address_Home,
    PPMakeVirtualCardControllerSubType_Address_Other,
    
    PPMakeVirtualCardControllerSubType_Company_Department,
    PPMakeVirtualCardControllerSubType_Company_JobTitle,
    PPMakeVirtualCardControllerSubType_Company_Name,
    
    PPMakeVirtualCardControllerSubType_Email_Work,
    PPMakeVirtualCardControllerSubType_Email_Home,
    PPMakeVirtualCardControllerSubType_Email_Other,
    
    PPMakeVirtualCardControllerSubType_Phone_Mobile,
    PPMakeVirtualCardControllerSubType_Phone_iPhone,
    PPMakeVirtualCardControllerSubType_Phone_Work,
    PPMakeVirtualCardControllerSubType_Phone_Main,
    PPMakeVirtualCardControllerSubType_Phone_Home,
    PPMakeVirtualCardControllerSubType_Phone_Other,
    PPMakeVirtualCardControllerSubType_Phone_WorkFax,
    PPMakeVirtualCardControllerSubType_Phone_HomeFax,

    PPMakeVirtualCardControllerSubType_URL_HomePage,
    PPMakeVirtualCardControllerSubType_URL_Work,
    PPMakeVirtualCardControllerSubType_URL_Home,
    PPMakeVirtualCardControllerSubType_URL_Other,

};

////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPMakeVirtualCardController;

@protocol PPMakeVirtualCardControllerDataSource <NSObject>

@optional
 - (NSString *)ppMakeVirtualCardController:(PPMakeVirtualCardController *)ppMakeVirtualCardController
textForPPMakeVirtualCardControllerMainType:(PPMakeVirtualCardControllerMainType)ppMakeVirtualCardControllerMainType;

- (NSString *)ppMakeVirtualCardController:(PPMakeVirtualCardController *)ppMakeVirtualCardController
textForPPMakeVirtualCardControllerSubType:(PPMakeVirtualCardControllerSubType)ppMakeVirtualCardControllerSubType;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPMakeVirtualCardController : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign) id<PPMakeVirtualCardControllerDataSource> dataSource;

@property (nonatomic,retain) CPImage *headImage;

@property (nonatomic,assign) CGFloat red;
@property (nonatomic,assign) CGFloat green;
@property (nonatomic,assign) CGFloat blue;

@property (nonatomic,assign) CGFloat companyFontSize;
@property (nonatomic,assign) CGFloat departmentFontSize;
@property (nonatomic,assign) CGFloat nameFontSize;
@property (nonatomic,assign) CGFloat otherFontSize;

@property (nonatomic,assign) CGRect  companyRect;
@property (nonatomic,assign) CGRect  departmentRect;
@property (nonatomic,assign) CGRect  headImageRect;
@property (nonatomic,assign) CGRect  nameRect;
@property (nonatomic,assign) CGRect  otherRect;
@property (nonatomic,assign) CGRect  underBarRect;
@property (nonatomic,assign) CGSize  virtualCardSize;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 * To return virtualCardImage
 * @return: The virtualCardImage
 */
- (CPImage *)virtualCardImage;

@end
