//
//  PPMailComposeViewController.m
//  
//
//  Created by Mike on 13/5/8.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPMailComposeViewController.h"

static NSMutableDictionary *staticMailComposeStyleDictionary = nil;


NSString * const PPMailComposeStyle_NavigationBarTitleColor       = @"PPMailComposeStyle_NavigationBarTitleColor";
NSString * const PPMailComposeStyle_NavigationBarButtonTitleColor = @"PPMailComposeStyle_NavigationBarButtonTitleColor";


////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation PPMailComposeViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize ppInterfaceOrientationController = ppInterfaceOrientationController_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//==============================================================================
//
//==============================================================================
- (id)init
{
	if((self=[super init]))
	{	
        self.mailComposeDelegate = self;
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
		ppInterfaceOrientationController_ = [[PPInterfaceOrientationController alloc] init];
        
        //////////////////////////////////////////////////
        //  設定style        
        UIColor *titleColor = [staticMailComposeStyleDictionary objectForKey:PPMailComposeStyle_NavigationBarTitleColor];
        if(titleColor)
        {
            [[self navigationBar] setTitleTextAttributes:@{NSForegroundColorAttributeName:titleColor}];
        }
        
        
        UIColor *buttonTitleColor = [staticMailComposeStyleDictionary objectForKey:PPMailComposeStyle_NavigationBarButtonTitleColor];
        if(buttonTitleColor)
        {
            [[self navigationBar] setTintColor:buttonTitleColor];
        }
	}
	
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
	[ppInterfaceOrientationController_ release];
	
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Rotation Events


//==============================================================================
//
//==============================================================================
- (UIInterfaceOrientationMask)supportedInterfaceOrientations
{
    return [self.ppInterfaceOrientationController supportedInterfaceOrientations];
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - MFMailComposeViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (void)mailComposeController:(MFMailComposeViewController *)controller didFinishWithResult:(MFMailComposeResult)result error:(NSError *)error
{
	[controller dismissViewControllerAnimated:YES completion:nil];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - styling methods


//==============================================================================
//
//==============================================================================
+ (void)setNavigationBarTitleColor:(UIColor *)titleColor
                  buttonTitleColor:(UIColor *)buttonTitleColor
{
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        staticMailComposeStyleDictionary = [[NSMutableDictionary alloc] init];
    });
    
    if (titleColor)
    {
        [staticMailComposeStyleDictionary setObject:titleColor forKey:PPMailComposeStyle_NavigationBarTitleColor];
    }
    
    if (buttonTitleColor)
    {
        [staticMailComposeStyleDictionary setObject:buttonTitleColor forKey:PPMailComposeStyle_NavigationBarButtonTitleColor];
    }
}


@end
