//
//
//  AppDelegate.h
//  Example
//
//  Created by sanhue on 2014/12/31.
//  Copyright (c) 2014年 sanhue. All rights reserved.
//
#import <UIKit/UIKit.h>

////////////////////////////////////////////////////////////////////////////////////////////////////
@class PPDigitalPinCodeField;

@protocol PPDigitalPinCodeFieldDelegate <NSObject>

@optional
/**
 * 是否可以插入文字
 *
 * @param pincodeField instance
 * @param text text fo be insert
 * @return BOOL YES: 可以，NO:否
 */
- (BOOL)pincodeField:(PPDigitalPinCodeField *)pincodeField shouldInsertText:(NSString *)text;

/**
 * 是否可以刪除
 * @param pincodeField instance
 * @return BOOL YES: 可以，NO:否
 */
- (BOOL)pincodeFieldShouldDeleteBackward:(PPDigitalPinCodeField *)pincodeField;

@end



////////////////////////////////////////////////////////////////////////////////////////////////////
@protocol PPDigitalPinCodeFieldImageSource <NSObject>

@optional
/**
 * 取得用來客制化輸入字元的圖片，不客制的話可以不用實作
 * @param pincodeField instance
 * @param index 輸入字元的索引
 * @param filled 是否是輸入的狀態
 * @return UIImage 回傳客制的影像
 */
- (UIImage *)pincodeField:(PPDigitalPinCodeField *)pincodeField dotImageAtIndex:(NSInteger)index filled:(BOOL)filled;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface PPDigitalPinCodeField : UIControl <UIKeyInput>

// delegate
@property (nonatomic, assign) id<PPDigitalPinCodeFieldDelegate> delegate;
@property (nonatomic, assign) id<PPDigitalPinCodeFieldImageSource> imageSource;

// get or set pin code
@property (nonatomic, assign) NSString *pincode;

// configurations
/// 最長密碼位數
@property (nonatomic, assign) NSUInteger maximumLength;

/// 鍵盤樣式
@property (nonatomic, assign) UIKeyboardType keyboardType;


/// return contentSize
- (CGSize)contentSize;

@end