//
//  PPLockScreenController.h
//  Pods
//
//  Created by sanhue on 2015/9/21.
//
//

#import <Foundation/Foundation.h>
#import "PPPincodeViewController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
typedef void(^CheckPasswordCompletion)(void);

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface PPLockScreenController : NSObject


/// 顯示locksreen後會call回來
@property (nonatomic, copy) CheckPasswordCompletion checkCompletion;

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - usage methods

/**
 * 設定lock screen參數, 需在application did finish時設定
 * @param storeKeyName 儲存密碼用的key
 * @param secend 進入背景後幾秒才會鎖定，default 0:馬上鎖定
 */
- (void)setStoreKeyName:(NSString *)storeKeyName
          lockDelayTime:(NSInteger)secend;

/**
 * 密碼是否儲存到keychain, default NO
 * @param saveToKeychain YES:存到keychain，app刪除後重裝，密碼還會存在，NO:存在NSUserDefaults
 */
- (void)setSaveToKeychain:(BOOL)saveToKeychain;

/// 如果有設定密碼，立刻鎖定畫面
- (void)lockScreen;

/// 目前lock screen 是否在顯示中
- (BOOL)isLockScreenDisplaying;
////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - touchID methods

/// 設定是否使用touchID
- (void)setUseTouchIDIfPossible:(BOOL)useTouchIDIfPossible;

/// 取得是否開啟使用touchID, default NO
- (BOOL)useTouchIDIfPossible;

/// 回傳是否可使用touchID
- (BOOL)canUseTouchID;

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - password methods

/// 查詢是否設定密碼
- (BOOL)hasSetPassword;

/// 刪除目前設定密碼
- (void)deletePassword;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - presenting viewcontroller methods

/**
 * 顯示介面
 * @param viewController 從哪一個頁面顯示出來
 * @param style 顯示頁面的style
 */
- (void)presentFromSuperViewController:(UIViewController *)viewController withStyle:(PPPincodeViewControllerStyle)style;


//- (void)presentSettingsFlowFromSuperViewController:(UIViewController *)viewController;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Class methods


/// return share instance
+ (PPLockScreenController *)shareInstance;

@end
