//
//  PPKeychainController.m
//  WorldCardMobile
//
//  Created by  Eddie  on 2011/12/19.
//  Fixed   by  Howard on 2013/09/06
//  Copyright (c) 2011年 __MyCompanyName__. All rights reserved.
//

#import "PPKeychainController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPKeychainController()

@interface PPKeychainController()
+ (NSMutableDictionary *)accessDictionaryWithKeyTag:(NSString *)keyTag;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPKeychainController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private  Method


//=============================================================================================================
//
//=============================================================================================================
+ (NSMutableDictionary *)accessGenericPasswordDictionaryWithAccount:(NSString *)account service:(NSString *)service label:(NSString *)label comment:(NSString *)comment
{
    NSMutableDictionary *accessDictionary = nil;
    
    do
    {
        accessDictionary = [[[NSMutableDictionary alloc] init] autorelease];
        if(accessDictionary==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        [accessDictionary setObject:(id)kSecClassGenericPassword
                             forKey:(id)kSecClass];

        if (floor(NSFoundationVersionNumber) > floor(993.00)) { // iOS 7+ (NSFoundationVersionNumber_iOS_6_1)
            [accessDictionary setObject:(__bridge id)kSecAttrSynchronizableAny
                                 forKey:(__bridge __strong id)kSecAttrSynchronizable];
        }

        [accessDictionary setObject:(__bridge id)kSecAttrAccessibleAlwaysThisDeviceOnly
                             forKey:(__bridge __strong id)kSecAttrAccessible];

        
        [accessDictionary setObject:account
                             forKey:(__bridge __strong id)kSecAttrAccount];

        // 帳號
        if(account!=nil)
        {
            [accessDictionary setObject:account
                             forKey:(__bridge __strong id)kSecAttrAccount];
        }
        
        // 位置 !! 沒有傳時強制用bundle id
        if([service length]==0)
        {
            service = [[NSBundle mainBundle] objectForInfoDictionaryKey:@"CFBundleIdentifier"];
        }
        
        [accessDictionary setObject:service
                             forKey:(__bridge __strong id)kSecAttrService];
        
        // 名稱
        if([label length]>0)
        {
            [accessDictionary setObject:label
                                 forKey:(__bridge __strong id)kSecAttrLabel];
        }

        // 註解
        if([comment length]>0)
        {
            [accessDictionary setObject:comment
                                 forKey:(__bridge __strong id)kSecAttrComment];
        }

    }while(0);
    
    return accessDictionary;
}


//=============================================================================================================
//
//=============================================================================================================
+ (NSMutableDictionary *)accessCryptographicDictionaryWithKeyTag:(NSString *)keyTag
{
    NSMutableDictionary *accessDictionary = nil;
    
    do
    {
        accessDictionary = [[[NSMutableDictionary alloc] init] autorelease];
        if(accessDictionary==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
                [accessDictionary setObject:(id)kSecAttrKeyTypeRSA
                                     forKey:(id)kSecAttrKeyType];
        
        [accessDictionary setObject:(id)kSecClassKey
                             forKey:(id)kSecClass];
        
        [accessDictionary setObject:[keyTag dataUsingEncoding:NSUTF8StringEncoding]
                             forKey:(id)kSecAttrApplicationTag];
    }while(0);
    
    return accessDictionary;
}

//=============================================================================================================
//
//=============================================================================================================
+ (NSMutableDictionary *)accessDictionaryWithKeyTag:(NSString *)keyTag
{
    NSMutableDictionary *accessDictionary = nil;
    
#if TARGET_OS_IPHONE
    accessDictionary = [self accessCryptographicDictionaryWithKeyTag:keyTag];
#elif TARGET_OS_MAC
    NSString *bundleDisplayName = [[NSBundle mainBundle] objectForInfoDictionaryKey:@"CFBundleIdentifier"];
    NSString *label = [NSString stringWithFormat:@"%@-%@", bundleDisplayName, keyTag];
    accessDictionary = [self accessGenericPasswordDictionaryWithAccount:keyTag
                                                                service:bundleDisplayName
                                                                  label:label
                                                                comment:nil];
#endif
    return accessDictionary;
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//=============================================================================================================
//
//=============================================================================================================
+ (PPKeychainControllerStatus)addData:(NSData *)data withKeyTag:(NSString *)keyTag
{
    PPKeychainControllerStatus result = PPKeychainControllerStatus_UnknownError;
    
    @autoreleasepool
    {
        do
        {
            NSMutableDictionary *attributeDictionary = [self accessDictionaryWithKeyTag:keyTag];
            if(attributeDictionary==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            // set object for add
            [attributeDictionary setObject:data forKey:(id)kSecValueData];

            //////////////////////////////////////////////////
            
            // start add
            OSStatus status = SecItemAdd((CFDictionaryRef)attributeDictionary, NULL);
            switch(status)
            {
                case noErr:
                {
                    result = PPKeychainControllerStatus_Success;
                    break;
                }
                case errSecItemNotFound:
                {
                    result = PPKeychainControllerStatus_NotFound;
                    break;
                }
                case errSecDuplicateItem:
                {
                    result = [self updateData:data withKeyTag:keyTag];
                    break;
                }
                default:
                {
                    break;
                }
            }
            
        }while(0);
    }
    
	return result;
}


//=============================================================================================================
// data must released after using
//=============================================================================================================
+ (PPKeychainControllerStatus)getData:(NSData **)data withKeyTag:(NSString *)keyTag
{
    PPKeychainControllerStatus result = PPKeychainControllerStatus_UnknownError;
    
    @autoreleasepool
    {
        do
        {
            NSMutableDictionary *attributeDictionary = [self accessDictionaryWithKeyTag:keyTag];
            if(attributeDictionary==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////

            // set object for query
            [attributeDictionary setObject:@(YES)
                                    forKey:(id)kSecReturnData];
            
            //////////////////////////////////////////////////
            
            // start query
            switch(SecItemCopyMatching((CFDictionaryRef)attributeDictionary, (CFTypeRef *)data))
            {
                case noErr:
                {
                    result = (*data!=nil?PPKeychainControllerStatus_Success:PPKeychainControllerStatus_UnknownError);
                    
                    break;
                }
                case errSecItemNotFound:
                {
                    result = PPKeychainControllerStatus_NotFound;
                    break;
                }
                default:
                {
                    break;
                }
            }
            
        }while(0);
    }
    
    //////////////////////////////////////////////////
    
    if(*data!=nil)
    {
    	[*data autorelease];
    }
    
	return result;
}


//=============================================================================================================
//
//=============================================================================================================
+ (PPKeychainControllerStatus)updateData:(NSData *)data withKeyTag:(NSString *)keyTag
{
    PPKeychainControllerStatus result = PPKeychainControllerStatus_UnknownError;
    
    @autoreleasepool
    {
        do
        {
            NSMutableDictionary *attributeDictionary = [self accessDictionaryWithKeyTag:keyTag];
            if(attributeDictionary==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            NSMutableDictionary *updateDictionary = [[[NSMutableDictionary alloc] init] autorelease];
            if(updateDictionary==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            // set object for update
            [updateDictionary setObject:data forKey:(id)kSecValueData];
            
            //////////////////////////////////////////////////
            
            // start update
            switch(SecItemUpdate((CFDictionaryRef)attributeDictionary, (CFDictionaryRef)updateDictionary))
            {
                case noErr:
                {
                    result = PPKeychainControllerStatus_Success;
                    break;
                }
                case errSecItemNotFound:
                {
                    result = PPKeychainControllerStatus_NotFound;
                    break;
                }
                case errSecDuplicateItem:
                default:
                {
                    break;
                }
            }
            
        }while(0);
    }
    
	return result;
}


//=============================================================================================================
//
//=============================================================================================================
+ (PPKeychainControllerStatus)removeKeyTag:(NSString *)keyTag
{
    PPKeychainControllerStatus result = PPKeychainControllerStatus_UnknownError;
    
    @autoreleasepool
    {
        do
        {
            NSMutableDictionary *attributeDictionary = [self accessDictionaryWithKeyTag:keyTag];
            if(attributeDictionary==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            // start add
            switch(SecItemDelete((CFDictionaryRef)attributeDictionary))
            {
                case noErr:
                {
                    result = PPKeychainControllerStatus_Success;
                    break;
                }
                case errSecItemNotFound:
                {
                    result = PPKeychainControllerStatus_NotFound;
                    break;
                }
                default:
                {
                    break;
                }
            }
            
        }while(0);
    }
    
	return result;
}

@end
