//
//  PPInterfaceOrientationController.m
//  
//
//  Created by Mike on 2011/6/14.
//  Copyright 2011年 Penpower. All rights reserved.
//

#import "PPInterfaceOrientationController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static PPInterfaceOrientationControllerMask defaultMaskForiPad      = PPInterfaceOrientationControllerMask_Portrait;
static PPInterfaceOrientationControllerMask defaultMaskForiPhone    = PPInterfaceOrientationControllerMask_All;

static BOOL                                 orientationLock            = NO;
static BOOL                                 defaultOrientationMaskLock = NO;
////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPInterfaceOrientationController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize mask = mask_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (id)init
{	
	if((self = [super init]))
	{
        if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
        {
            mask_ = defaultMaskForiPad;
        }
        else 
        {
            mask_ = defaultMaskForiPhone;
        }
	}
	
	return self;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Rotation Events

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation fromInterfaceOrientation:(UIInterfaceOrientation)fromInterfaceOrientation
{
    BOOL result = NO;
    
    do
    {
        if([self shouldAutorotate]==NO && toInterfaceOrientation!=fromInterfaceOrientation)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        switch(toInterfaceOrientation)
        {
            case UIInterfaceOrientationPortrait:
            {
                if((self.mask&PPInterfaceOrientationControllerMask_Portrait)==PPInterfaceOrientationControllerMask_Portrait)
                {
                    result = YES;
                }
                
                break;
            }
            case UIInterfaceOrientationPortraitUpsideDown:
            {
                if((self.mask&PPInterfaceOrientationControllerMask_PortraitUpsideDown)==PPInterfaceOrientationControllerMask_PortraitUpsideDown)
                {
                    result = YES;
                }
                
                break;
            }
            case UIInterfaceOrientationLandscapeLeft:
            {
                if((self.mask&PPInterfaceOrientationControllerMask_LandscapeLeft)==PPInterfaceOrientationControllerMask_LandscapeLeft)
                {
                    result = YES;
                }
                
                break;
            }
            case UIInterfaceOrientationLandscapeRight:
            {
                if((self.mask&PPInterfaceOrientationControllerMask_LandscapeRight)==PPInterfaceOrientationControllerMask_LandscapeRight) 
                {
                    result = YES;
                }
                
                break;
            }
            default:
            {
                break;
            }
        }
        
    }while(0);
    
    return result;
}

- (BOOL)shouldAutorotate
{
    return ![PPInterfaceOrientationController orientationLock];
}

- (UIInterfaceOrientationMask)supportedInterfaceOrientations
{
    UIInterfaceOrientationMask supportedInterfaceOrientations = 0;
    
    if((self.mask&PPInterfaceOrientationControllerMask_Portrait)==PPInterfaceOrientationControllerMask_Portrait)
    {
        supportedInterfaceOrientations |= UIInterfaceOrientationMaskPortrait;
    }
    
    if((self.mask&PPInterfaceOrientationControllerMask_PortraitUpsideDown)==PPInterfaceOrientationControllerMask_PortraitUpsideDown)
    {
        supportedInterfaceOrientations |= UIInterfaceOrientationMaskPortraitUpsideDown;
    }

    if((self.mask&PPInterfaceOrientationControllerMask_LandscapeLeft)==PPInterfaceOrientationControllerMask_LandscapeLeft)
    {
        supportedInterfaceOrientations |= UIInterfaceOrientationMaskLandscapeLeft;
    }

    if((self.mask&PPInterfaceOrientationControllerMask_LandscapeRight)==PPInterfaceOrientationControllerMask_LandscapeRight)
    {
        supportedInterfaceOrientations |= UIInterfaceOrientationMaskLandscapeRight;
    }
    
    return supportedInterfaceOrientations;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

//========================================================================================
//
//========================================================================================
+ (void)setDefaultMaskForiPad:(PPInterfaceOrientationControllerMask)mask
{
    defaultMaskForiPad = mask;
}


//========================================================================================
//
//========================================================================================
+ (void)setDefaultMaskForiPhone:(PPInterfaceOrientationControllerMask)mask
{
    defaultMaskForiPhone = mask;
}


//========================================================================================
//
//========================================================================================
+ (void)setOrientationLock:(BOOL)lock
{
    orientationLock = lock;
}


//========================================================================================
//
//========================================================================================
+ (BOOL)orientationLock
{
    return orientationLock;
}


//========================================================================================
//
//========================================================================================
+ (void)setDefaultOrientationMaskLock:(BOOL)lock
{
    defaultOrientationMaskLock = lock;
}


//========================================================================================
//
//========================================================================================
+ (BOOL)defaultOrientationMaskLock
{
    return defaultOrientationMaskLock;
}
@end
