//
//  PPHyperLinkLabel.m
//  
//
//  Created by Mike on 13/5/27.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPHyperLinkLabel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPHyperLinkLabel()

@interface PPHyperLinkLabel()

@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation PPHyperLinkLabel

@implementation PPHyperLinkLabel





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Init & Dealloc

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
	if((self=[super initWithFrame:frame]))
	{
		self.userInteractionEnabled = YES;
	}
	
	return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
	[_link release];
	
    //////////////////////////////////////////////////
    
	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to Touch Events

//================================================================================
//
//================================================================================
- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event
{	
    self.highlighted = [self hitTestLinkWithTouches:touches withEvent:event];
    
    //////////////////////////////////////////////////
    
	[super touchesBegan:touches withEvent:event];
}


//================================================================================
//
//================================================================================
- (void)touchesMoved:(NSSet *)touches withEvent:(UIEvent *)event
{
	self.highlighted = [self hitTestLinkWithTouches:touches withEvent:event];
	
    //////////////////////////////////////////////////
    
	[super touchesMoved:touches withEvent:event];
}


//================================================================================
//
//================================================================================
- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event 
{
    if([self hitTestLinkWithTouches:touches withEvent:event]==YES && self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppHyperLinkLabel:action:)]==YES)
    {
        [self.delegate ppHyperLinkLabel:self action:PPHyperLinkLabelAction_TouchUpInside];
    }
    
    self.highlighted = NO;
    
    //////////////////////////////////////////////////
    
    [super touchesEnded:touches withEvent:event];
}


//================================================================================
//
//================================================================================
- (void)touchesCancelled:(NSSet *)touches withEvent:(UIEvent *)event
{
	self.highlighted = NO;
	
    //////////////////////////////////////////////////
    
	[super touchesCancelled:touches withEvent:event];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Drawing and Updating the View

//================================================================================
//
//================================================================================
- (void)drawRect:(CGRect)rect 
{
	[super drawRect:rect];
    
    //////////////////////////////////////////////////
    
	CGContextRef context = UIGraphicsGetCurrentContext();
	
    if(context!=NULL) 
    {
        CGRect textRect = [self textRectForBounds:rect limitedToNumberOfLines:1];
    
        //////////////////////////////////////////////////
        
        if([self isHighlighted]==YES) 
        {
            CGContextSaveGState(context);
            [[[UIColor grayColor] colorWithAlphaComponent:0.5] setFill];
            CGContextFillRect(context, textRect);
            CGContextRestoreGState(context);
        }
        
        //////////////////////////////////////////////////
        
        CGContextSaveGState(context);
        CGContextSetLineWidth(context, 1);
        CGContextBeginPath(context);
        CGContextMoveToPoint(context, textRect.origin.x, textRect.origin.y+textRect.size.height-1);
        CGContextAddLineToPoint(context, textRect.origin.x+textRect.size.width, textRect.origin.y+textRect.size.height-1);
        CGContextStrokePath(context);
        CGContextRestoreGState(context);
        
        //////////////////////////////////////////////////
        
        UIGraphicsEndImageContext();
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Methods

//================================================================================
//
//================================================================================
- (BOOL)hitTestLinkWithTouches:(NSSet *)touches withEvent:(UIEvent *)event
{
    //不允許多點觸控
    if([[event allTouches] count]==1) 
    {
        CGPoint touchPoint      = [[touches anyObject] locationInView:self];
        CGRect  touchLinkRect   = CGRectInset([self textRectForBounds:self.bounds limitedToNumberOfLines:1], 
                                              PPHyperLinkLabelDefaultTouchInset, 
                                              PPHyperLinkLabelDefaultTouchInset);
        
        if(CGRectContainsPoint(touchLinkRect, touchPoint)==TRUE) 
        {
            return YES;
        }
    }
    
    return NO;
}

@end
