//
//  UIView+PPGuideController.m
//
//  Created by eddie on 2015/4/5.
//  Copyright (c) 2015年 eddie. All rights reserved.
//

#import "UIView+PPGuideController.h"
#import <objc/runtime.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

static char * const kPPGuideIndex = "kPPGuideIndex";
static char * const kPPGuideClassName = "kPPGuideClassName";

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation UIView (PPGuideController)

//================================================================================
//
//================================================================================
- (void)setPpGuideIndex:(NSInteger)guideIndex
{
    objc_setAssociatedObject(self, (void *)(kPPGuideIndex), @(guideIndex), OBJC_ASSOCIATION_RETAIN);
}


//================================================================================
//
//================================================================================
- (NSInteger)ppGuideIndex
{
    NSNumber *number = objc_getAssociatedObject(self, (void *)(kPPGuideIndex));
    
    if(number != nil)
    {
        return [number integerValue];
    }
    
    return 0;
}


//================================================================================
//
//================================================================================
- (void)setPpGuideClassName:(NSString *)ppGuideClassName
{
    NSString *preClassName = objc_getAssociatedObject(self, (void *)(kPPGuideClassName));
    
    if(preClassName != nil)
    {
        objc_removeAssociatedObjects(preClassName);
    }
    
    if([ppGuideClassName length] > 0)
    {
        objc_setAssociatedObject(self, (void *)(kPPGuideClassName), ppGuideClassName, OBJC_ASSOCIATION_RETAIN);
    }
}


//================================================================================
//
//================================================================================
- (NSString *)ppGuideClassName
{
    return (NSString *)objc_getAssociatedObject(self, (void *)(kPPGuideClassName));
}


@end
