//
//  OIDAuthState+IncrementalAuthorization.m
//  
//
//  Created by Howard on 2019/4/23.
//

#import "OIDAuthState+IncrementalAuthorization.h"

// Object
#import "OIDAuthorizationRequest.h"
#import "OIDAuthorizationResponse.h"
#import "OIDErrorUtilities.h"
#import "OIDAuthorizationService.h"
#import "OIDTokenResponse.h"

@implementation OIDAuthState (IncrementalAuthorization)

//================================================================================
//
//================================================================================
- (OIDAuthorizationRequest *)incrementalAuthorizationRequestWithScopes:(NSArray<NSString *> *)scopes
                                                  additionalParameters:( NSDictionary<NSString *, NSString *> *)additionalParameters;
{
    OIDAuthorizationRequest *incrementalAuthorizationRequest =
    
    [[[OIDAuthorizationRequest alloc] initWithConfiguration:self.lastAuthorizationResponse.request.configuration
                                                   clientId:self.lastAuthorizationResponse.request.clientID
                                               clientSecret:self.lastAuthorizationResponse.request.clientSecret
                                                     scopes:scopes
                                                redirectURL:self.lastAuthorizationResponse.request.redirectURL
                                               responseType:OIDResponseTypeCode
                                       additionalParameters:additionalParameters] autorelease];
    
    return incrementalAuthorizationRequest;
}


//================================================================================
//
//================================================================================
- (id<OIDExternalUserAgentSession>)
presentIncrementalAuthorizationRequest:(OIDAuthorizationRequest *)incrementalAuthorizationRequest
externalUserAgent:(id<OIDExternalUserAgent>)externalUserAgent
callback:(OIDAuthStateIncrementalAuthorizationCallback)callback
{
    id<OIDExternalUserAgentSession> authFlowSession = nil;
    
    do
    {
        NSString *refreshToken = [self refreshToken];
        
        if (!refreshToken)
        {
            NSError *error =
            [OIDErrorUtilities errorWithCode:OIDErrorCodeIDTokenParsingError-1
                             underlyingError:nil
                                 description:@"No refresh token to use with incremental "
             "authorization."];
           
            callback(NO, error);
            
            break;
        }
        
        //////////////////////////////////////////////////

        // presents the authorization request
        
        authFlowSession = [OIDAuthorizationService presentAuthorizationRequest:incrementalAuthorizationRequest
                                           externalUserAgent:externalUserAgent
                                                    callback:^(OIDAuthorizationResponse *_Nullable authorizationResponse,
                                                               NSError *_Nullable authorizationError)
                           {
                               
                               if (!authorizationResponse)
                               {
                                   callback(NO, authorizationError);
                                   return;
                               }
                                                        
                               //////////////////////////////////////////////////

                               if (![incrementalAuthorizationRequest.responseType isEqualToString:OIDResponseTypeCode])
                               {
                                   
                                   NSError *error =
                                   [OIDErrorUtilities errorWithCode:OIDErrorCodeIDTokenParsingError-1
                                                    underlyingError:nil
                                                        description:@"Incremental authorization requires a code response "
                                    "type"];
                                   
                                   callback(NO, error);
                                   
                                   return;
                               }
                               
                               //////////////////////////////////////////////////
                               
                               NSDictionary* additionalParameters = @{@"existing_grant": refreshToken};
                               
                               OIDTokenRequest *tokenExchangeRequest =
                               [authorizationResponse
                                tokenExchangeRequestWithAdditionalParameters:additionalParameters];
                               
                               //////////////////////////////////////////////////
                               
                               __block typeof(self) blockself = self;
                               
                               [OIDAuthorizationService performTokenRequest:tokenExchangeRequest
                                              originalAuthorizationResponse:authorizationResponse
                                                                   callback:^(OIDTokenResponse *_Nullable tokenResponse,
                                                                              NSError *_Nullable tokenError)
                               {
                                                                       BOOL success = !!tokenResponse;
                   
                                   if (success)
                                   {
                                       [blockself updateWithAuthorizationResponse:authorizationResponse error:nil];
                                       
                                       [blockself updateWithTokenResponse:tokenResponse error:nil];
                                   }
                                   
                                   callback(success, tokenError);
                               }];
                           }];
    }
    while (0);
   
    
   
    return authFlowSession;
}
@end
