//
//  PPFloatingMenuItemViewLabel.m
//
//  Created by eddie on 2015/6/7.
//  Copyright (c) 2015年 Eddie. All rights reserved.
//

#import "PPFloatingMenuItemViewLabel.h"

@implementation PPFloatingMenuItemViewLabel

//================================================================================
//
//================================================================================
- (void)drawTextInRect:(CGRect)rect
{
    [super drawTextInRect:UIEdgeInsetsInsetRect(rect, self.contentInsets)];
}


//================================================================================
// Called by sizeToFit
//================================================================================
- (CGSize)sizeThatFits:(CGSize)size
{
    CGSize newSize = [super sizeThatFits:size];
    
    newSize.width += (self.contentInsets.left + self.contentInsets.right);
    newSize.height += (self.contentInsets.top + self.contentInsets.bottom);
    
   return newSize;
}


//================================================================================
//
//================================================================================
- (CGFloat)adjustsFontWithWidth:(CGFloat)width
{
    CGFloat result = width;
    
    if([self.text length] > 0)
    {
        CGSize textSize = [self.text sizeWithAttributes:@{NSFontAttributeName:self.font}];
        
        if(textSize.width > (width-self.contentInsets.left-self.contentInsets.right))
        {
            // 找出最適合的font大小
            float fontSize = self.font.pointSize;
            UIFont *textFont;
            
            while (fontSize > 0.0)
            {
                fontSize -= 1.0;
                textFont = [UIFont systemFontOfSize:fontSize];
                textSize = [self.text sizeWithAttributes:@{NSFontAttributeName:textFont}];
                
                if(textSize.width <= (width-self.contentInsets.left-self.contentInsets.right))
                {
                    self.font = textFont;
                    result = ceilf(textSize.width+self.contentInsets.left+self.contentInsets.right);
                    break;
                }
            }
        }
    }

    return result;
}


/*
//================================================================================
//
//================================================================================
- (void)setFrame:(CGRect)frame
{
    NSLog(@"%s %@ (%@)", __func__, NSStringFromCGRect(frame), NSStringFromCGRect(self.bounds));
    
    [super setFrame:frame];
}


//================================================================================
//
//================================================================================
- (void)setBounds:(CGRect)bounds
{
    NSLog(@"%s %@ (%@)", __func__, NSStringFromCGRect(bounds), NSStringFromCGRect(self.frame));
    
    [super setBounds:bounds];
}
*/



@end
