//
//  PPCutPhoneNumberController.h
//
//  Created by UserDev3 on 2011/8/25.
//  Fixed   by Howard   on 2013/10/15
//  Copyright 2011年 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "CutPhoneNumber.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#define K_CPNU_InputBufferCount 256
#define K_CPNU_OutputBufferCount 512

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPCutPhoneNumberController : NSObject
{
    
    unsigned short _szInputBuffer[K_CPNU_InputBufferCount];
    unsigned short _szOutputBuffer[K_CPNU_OutputBufferCount];
    unsigned short _szPhoneBuffer[K_CPNU_OutputBufferCount];
    unsigned short _szExtBuffer[K_CPNU_OutputBufferCount];

}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method


-(CutPhoneNumberCountryType)getPhoneFormatTypeFromCountryCode:(NSString *)aCountryCode;

-(NSString *)copyFormattedPhoneNumber:(NSString *)aOriPhoneNumber
                      withCountryCode:(CutPhoneNumberCountryType)aFormatType;

-(NSString *)copyFormattedPhoneNumber:(NSString *)aOriPhoneNumber;

/*
 * 直接帶入ios的countryCode，以及是否要在電話中加上國碼的boolean值
 */
-(NSString *)copyFormattedPhoneNumberWithoutExtension:(NSString *)aOriPhoneNumber
                                      withCountryCode:(CutPhoneNumberCountryType)aFormatType;

-(NSString *)copyFormattedPhoneNumber:(NSString *)aOriPhoneNumber
                      withCountryCode:(NSString *)countryCode isFillWithCountryCode:(BOOL)isFillCountryCode;

@end
