//
//  PPCountryCodeConvert.m
//
//  Created by Bill on 2014/1/7.
//
//  Copyright 2011年 Penpower. All rights reserved.
//


#import "PPCountryCodeConvert.h"
#import "PPSystemInfoController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPCountryCodeConvert ()

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPCountryCodeConvert


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method


//==============================================================================
// MARK: 將系統的國家列表轉換為plist供程式使用，
//==============================================================================
+ (void)generateCN2CC
{
    NSArray *countryCodes = @[@"ad",@"ae",@"af",@"ag",@"al",@"am",@"ao",@"ar",@"at",@"au",@"az",@"ba",@"bb",@"bd",@"be",
                              @"bf",@"bg",@"bh",@"bi",@"bj",@"bm",@"bn",@"bo",@"br",@"bs",@"bt",@"bw",@"by",@"bz",@"ca",
                              @"cd",@"cf",@"cg",@"ch",@"ci",@"cl",@"cm",@"cn",@"co",@"cr",@"cu",@"cv",@"cy",@"cz",@"de",
                              @"dj",@"dk",@"dm",@"do",@"dz",@"ec",@"ee",@"eg",@"er",@"es",@"et",@"fi",@"fj",@"fk",@"fo",
                              @"fr",@"ga",@"gd",@"ge",@"gh",@"gl",@"gm",@"gn",@"gq",@"gr",@"gs",@"gt",@"gw",@"gy",@"hk",
                              @"hn",@"hr",@"ht",@"hu",@"id",@"ie",@"il",@"im",@"in",@"iq",@"ir",@"is",@"it",@"jm",@"jo",
                              @"jp",@"ke",@"kg",@"kh",@"ki",@"km",@"kp",@"kr",@"kw",@"ky",@"kz",@"la",@"lb",@"lc",@"li",
                              @"lk",@"lr",@"ls",@"lt",@"lu",@"lv",@"ly",@"ma",@"mc",@"md",@"me",@"mg",@"mk",@"ml",@"mm",
                              @"mn",@"mo",@"mr",@"mt",@"mu",@"mv",@"mw",@"mx",@"my",@"mz",@"na",@"nc",@"ne",@"ng",@"ni",
                              @"nl",@"no",@"np",@"nr",@"nz",@"om",@"pa",@"pe",@"pf",@"pg",@"ph",@"pk",@"pl",@"pt",@"py",
                              @"qa",@"ro",@"rs",@"ru",@"rw",@"sa",@"sb",@"sc",@"sd",@"se",@"sg",@"sh",@"si",@"sk",@"sl",
                              @"sn",@"so",@"sr",@"st",@"sv",@"sy",@"sz",@"td",@"tg",@"th",@"tj",@"tl",@"tm",@"tn",@"to",
                              @"tr",@"tt",@"tv",@"tw",@"tz",@"ua",@"ug",@"uk",@"us",@"uy",@"uz",@"va",@"vc",@"ve",@"vn",
                              @"vu",@"ws",@"ye",@"za",@"zm",@"zw"];
    
    NSArray *localeIdentifiers = @[@"en",@"zh-Hant",@"ko",@"ja",@"es",@"de",@"pt",@"it",@"zh-Hans",@"nl",
                                   @"fr",@"da",@"fi",@"nb",@"sv",@"ru",@"pl",@"tr",@"uk",@"ar",
                                   @"hr",@"cs",@"el",@"he",@"ro",@"sk",@"th",@"id",@"ms",@"ca",
                                   @"hu",@"vi",@"hi",];
    
    // MARK: !! 手動新增的要加在這邊
    NSDictionary *additionalDict = @{@"捷克共和国":@"cz",
                                     @"捷克共和國":@"cz",
                                     @"厄瓜多爾":@"ec",
                                     @"格瑞納達":@"gd",
                                     @"格林那达":@"gd"};
    
    NSMutableDictionary *fullCountryNameDict = [NSMutableDictionary dictionary];
    
    for (NSString *countryCode in countryCodes)
    {
        for (NSString *localeCode in localeIdentifiers)
        {
            NSLocale *locale = [NSLocale localeWithLocaleIdentifier:localeCode];
            NSString *countryName = [locale displayNameForKey:NSLocaleCountryCode value:countryCode];
            if([countryName lowercaseString])
            {
                [fullCountryNameDict setObject:countryCode forKey:[countryName lowercaseString]];
            }
        }
    }

    [fullCountryNameDict addEntriesFromDictionary:additionalDict];
    
    NSString *path = [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) firstObject];
    [fullCountryNameDict writeToFile:[path stringByAppendingPathComponent:@"CN2CC.plist"] atomically:YES];
}


//================================================================================
//
//================================================================================
+ (NSString *)localizedStringFromPlistWithCountryCode:(NSString *)countryCode languageCode:(NSString *)languageCode
{
    NSString *displayCountryName = nil;
    
    do
    {
        if(languageCode==nil)
        {
            break;
        }
    
        //////////////////////////////////////////////////

        @autoreleasepool
        {
            //------------------------------------------------------
            // 1. Get the map of coutries distinguished by zones.
            //------------------------------------------------------
            NSString *templateName   = [NSString stringWithFormat:@"CountryTemplate_%@", [languageCode lowercaseString]];
            NSString *path           = [[NSBundle mainBundle] pathForResource:templateName ofType:@"plist"];
            NSDictionary *sourceDict = [NSDictionary dictionaryWithContentsOfFile:path];
            
            // 找不到就用英文
            if(!sourceDict)
            {
                NSString *path = [[NSBundle mainBundle] pathForResource:@"CountryTemplate_en" ofType:@"plist"];
                sourceDict = [NSDictionary dictionaryWithContentsOfFile:path];
            }
            
            //////////////////////////////////////////////////
            
            NSDictionary *countryDict = [sourceDict objectForKey:@"Country"];
            NSArray *sortedArray = [[countryDict allKeys] sortedArrayUsingSelector:@selector(localizedCaseInsensitiveCompare:)];
            
            for(id key in sortedArray)
            {
                NSDictionary *countryNameDictionary = [countryDict objectForKey:key];
                
                if(countryNameDictionary!=nil &&
                   countryNameDictionary.count>0)
                {
                    [displayCountryName release];
                    displayCountryName = [[countryNameDictionary objectForKey:countryCode] retain];
                }
                
                //////////////////////////////////////////////////
                
                if(displayCountryName!=nil && displayCountryName.length>0)
                {
                    break;
                }
            }
            // autorelease pool end
        }
    } while (0);

    return displayCountryName?[displayCountryName autorelease]:nil;
}


//===============================================================================
//
//===============================================================================
NSInteger CompareCountryCode(NSString *code1, NSString *code2, void *param)
{
    NSDictionary *countryNameDict = (NSDictionary *)param;
    
    NSString *compare1 = [countryNameDict objectForKey:code1];
    NSString *compare2 = [countryNameDict objectForKey:code2];
    
    return [compare1 localizedCompare:compare2];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - class methods

//===============================================================================
//
//===============================================================================
+ (NSLocale *)copyLocaleFromLanguageCode:(NSString *)langCode
{
    if([langCode length])
    {
        // find localIdentifier by country code
        NSArray *localeArray = [NSLocale availableLocaleIdentifiers];
        NSString *foundLocale = nil;
        NSRange range = [langCode rangeOfString:@"-"];
        
        
        if(range.length)
        {
            langCode = [langCode stringByReplacingOccurrencesOfString:@"-" withString:@"_"];
            
            for(NSString *localeString in localeArray)
            {
                if([[localeString lowercaseString] isEqualToString:[langCode lowercaseString]])
                {
                    foundLocale = localeString;
                    break;
                }
                
                if(foundLocale)
                    break;
            }
        }
        else
        {
            for(NSString *localeString in localeArray)
            {
                NSArray *compArray = [localeString componentsSeparatedByString:@"_"];
                
                for(NSString *comp in compArray)
                {
                    if([[comp lowercaseString] isEqualToString:[langCode lowercaseString]])
                    {
                        foundLocale = localeString;
                        break;
                    }
                }
                
                if(foundLocale)
                    break;
            }
        }
        
        
        
        if(foundLocale)
        {
            //test
            //            NSLog(@"foundLocale : %@", foundLocale);
            
            return [[NSLocale alloc] initWithLocaleIdentifier:foundLocale];
        }
    }
    
    return [[NSLocale currentLocale] retain];
}


//===============================================================================
//
//===============================================================================
+ (NSString *)countryCodeFromLocalizeString:(NSString *)localizeString
{
    NSString *countryCode = nil;
    
    do
    {
        if(localizeString==nil || [localizeString length]<=0)
        {
            return nil;
        }
        
        //////////////////////////////////////////////////
        
        NSString *searchKey = [localizeString lowercaseString];
        NSString *file      = [[NSBundle mainBundle] pathForResource:@"CN2CC" ofType:@"plist"];
        
        //////////////////////////////////////////////////
        
        NSDictionary *mappingDict = [[NSDictionary alloc] initWithContentsOfFile:file];
        
        if(mappingDict==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if ([mappingDict count]>0)
        {
            countryCode = [[mappingDict objectForKey:searchKey] retain];
        }
        
        [mappingDict release];
        
    } while (0);
    
    //////////////////////////////////////////////////
    
    if(countryCode!=nil)
    {
        [countryCode autorelease];
    }
    
    return countryCode;
}


//===============================================================================
//
//===============================================================================
+ (NSString *)localizeStringFromCountryCode:(NSString *)countryCode
{
    if(![countryCode length])
    {
        countryCode = [self defaultCountryCode];
    }
    
    // special case
    if([[countryCode lowercaseString] isEqualToString:@"uk"]==YES)
    {
        countryCode = @"gb";
    }
    
    //////////////////////////////////////////////////

    NSString *displayCountryName = nil;
    
    // cn 碼不能拿系統的表示方法，要拿 plist的
    if([[countryCode lowercaseString] isEqualToString:@"cn"]==YES)
    {
        displayCountryName = [self localizedStringFromPlistWithCountryCode:countryCode
                                                              languageCode:[PPSystemInfoController stringWithLanguage:[PPSystemInfoController language]]];
    }
    
    //////////////////////////////////////////////////

    if(displayCountryName!=nil && displayCountryName.length>0)
    {
        return displayCountryName;
    }
    else
    {
        return [[NSLocale currentLocale] displayNameForKey:NSLocaleCountryCode value:countryCode];
    }
}


//===============================================================================
//
//===============================================================================
+ (NSString *)localizeStringFromCountryCode:(NSString *)countryCode withLanguageCode:(NSString *)languageCode
{
    NSString *countryString = nil;
    NSLocale *locale = nil;
    
    
    if(![countryCode length])
    {
        countryCode = [self defaultCountryCode];
    }
    
    if([[countryCode lowercaseString] isEqualToString:@"uk"])
    {
        countryCode = @"gb";
    }
    
    //////////////////////////////////////////////////

    //特殊解，因為國碼cn在系統上還是會取出中華人民共和國，所以改由plist 取出
    if([[countryCode lowercaseString] isEqualToString:@"cn"]==YES)
    {
        countryString = [self localizedStringFromPlistWithCountryCode:countryCode languageCode:languageCode];
    }
    else
    {
        locale = [self copyLocaleFromLanguageCode:languageCode];
        countryString = [locale displayNameForKey:NSLocaleCountryCode value:countryCode];
        [locale release];
    }
    
    return countryString;
}


//===============================================================================
//
//===============================================================================
+ (NSString *)defaultCountryCode
{
    NSString *countryCode = [[NSLocale currentLocale] objectForKey:NSLocaleCountryCode];
    if(countryCode==nil)
    {
        countryCode = @"EN";
    }
    
    return countryCode;
}

//===============================================================================
//
//===============================================================================
+ (NSString *)languageCodeWithRecogLang:(NSInteger)recogLang
{
    // !! mapping to CountryTemplate_xx.plist
    switch (recogLang)
    {
        case Country_Code_EN: return @"en";
        case Country_Code_B5: return @"zh-hant";
        case Country_Code_HK: return @"zh-hant";
        case Country_Code_GB: return @"zh-hans";
        case Country_Code_JP: return @"ja";
        case Country_Code_KS: return @"ko";
        case Country_Code_GE: return @"de";
        case Country_Code_FR: return @"fr";
        case Country_Code_IT: return @"it";
        case Country_Code_ES: return @"es";
        case Country_Code_PT: return @"pt";
        case Country_Code_NL: return @"nl";
        case Country_Code_PL: return @"pl";
        case Country_Code_RU: return @"ru";
        case Country_Code_SK: return @"sk";
        default: return @"en";
    }
}


//================================================================================
//
//================================================================================
+ (PPCountry_Code)defaultRecogLangWithCountryCode:(NSString *)countryCode
{
    PPCountry_Code recogLang = Country_Code_EN;
    
    do
    {
        // 透過 PPSystemInfoLanguage 取得系統語系
        PPSystemInfoLanguage systemInfoLangauge = [PPSystemInfoController language];
        
        NSString *appLanguage = [PPSystemInfoController stringWithLanguage:systemInfoLangauge];
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if([appLanguage isEqualToString:@"en"])
        {
            recogLang = Country_Code_EN;
        }
        else if([appLanguage isEqualToString:@"zh"])
        {
            //8.0以後的繁簡體Script規則：
            //地區是台灣->zh視為繁體中文，簡體中文會是zh-Hans
            //地區是中國->zh視為簡體中文，繁體中文會是zh-Hant

            if ([countryCode isEqualToString:@"TW"] || [countryCode isEqualToString:@"HK"])
            {
                recogLang = Country_Code_B5;
            }
            else if([countryCode isEqualToString:@"CN"])
            {
                recogLang = Country_Code_GB;
            }
            else
            {
                recogLang = Country_Code_B5;
            }
        }
        else if([appLanguage isEqualToString:@"ko"])			recogLang = Country_Code_KS;
        else if([appLanguage isEqualToString:@"ja"])			recogLang = Country_Code_JP;
        else if([appLanguage isEqualToString:@"es"])			recogLang = Country_Code_ES;
        else if([appLanguage isEqualToString:@"de"])			recogLang = Country_Code_GE;
        else if([appLanguage isEqualToString:@"pt"])			recogLang = Country_Code_PT;
        else if([appLanguage isEqualToString:@"it"])			recogLang = Country_Code_IT;
        else if([appLanguage isEqualToString:@"zh-Hant"])       recogLang = Country_Code_B5;
        else if([appLanguage isEqualToString:@"zh-Hans"])       recogLang = Country_Code_GB;
        else if([appLanguage isEqualToString:@"nl"])			recogLang = Country_Code_NL;
        else if([appLanguage isEqualToString:@"fr"])			recogLang = Country_Code_FR;
        else if([appLanguage isEqualToString:@"ru"])			recogLang = Country_Code_RU;
        else if([appLanguage isEqualToString:@"pl"])			recogLang = Country_Code_PL;
        else if([appLanguage isEqualToString:@"sk"])			recogLang = Country_Code_SK;
        else if([appLanguage isEqualToString:@"tr"])			recogLang = Country_Code_TR;
        else if([appLanguage isEqualToString:@"ar"])			recogLang = Country_Code_AR;
        
    }while(0);
    
    return recogLang;
}


//================================================================================
//
//================================================================================
+ (void)countryListForLanguageCode:(NSString *)languageCode completion:(void (^)(NSDictionary *countryNameDictionary, NSDictionary *regionNameDictionary,  NSArray *countryCodes, NSArray *regionCountries))completion
{
    NSMutableDictionary *countryList = nil;
    
    do
    {
        if(completion==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if([languageCode length]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        countryList = [NSMutableDictionary dictionary];
        
        if(countryList==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        NSMutableArray *countryCodesArray  = [NSMutableArray array];
        
        if(countryCodesArray==nil)
        {
            break;
        }
        
        NSDictionary *regionNameDict = nil;
        NSMutableArray *regionCountryArray = nil;
        
        //////////////////////////////////////////////////

        @autoreleasepool
        {
            //------------------------------------------------------
            // 1. Get the map of coutries distinguished by zones.
            //------------------------------------------------------
            NSString *templateName   = [NSString stringWithFormat:@"CountryTemplate_%@", [languageCode lowercaseString]];
            NSString *path           = [[NSBundle mainBundle] pathForResource:templateName ofType:@"plist"];
            NSDictionary *sourceDict = [NSDictionary dictionaryWithContentsOfFile:path];
            
            // 找不到就用英文
            if(!sourceDict)
            {
                NSString *path = [[NSBundle mainBundle] pathForResource:@"CountryTemplate_en" ofType:@"plist"];
                sourceDict = [NSDictionary dictionaryWithContentsOfFile:path];
            }
            
            //////////////////////////////////////////////////
            
            NSDictionary *countryDict = [sourceDict objectForKey:@"Country"];
            NSArray *sortedArray = [[countryDict allKeys] sortedArrayUsingSelector:@selector(localizedCaseInsensitiveCompare:)];
            
            regionCountryArray = [[NSMutableArray alloc] initWithArray:sortedArray];
            regionNameDict = [[sourceDict objectForKey:@"Region"] retain];
        
            for(int i=0; i<[regionCountryArray count]; i++)
            {
                NSString        *region = [regionCountryArray objectAtIndex:i];
                NSDictionary    *dataDict = [countryDict objectForKey:region];
                NSArray         *codes = [dataDict allKeys];
                
                [countryList setValuesForKeysWithDictionary:dataDict];
                sortedArray = [codes sortedArrayUsingFunction:CompareCountryCode context:countryList];
                [countryCodesArray addObject:sortedArray];
            }
        }
        
        //////////////////////////////////////////////////

        [regionCountryArray autorelease];
        [regionNameDict autorelease];
        
        completion(countryList,regionNameDict,countryCodesArray,regionCountryArray);
    }
    while (0);
}


@end
