//
//  PPCloud_iCloud.m
//  
//
//  Created by Mike on 13/4/17.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPCloud_iCloud.h"
#import "PPCloud+Private.h"
#import "PPiCloudOperation_CreateFolder.h"
#import "PPiCloudOperation_Delete.h"
#import "PPiCloudOperation_LoadFile.h"
#import "PPiCloudOperation_LoadMetadata.h"
#import "PPiCloudOperation_UploadFile.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

NSString *PPCloud_ParameterKey_iCloudUbiquityContainerIdentifiers = @"PPCloud_ParameterKey_iCloudUbiquityContainerIdentifiers";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloud_iCloud()

@interface PPCloud_iCloud() <
                            PPiCloudOperationDelegate_CreateFolder,
                            PPiCloudOperationDelegate_Delete,
                            PPiCloudOperationDelegate_LoadFile,
                            PPiCloudOperationDelegate_LoadMetadata,
                            PPiCloudOperationDelegate_UploadFile
                            >
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPCloud_iCloud

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize defaultUbiquityContainerIdentifier = defaultUbiquityContainerIdentifier_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (id)initWithOperationQueue:(NSOperationQueue *)operationQueue
{
    id object = nil;
    
    do
    {
        if((self=[super initWithOperationQueue:operationQueue]))
        {
            object = self;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            // !! 2014/07/11 目前使用任何id呼叫URLForUbiquityContainerIdnetifier都會失敗，
            //               所以不要設定PPCloud_ParameterKey_iCloudUbiquityContainerIdentifiers。
            
            NSArray *iCloudUbiquityContainerIdentifiers = [PPCloud parameterForKey:PPCloud_ParameterKey_iCloudUbiquityContainerIdentifiers];

            for(NSString *iCloudUbiquityContainerIdentifier in iCloudUbiquityContainerIdentifiers)
            {
                if([PPiCloudOperation URLForUbiquityContainerIdnetifier:iCloudUbiquityContainerIdentifier]==nil)
                {
                    object = nil;
                    
                    break;
                }
            }
        }
        
    }while(0);
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(object!=self)
    {
        [self release];
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    return object;
}

- (void)dealloc
{
    [defaultUbiquityContainerIdentifier_ release];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Overwrite Methods

- (BOOL)isLinked
{
    return ([PPiCloudOperation URLForUbiquityContainerIdnetifier:self.defaultUbiquityContainerIdentifier]!=nil);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_CreateFolder

- (BOOL)createFolder:(NSString *)createFolder delegate:(id<PPCloudDelegate_CreateFolder>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPiCloudOperation_CreateFolder *operation = [[PPiCloudOperation_CreateFolder alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.createFolder = createFolder;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPiCloudOperationDelegate_CreateFolder

- (void)ppiCloudOperation:(PPiCloudOperation_CreateFolder *)operation createFolderFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:createFolderFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
createFolderFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

- (void)ppiCloudOperation:(PPiCloudOperation_CreateFolder *)operation createdFolder:(PPCloudMetadata *)folder
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:createdFolder:userInfo:)]==YES)
    {
        [delegate ppCloud:self
            createdFolder:folder
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_Delete

- (BOOL)deletePath:(NSString *)deletePath delegate:(id<PPCloudDelegate_Delete>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPiCloudOperation_Delete *operation = [[PPiCloudOperation_Delete alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.deletePath = deletePath;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPiCloudOperationDelegate_Delete

- (void)ppiCloudOperation:(PPiCloudOperation_Delete *)operation deletePathFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:deletePathFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
deletePathFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

- (void)ppiCloudOperation:(PPiCloudOperation_Delete *)operation deletedPath:(NSString *)path
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:deletePath:userInfo:)]==YES)
    {
        [delegate ppCloud:self
               deletePath:path
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_LoadFile

- (BOOL)loadFileFromPath:(NSString *)filePath orFileID:(NSString *)fileID intoPath:(NSString *)intoPath delegate:(id<PPCloudDelegate_LoadFile>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPiCloudOperation_LoadFile *operation = [[PPiCloudOperation_LoadFile alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.loadFile = filePath;
            operation.intoPath = intoPath;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPiCloudOperationDelegate_LoadFile

- (void)ppiCloudOperation:(PPiCloudOperation_LoadFile *)operation loadFileFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadFileFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
  loadFileFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

- (void)ppiCloudOperation:(PPiCloudOperation_LoadFile *)operation loadedFile:(NSString *)destPath
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadedFile:userInfo:)]==YES)
    {
        [delegate ppCloud:self
               loadedFile:destPath
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

- (void)ppiCloudOperation:(PPiCloudOperation_LoadFile *)operation loadProgress:(CGFloat)progress forFile:(NSString *)destPath
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadProgress:forFile:userInfo:)]==YES)
    {
        [delegate ppCloud:self
             loadProgress:progress
                  forFile:destPath
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_LoadMetadata

- (BOOL)loadMetadata:(NSString *)loadMetadata delegate:(id<PPCloudDelegate_LoadMetadata>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPiCloudOperation_LoadMetadata *operation = [[PPiCloudOperation_LoadMetadata alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.loadMetadata = loadMetadata;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPiCloudLoadMetadataOperationDelegate

- (void)ppiCloudOperation:(PPiCloudOperation_LoadMetadata *)operation loadMetadataFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadMetadataFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
loadMetadataFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

- (void)ppiCloudOperation:(PPiCloudOperation_LoadMetadata *)operation loadedMetadata:(PPCloudMetadata *)metadata
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadedMetadata:userInfo:)]==YES)
    {
        [delegate ppCloud:self
           loadedMetadata:metadata
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_UploadFile

- (BOOL)uploadFile:(NSString *)filename toPath:(NSString *)toPath fromPath:(NSString *)fromPath delegate:(id<PPCloudDelegate_UploadFile>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPiCloudOperation_UploadFile *operation = [[PPiCloudOperation_UploadFile alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.uploadFile    = filename;
            operation.toPath        = toPath;
            operation.fromPath      = fromPath;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPiCloudOperationDelegate_UploadFile

- (void)ppiCloudOperation:(PPiCloudOperation_UploadFile *)operation uploadFileFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:uploadFileFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
uploadFileFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

- (void)ppiCloudOperation:(PPiCloudOperation_UploadFile *)operation uploadedFile:(NSString *)destPath from:(NSString *)srcPath metadata:(PPCloudMetadata *)metadata
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:uploadedFile:from:metadata:userInfo:)]==YES)
    {
        [delegate ppCloud:self
             uploadedFile:destPath
                     from:srcPath
                 metadata:metadata
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

- (void)ppiCloudOperation:(PPiCloudOperation_UploadFile *)operation uploadProgress:(CGFloat)progress forFile:(NSString *)destPath from:(NSString *)srcPath
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:uploadProgress:forFile:from:userInfo:)]==YES)
    {
        [delegate ppCloud:self
           uploadProgress:progress
                  forFile:destPath
                     from:srcPath
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

@end
