//
//  PPiCloudOperation_LoadMetadata.m
//  
//
//  Created by Mike on 13/4/19.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPiCloudOperation_LoadMetadata.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPiCloudOperation_LoadMetadata()

@interface PPiCloudOperation_LoadMetadata()
@property(nonatomic,retain) NSMetadataQuery *metadataQuery;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPiCloudOperation_LoadMetadata

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize loadMetadata    = loadMetadata_;
@synthesize metadataQuery   = metadataQuery_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (id)init
{
    if((self=[super init]))
    {
        metadataQuery_ = [[NSMetadataQuery alloc] init];
        
        if(self.metadataQuery!=nil)
        {
            [self.metadataQuery setPredicate:[NSPredicate predicateWithFormat:@"%K like '*'", NSMetadataItemFSNameKey]];
            
            [self.metadataQuery setSearchScopes:[NSArray arrayWithObjects:
                                                 NSMetadataQueryUbiquitousDocumentsScope,
                                                 NSMetadataQueryUbiquitousDataScope,
                                                 nil]];
        }
    }
    
    return self;
}

- (void)dealloc
{
    // !! 因為main裡面有用到 observer, 所以這邊要清掉
    [[NSNotificationCenter defaultCenter] removeObserver:self];

    [loadMetadata_ release];
    [metadataQuery_ release];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
	
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {        
            if(self.loadMetadata==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if(self.metadataQuery==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }

            ////////////////////////////////////////////////////////////////////////////////////////////////////
//mike
//            [[NSNotificationCenter defaultCenter] addObserver:self
//                                                     selector:@selector(metadataQueryDidStartGatheringNotification:)
//                                                         name:NSMetadataQueryDidStartGatheringNotification
//                                                       object:self.metadataQuery];
//
//            [[NSNotificationCenter defaultCenter] addObserver:self
//                                                     selector:@selector(metadataQueryGatheringProgressNotification:)
//                                                         name:NSMetadataQueryGatheringProgressNotification
//                                                       object:self.metadataQuery];
//            
//            [[NSNotificationCenter defaultCenter] addObserver:self
//                                                     selector:@selector(metadataQueryDidUpdateNotification:)
//                                                         name:NSMetadataQueryDidUpdateNotification
//                                                       object:self.metadataQuery];
            
            [[NSNotificationCenter defaultCenter] addObserver:self
                                                     selector:@selector(metadataQueryDidFinishGatheringNotification:)
                                                         name:NSMetadataQueryDidFinishGatheringNotification
                                                       object:self.metadataQuery];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            [self.metadataQuery startQuery];
            
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(error!=nil)
        {
            if([self.delegate respondsToSelector:@selector(ppiCloudOperation:loadMetadataFailedWithError:)]==YES)
            {
                [self.delegate ppiCloudOperation:self loadMetadataFailedWithError:error];
            }
            
            [self completion];
        }
    }
}

- (void)metadataQueryDidStartGatheringNotification:(NSNotification *)notification
{
    //mike
//    NSLog(@"class(%@) cmd(%@)", [self class], NSStringFromSelector(_cmd));
}

- (void)metadataQueryGatheringProgressNotification:(NSNotification *)notification
{
    //mike
//    NSLog(@"class(%@) cmd(%@)", [self class], NSStringFromSelector(_cmd));
}

- (void)metadataQueryDidUpdateNotification:(NSNotification *)notification
{
    //mike
//    NSLog(@"class(%@) cmd(%@)", [self class], NSStringFromSelector(_cmd));
}

- (void)metadataQueryDidFinishGatheringNotification:(NSNotification *)notification
{
    //mike
//    NSLog(@"class(%@) cmd(%@)", [self class], NSStringFromSelector(_cmd));
    
    //這邊只是為了要讓local與server狀態是一致的
    
    @autoreleasepool
    {

        NSError *error = nil;
        
        do
        {
            [self.metadataQuery stopQuery];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if([self.delegate respondsToSelector:@selector(ppiCloudOperation:loadedMetadata:)]==YES)
            {
                NSURL *loadMetadataURL = [self URLForCloudPath:self.loadMetadata];
                if(loadMetadataURL==nil)
                {
                    error = PPErrorOperationFailed(nil);
                    break;
                }
                
                PPCloudMetadata *ppCloudMetadata = [[PPCloudMetadata alloc] initWithiCloudURL:loadMetadataURL path:self.loadMetadata error:&error];
                
                if(ppCloudMetadata != nil)
                {
                    [self handleFileContentsWithMetadata:ppCloudMetadata];
                    [self.delegate ppiCloudOperation:self loadedMetadata:ppCloudMetadata];
                    [ppCloudMetadata release];
                }
                else
                {
                    if(error != nil)
                    {
                        error = [self convertErrorFromSystemError:error];
                    }                                    
                }
            }
            
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(error!=nil)
        {
            if([self.delegate respondsToSelector:@selector(ppiCloudOperation:loadMetadataFailedWithError:)]==YES)
            {
                [self.delegate ppiCloudOperation:self loadMetadataFailedWithError:error];
            }
        }
        
        [self completion];
    }
}


//================================================================================
//
//================================================================================
- (void)handleFileContentsWithMetadata:(PPCloudMetadata *)metadata
{
    NSMutableArray *newContents = [NSMutableArray array];
    
    for(NSString *content in metadata.contents)
    {
        NSString *fileName = [content lastPathComponent];
        NSString *prefix = @".";
        NSString *suffix = @".icloud";
        
        if([fileName hasPrefix:prefix] == YES && [fileName hasSuffix:suffix] == YES)
        {
            // !! 強制下載尚未下載的檔案
            fileName = [fileName substringWithRange:NSMakeRange([prefix length], [fileName length]-[prefix length]-[suffix length])];
            fileName = [self.loadMetadata stringByAppendingFormat:@"/%@", fileName];
            [[NSFileManager defaultManager] startDownloadingUbiquitousItemAtURL:[self URLForCloudPath:fileName]
                                                                          error:nil];
        }
        else
        {
            [newContents addObject:content];
        }
    }
    
    metadata.contents = newContents;
}


@end
