//
//  PPiCloudOperation.m
//  
//
//  Created by Mike on 13/4/17.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPiCloudOperation.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPCloudMetadata (iCloud)
- (id)initWithiCloudURL:(NSURL *)iCloudURL path:(NSString *)path error:(NSError **)error
{
    id object = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if((self=[super init]))
    {
        do
        {
            if(iCloudURL==nil || path==nil)
            {
                if(error)
                {
                    *error = PPErrorParameterInvalidity(nil);
                }
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSDate *lastModifiedDate = nil;
            if([iCloudURL getResourceValue:&lastModifiedDate forKey:NSURLContentModificationDateKey error:error]==NO)
            {
                break;
            }
            
            lastModifiedDate_ = [lastModifiedDate retain];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSNumber *isDirectoryNumber = nil;
            if([iCloudURL getResourceValue:&isDirectoryNumber forKey:NSURLIsDirectoryKey error:error]==NO)
            {
                break;
            }
            
            isDirectory_ = [isDirectoryNumber boolValue];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if(self.isDirectory==NO)
            {
                NSNumber *fileSizeNumber = nil;
                if([iCloudURL getResourceValue:&fileSizeNumber forKey:NSURLFileSizeKey error:error]==NO)
                {
                    break;
                }
                
                fileSize_ = [fileSizeNumber retain];
                fileName_ = [[path lastPathComponent] retain];
                fileHash_ = nil;
                
                ////////////////////////////////////////////////////////////////////////////////////////////////////
                
                //mike
//                NSNumber *isDownloadedNumber = nil;
//                if([iCloudURL getResourceValue:&isDownloadedNumber forKey:NSURLUbiquitousItemIsDownloadedKey error:error]==YES)
//                {
//                    //NSLog(@"iCloudURLisDownloadedNumber:%@", isDownloadedNumber);
//                }
//                
//                NSNumber *isDownloadingNumber = nil;
//                if([iCloudURL getResourceValue:&isDownloadingNumber forKey:NSURLUbiquitousItemIsDownloadingKey error:error]==YES)
//                {
//                    //NSLog(@"isDownloadingNumber:%@", isDownloadingNumber);
//                }
//                
//                NSNumber *isUploadedNumber = nil;
//                if([iCloudURL getResourceValue:&isUploadedNumber forKey:NSURLUbiquitousItemIsUploadedKey error:error]==YES)
//                {
//                    //NSLog(@"isUploadedNumber:%@", isUploadedNumber);
//                }
//                
//                NSNumber *isUploadingNumber = nil;
//                if([iCloudURL getResourceValue:&isUploadingNumber forKey:NSURLUbiquitousItemIsUploadingKey error:error]==YES)
//                {
//                    //NSLog(@"isUploadingNumber:%@", isUploadingNumber);
//                }
//                
//                NSNumber *percentDownloadedNumber = nil;
//                if([iCloudURL getResourceValue:&percentDownloadedNumber forKey:NSURLUbiquitousItemPercentDownloadedKey error:error]==YES)
//                {
//                    //NSLog(@"percentDownloadedNumber:%@", percentDownloadedNumber);
//                }
//                
//                NSNumber *percentUploadedNumber = nil;
//                if([iCloudURL getResourceValue:&percentUploadedNumber forKey:NSURLUbiquitousItemPercentUploadedKey error:error]==YES)
//                {
//                    //NSLog(@"percentUploadedNumber:%@", percentUploadedNumber);
//                }
                
//                NSLog(@"iCloudURL:%@ isDownloaded:%@ isDownloading:%@ isUploaded:%@ isUploading:%@ percentDownloaded:%@ percentUploaded:%@", iCloudURL, isDownloadedNumber, isDownloadingNumber, isUploadedNumber, isUploadingNumber, percentDownloadedNumber, percentUploadedNumber);
            }
            else
            {
                NSMutableArray *contents = [[NSMutableArray alloc] init];
                if(contents!=nil)
                {
                    NSArray *contentsOfDirectory = [[NSFileManager defaultManager] contentsOfDirectoryAtPath:[iCloudURL path] error:error];
                    for(NSString *content in contentsOfDirectory)
                    {
                        //mike
//                        NSNumber *isDownloadedNumber = nil;
//                        if([iCloudURL getResourceValue:&isDownloadedNumber forKey:NSURLUbiquitousItemIsDownloadedKey error:error]==YES)
//                        {
//                            //NSLog(@"iCloudURLisDownloadedNumber:%@", isDownloadedNumber);
//                        }
//                        
//                        NSNumber *isDownloadingNumber = nil;
//                        if([iCloudURL getResourceValue:&isDownloadingNumber forKey:NSURLUbiquitousItemIsDownloadingKey error:error]==YES)
//                        {
//                            //NSLog(@"isDownloadingNumber:%@", isDownloadingNumber);
//                        }
//                        
//                        NSNumber *isUploadedNumber = nil;
//                        if([iCloudURL getResourceValue:&isUploadedNumber forKey:NSURLUbiquitousItemIsUploadedKey error:error]==YES)
//                        {
//                            //NSLog(@"isUploadedNumber:%@", isUploadedNumber);
//                        }
//                        
//                        NSNumber *isUploadingNumber = nil;
//                        if([iCloudURL getResourceValue:&isUploadingNumber forKey:NSURLUbiquitousItemIsUploadingKey error:error]==YES)
//                        {
//                            //NSLog(@"isUploadingNumber:%@", isUploadingNumber);
//                        }
//                        
//                        NSNumber *percentDownloadedNumber = nil;
//                        if([iCloudURL getResourceValue:&percentDownloadedNumber forKey:NSURLUbiquitousItemPercentDownloadedKey error:error]==YES)
//                        {
//                            //NSLog(@"percentDownloadedNumber:%@", percentDownloadedNumber);
//                        }
//                        
//                        NSNumber *percentUploadedNumber = nil;
//                        if([iCloudURL getResourceValue:&percentUploadedNumber forKey:NSURLUbiquitousItemPercentUploadedKey error:error]==YES)
//                        {
//                            //NSLog(@"percentUploadedNumber:%@", percentUploadedNumber);
//                        }
                        
//                        NSLog(@"contentURL:%@ isDownloaded:%@ isDownloading:%@ isUploaded:%@ isUploading:%@ percentDownloaded:%@ percentUploaded:%@", contentURL, isDownloadedNumber, isDownloadingNumber, isUploadedNumber, isUploadingNumber, percentDownloadedNumber, percentUploadedNumber);
                        
                        ////////////////////////////////////////////////////////////////////////////////////////////////////
                        
                        [contents addObject:[path stringByAppendingPathComponent:content]];
                    }
                    
                    contents_ = [[NSArray alloc] initWithArray:contents];
                    
                    [contents release];
                }
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            cloudClassName_  = [NSStringFromClass([PPCloud_iCloud class]) retain];
            path_            = [path retain];
            uniqueID_        = nil;
            rawData_         = nil;
            thumbnailExists_ = NO;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            object = self;
            
        }while(0);
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(object!=self)
    {
        [self release];
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    return object;
}
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPiCloudOperation

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize ubiquityContainerIdentifier = ubiquityContainerIdentifier_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (id)init
{
    id object = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if((self=[super init]))
    {
        self.privateConcurrent = YES;
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        object = self;
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(object!=self)
    {
        [self release];
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    return object;
}

- (void)dealloc
{
	[ubiquityContainerIdentifier_ release];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)start
{
	if([self isCancelled]==YES)
	{
		[self setFinished:YES];
	}
	else
	{
        [self setExecuting:YES];
        
        // metadataQuery需要在mainThread
//        [self performSelector:@selector(main) withObject:nil];
        
        [self performSelectorOnMainThread:@selector(main)
                               withObject:nil
                            waitUntilDone:NO];

	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance methods

- (NSString *)documentPath
{
    return [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) objectAtIndex:0];
}

- (NSURL *)URLForUbiquityContainerIdnetifier
{
    return [PPiCloudOperation URLForUbiquityContainerIdnetifier:self.ubiquityContainerIdentifier];
}

- (NSURL *)URLForCloudPath:(NSString *)cloudPath
{
    return [[self URLForUbiquityContainerIdnetifier] URLByAppendingPathComponent:cloudPath];
}

- (NSError *)convertErrorFromSystemError:(NSError *)systemError
{
    NSError *convertError = systemError;

    if([systemError.domain isEqualToString:@"NSCocoaErrorDomain"] == YES && systemError.code == 260)
    {
        convertError = PPErrorMake(PPCloudCommonError_PathNotExist, @"File not found", systemError);
    }
    else
    {
        NSError *underlyingError = [systemError.userInfo objectForKey:@"NSUnderlyingError"];
        
        if(underlyingError != nil)
        {
            convertError = PPErrorMake(systemError.code,
                                       underlyingError.description,
                                       systemError.userInfo);
        }
    }
    
    return convertError;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class methods

+ (NSURL *)URLForUbiquityContainerIdnetifier:(NSString *)ubiquityContainerIdentifier
{    
    __block NSURL   *ubiquityContainerIdnetifierURL = nil;
    __block BOOL    executing                       = YES;
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        // !! 預設行為輸入的ubiquityContainerIdentifier是nil，系統會自動去取entitlement中的資料。
        ubiquityContainerIdnetifierURL = [[[NSFileManager defaultManager] URLForUbiquityContainerIdentifier:ubiquityContainerIdentifier] copy];
        executing = NO;
    });
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    while(executing==YES)
    {
        @autoreleasepool
        {
            [[NSRunLoop currentRunLoop] runUntilDate:[NSDate dateWithTimeIntervalSinceNow:PPCloudOperation_WaitInterval]];
        }
    }
    
    return [ubiquityContainerIdnetifierURL autorelease];
}

@end
