//
//  PPOneDriveOperation_Unlink.m
//  
//
//  Created by Mike on 13-3-13.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPOneDriveOperation_Unlink.h"

@implementation PPOneDriveOperation_Unlink

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        
        __block typeof(self) blockSelf =  self;
        
        [self.odClient signOutWithCompletion:^(NSError *signOutError){
            
            [ODClient setCurrentClient:nil];
            
            if (signOutError == nil)
            {
                if([blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperationUnlinkSuccess:)]==YES)
                {
                    [blockSelf.delegate ppOneDriveOperationUnlinkSuccess:blockSelf];
                }
            }
            else
            {
                if([blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:unlinkFailedWithError:)]==YES)
                {
                    [blockSelf.delegate ppOneDriveOperation:blockSelf unlinkFailedWithError:signOutError];
                }
            }
            
            [blockSelf completion];
        }];
    
    }
}

@end
