//
//  PPOneDriveOperation_Sharedlink.m
//  Pods
//
//  Created by Andrew on 2015/1/15.
//  Copyright (c) 2015年 Penpower. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "PPOneDriveOperation_Sharedlink.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPOneDriveOperation_Sharedlink Implementation

@implementation PPOneDriveOperation_Sharedlink





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.sharedlinkFile = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

//================================================================================
//
//================================================================================
- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            if (self.sharedlinkFile==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                
                if ([self.delegate respondsToSelector:@selector(ppOneDriveOperation:sharedlinkFailedWithError:)]==YES)
                {
                    [self.delegate ppOneDriveOperation:self sharedlinkFailedWithError:error];
                }
                
                [self completion];
                break;
            }
            
            //////////////////////////////////////////////////
            // 取得網空上對應file的shared link
            
            // 去除路徑開頭的'/'
            self.sharedlinkFile = [self.sharedlinkFile substringFromIndex:1];
            
            __block typeof(self) blockSelf = self;
            
            [[[[[self.odClient root] itemByPath:self.sharedlinkFile] createLinkWithType:@"view"] request] executeWithCompletion:^(ODPermission *response, NSError *error) {
                
                if (error!=nil)
                {
                    if ([blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:sharedlinkFailedWithError:)]==YES)
                    {
                        [blockSelf.delegate ppOneDriveOperation:blockSelf sharedlinkFailedWithError:error];
                    }
                }
                else
                {
                    if ([blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:sharedlinkString:)]==YES)
                    {
                        [blockSelf.delegate ppOneDriveOperation:blockSelf sharedlinkString:response.link.webUrl];
                    }
                }
                
                [blockSelf completion];
            }];
            
        
        }while (0);
    
        
    }
}


@end
