//
//  PPOneDriveOperation_LoadThumbnail.m
//  
//
//  Created by Mike on 13-3-14.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPOneDriveOperation_LoadThumbnail.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

NSString *PPOneDriveThumbnailSize_Large  = @"large";
NSString *PPOneDriveThumbnailSize_Medium = @"medium";
NSString *PPOneDriveThumbnailSize_Small	= @"small";

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPOneDriveOperation_LoadThumbnail

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize loadThumbnail   = loadThumbnail_;
@synthesize intoPath        = intoPath_;
@synthesize ofSize          = ofSize_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark -
#pragma mark - Creating, Copying, and Deallocating Objects

- (void)dealloc
{
    [loadThumbnail_ release];
	[intoPath_ release];
	[ofSize_ release];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            if(self.loadThumbnail==nil || self.ofSize==nil || self.intoPath==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                if([self.delegate respondsToSelector:@selector(ppOneDriveOperation:loadThumbnailFailedWithError:)]==YES)
                {
                    [self.delegate ppOneDriveOperation:self loadThumbnailFailedWithError:error];
                }
                [self completion];
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            __block typeof(self) blockSelf = self;
            
            // 去除路徑開頭的'/'
            self.loadThumbnail = [self.loadThumbnail substringFromIndex:1];
            
            [[[[self.odClient root] itemByPath:self.loadThumbnail] request] getWithCompletion:^(ODItem *response, NSError *error) {
            
                //////////////////////////////////////////////////
                // OneDrive的SDK好像沒有Thumbnail為空時的Error Code 所以用自己的
                NSString *thumbnail = [response thumbnails:0].source.url;
                
                if (error == nil && thumbnail == nil)
                {
                    error = PPErrorMake(NSErrorCustom_Code_UserDefine, @"No Thumbnails for this item", response);
                }
                
                if(error!=nil)
                {
                    if([blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:loadThumbnailFailedWithError:)]==YES)
                    {
                        [blockSelf.delegate ppOneDriveOperation:blockSelf loadThumbnailFailedWithError:error];
                    }
                    
                }
                else
                {
                    if([blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:loadedThumbnail:)]==YES)
                    {
                        [blockSelf.delegate ppOneDriveOperation:blockSelf loadedThumbnail:thumbnail];
                    }
                }
                
                [blockSelf completion];
            }];
            
            
        }while(0);
        
        
    }
}


@end
