//
//  PPOneDriveOperation_LoadAccountInfo.m
//  
//
//  Created by Mike on 13-3-13.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPOneDriveOperation_LoadAccountInfo.h"

@implementation PPOneDriveOperation_LoadAccountInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        
        __block typeof(self) blockSelf = self;
        
        [[[self.odClient drive] request] getWithCompletion:^(ODDrive *response, NSError *error){
            
            if (error != nil)
            {
                if ([blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:loadAccountInfoFailedWithError:)])
                {
                    [blockSelf.delegate ppOneDriveOperation:blockSelf loadAccountInfoFailedWithError:error];
                }
            }
            else
            {
                if ([blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:loadedAccountInfo:driveInfo:)])
                {
                    [blockSelf.delegate ppOneDriveOperation:blockSelf loadedAccountInfo:blockSelf.odClient driveInfo:response];
                }
            }
            
            [blockSelf completion];
        }];
        
    }
}

@end
