//
//  PPGoogleDriveOperation_UploadFile.m
//
//
//  Created by Mike on 13/4/15.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPGoogleDriveOperation_UploadFile.h"

#if TARGET_OS_IPHONE
#import <MobileCoreServices/MobileCoreServices.h>
#endif

#import "GTMSessionFetcher.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGoogleDriveOperation_UploadFile()

@interface PPGoogleDriveOperation_UploadFile()

@property (nonatomic,retain) GTLRServiceTicket *serviceTicket;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPGoogleDriveOperation_UploadFile


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_uploadFile release];
    [_toPath release];
    [_fromPath release];
    
    [_serviceTicket release];
    _serviceTicket = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    [super dealloc];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

//================================================================================
//
//================================================================================
- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        NSString *mimeType = nil;
        
        do
        {
            if(self.uploadFile==nil || self.toPath==nil || self.fromPath==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSDictionary *identifierForFolderDictionary = [GTLRDriveService sharedServiceDrive].identifierForFolderDictionary;
            
            NSString *fileID = [identifierForFolderDictionary objectForKey:self.toPath];
            
            GTLRDrive_File *toPathFile = [[GTLRDriveService sharedServiceDrive] fileForIdentifier:fileID
                                                                                       error:nil];
            if(toPathFile==nil)
            {
                NSArray *toPathFiles = [[GTLRDriveService sharedServiceDrive] filesForPathComponents:[self.toPath pathComponents]
                                                                              currentPathComponentID:nil
                                                                                               error:&error];
                if(error!=nil)
                {
                    break;
                }
                
                ////////////////////////////////////////////////////////////////////////////////////////////////////
                
                if([toPathFiles count]<1)
                {
                    error = PPErrorMake(PPCloudCommonError_PathNotExist, @"Path not exist", nil);
                    break;
                }
                
                ////////////////////////////////////////////////////////////////////////////////////////////////////
                
                if([toPathFiles count]>1)
                {
                    error = PPErrorMake(PPCloudCommonError_MultipleItemsWithSamePath, @"Duplicate folder", nil);
                    break;
                }
                
                ////////////////////////////////////////////////////////////////////////////////////////////////////
                
                toPathFile = [toPathFiles objectAtIndex:0];
                
                //////////////////////////////////////////////////
                
                [[GTLRDriveService sharedServiceDrive].identifierForFolderDictionary setObject:toPathFile.identifier forKey:self.toPath];
            }
            
            //Parent一定要是目錄
            if([toPathFile.mimeType isEqualToString:GTLDriveFile_MimeType_Folder]==NO)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSString *fileExtension = [self.fromPath pathExtension];
            NSString *UTI = (NSString *)UTTypeCreatePreferredIdentifierForTag(kUTTagClassFilenameExtension, (__bridge CFStringRef)fileExtension, NULL);
            
            mimeType = (NSString *)UTTypeCopyPreferredTagWithClass((__bridge CFStringRef)UTI, kUTTagClassMIMEType);
            
            [UTI release];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            GTLRDrive_File *toFile = [GTLRDrive_File object];
            if(toFile==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            toFile.name    = self.uploadFile;
            toFile.mimeType = mimeType;
            toFile.parents  = [NSArray arrayWithObjects:toPathFile.identifier, nil];
            
            if(toFile.parents==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
  
            GTLRUploadParameters *uploadParameters = [GTLRUploadParameters uploadParametersWithFileURL:[NSURL fileURLWithPath:self.fromPath]
                                                                                            MIMEType:mimeType];
            
            if(uploadParameters==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            GTLRDriveQuery_FilesCreate *uploadFileQuery = [GTLRDriveQuery_FilesCreate queryWithObject:toFile
                                                                                     uploadParameters:uploadParameters];
            if(uploadFileQuery==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            //////////////////////////////////////////////////

            //這邊因為fetcher是由上層控制,我們如果直接使用fetcher delegate,會造成訊息傳遞有問題,故只能使用上層提供的block
            
            uploadFileQuery.executionParameters.uploadProgressBlock = ^(GTLRServiceTicket * _Nonnull progressTicket, unsigned long long totalBytesUploaded, unsigned long long totalBytesExpectedToUpload) {
                if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:uploadProgress:forFile:from:)]==YES)
                {
                    [self.delegate ppGoogleDriveOperation:self uploadProgress:(double)totalBytesUploaded/(double)totalBytesExpectedToUpload forFile:[self.toPath stringByAppendingPathComponent:self.uploadFile] from:self.fromPath];
                }
            };
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            self.serviceTicket = [[GTLRDriveService sharedServiceDrive] executeQuery:uploadFileQuery
                                                                           delegate:self
                                                                  didFinishSelector:@selector(serviceTicket:finishedWithFile:error:)];
            if(self.serviceTicket==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            //////////////////////////////////////////////////

            self.serviceTicket.objectFetcher.useBackgroundSession = NO;
       
        }while(0);
        
        [mimeType release];
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        
        if(error!=nil)
        {
            if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:uploadFileFailedWithError:)]==YES)
            {
                [self.delegate ppGoogleDriveOperation:self uploadFileFailedWithError:error];
            }
            
            [self completion];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)cancel
{
    [self.serviceTicket cancelTicket];
    
    //////////////////////////////////////////////////
    
    [super cancel];
    
    //////////////////////////////////////////////////
    
    if(self.finished==NO)
    {
        if(self.executing==YES)
        {
            [self setExecuting:NO];
        }
        
        [self setFinished:YES];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private

//================================================================================
//
//================================================================================
-(void)serviceTicket:(GTLRServiceTicket *)ticket finishedWithFile:(GTLRDrive_File *)file error:(NSError *)error
{
    if(error!=nil)
    {
        if(error.domain==kGTLRServiceErrorDomain &&
           error.code==403)
        {
            error = PPErrorMake(PPCloudCommonError_SpaceNotEnough, @"SpaceNotEnough", nil);
        }
        
        //////////////////////////////////////////////////
        
        if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:uploadFileFailedWithError:)]==YES)
        {
            [self.delegate ppGoogleDriveOperation:self uploadFileFailedWithError:error];
        }
    }
    else
    {
        if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:uploadedFile:from:metadata:)]==YES)
        {
            [self.delegate ppGoogleDriveOperation:self uploadedFile:[self.toPath stringByAppendingPathComponent:self.uploadFile] from:self.fromPath metadata:[NSDictionary dictionaryWithObjectsAndKeys:file, NSStringFromClass([file class]), nil]];
        }
    }
    
    [self completion];
}

@end
