//
//  PPGoogleDriveOperation_LoadAccountInfo.m
//  
//
//  Created by Mike on 13/4/9.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPGoogleDriveOperation_LoadAccountInfo.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGoogleDriveOperation_LoadAccountInfo()

@interface PPGoogleDriveOperation_LoadAccountInfo()
- (void)serviceTicket:(GTLRServiceTicket *)ticket finishedWithAbout:(GTLRDrive_About *)About error:(NSError *)error;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPGoogleDriveOperation_LoadAccountInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            GTLRDriveQuery_AboutGet *aboutGetQuery = [GTLRDriveQuery_AboutGet query];
            
            if(aboutGetQuery==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            aboutGetQuery.fields = @"*";
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            GTLRServiceTicket *ticket = [[GTLRDriveService sharedServiceDrive] executeQuery:aboutGetQuery
                                                                                 delegate:self
                                                                        didFinishSelector:@selector(serviceTicket:finishedWithAbout:error:)];
            if(ticket==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(error!=nil)
        {
            if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:loadAccountInfoFailedWithError:)]==YES)
            {
                [self.delegate ppGoogleDriveOperation:self loadAccountInfoFailedWithError:error];
            }
            
            [self completion];
        }
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private

- (void)serviceTicket:(GTLRServiceTicket *)ticket finishedWithAbout:(GTLRDrive_About *)About error:(NSError *)error
{
    if(error!=nil)
    {
        if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:loadAccountInfoFailedWithError:)]==YES)
        {
            [self.delegate ppGoogleDriveOperation:self loadAccountInfoFailedWithError:error];
        }
    }
    else
    {
        if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:loadedAccountInfo:)]==YES)
        {
            [self.delegate ppGoogleDriveOperation:self loadedAccountInfo:About];
        }
    }
    
    [self completion];
}

@end
