//
//  PPGoogleDriveOperation_Delete.m
//  
//
//  Created by Mike on 13/4/12.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPGoogleDriveOperation_Delete.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGoogleDriveOperation_Delete()

@interface PPGoogleDriveOperation_Delete()
- (void)serviceTicket:(GTLRServiceTicket *)ticket finishedWithObject:(id)object error:(NSError *)error;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPGoogleDriveOperation_Delete

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize deletePath = deletePath_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (void)dealloc
{
    [deletePath_ release];
	
	//////////////////////////////////////////////////
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            if(self.deletePath==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }
            
            //////////////////////////////////////////////////

            NSDictionary *identifierForFolderDictionary = [GTLRDriveService sharedServiceDrive].identifierForFolderDictionary;
            
            NSString *fileID = [identifierForFolderDictionary objectForKey:[self.deletePath stringByDeletingLastPathComponent]];
            
            GTLRDrive_File *rootFile = [[GTLRDriveService sharedServiceDrive] fileForIdentifier:fileID error:nil];
            
            NSArray *pathComponents = [self.deletePath pathComponents];
            NSString *pathComponentID = nil;
            
            // 找到 root檔案，直接找 file
            if(rootFile!=nil)
            {
                pathComponentID = rootFile.identifier;
                pathComponents = @[PPCloud_RootPath, self.deletePath.lastPathComponent];
            }
     
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSArray *deletePathFiles = [[GTLRDriveService sharedServiceDrive] filesForPathComponents:pathComponents
                                                                              currentPathComponentID:pathComponentID
                                                                                               error:&error];
            if(error!=nil)
            {
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if([deletePathFiles count]<1)
            {
                error = PPErrorMake(PPCloudCommonError_PathNotExist, @"File not found", nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if([deletePathFiles count]>1)
            {
                error = PPErrorMake(PPCloudCommonError_MultipleItemsWithSamePath, @"More than one files", nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            GTLRDrive_File *deletePathFile = [deletePathFiles objectAtIndex:0];
           
            GTLRDriveQuery_FilesDelete *deletePathQuery = [GTLRDriveQuery_FilesDelete queryWithFileId:deletePathFile.identifier];
        
            if(deletePathQuery==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            GTLRServiceTicket *ticket = [[GTLRDriveService sharedServiceDrive] executeQuery:deletePathQuery
                                                                                 delegate:self
                                                                        didFinishSelector:@selector(serviceTicket:finishedWithObject:error:)];
            if(ticket==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(error!=nil)
        {
            if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:deletePathFailedWithError:)]==YES)
            {
                [self.delegate ppGoogleDriveOperation:self deletePathFailedWithError:error];
            }
            
            [self completion];
        }
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private

- (void)serviceTicket:(GTLRServiceTicket *)ticket finishedWithObject:(id)object error:(NSError *)error
{
    if(error!=nil)
    {
        if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:deletePathFailedWithError:)]==YES)
        {
            [self.delegate ppGoogleDriveOperation:self deletePathFailedWithError:error];
        }
    }
    else
    {
        if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:deletedPath:)]==YES)
        {
            [self.delegate ppGoogleDriveOperation:self deletedPath:self.deletePath];
        }
    }
    
    [self completion];
}

@end
