//
//  PPDropboxOperation_LoadMetadata.m
//  
//
//  Created by Mike on 13-3-13.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPDropboxOperation_LoadMetadata.h"

@implementation PPDropboxOperation_LoadMetadata

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize loadMetadata    = loadMetadata_;
@synthesize hash            = hash_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (void)dealloc
{
    [loadMetadata_ release];
    [hash_ release];
	
    ////////////////////////////////////////////////////////////////////////////////////////////////////
	
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

//================================================================================
//
//================================================================================
- (void)main
{
    @autoreleasepool
    {
        NSError *returnError = nil;
        
        do
        {
            if(self.loadMetadata==nil)
            {
                returnError = PPErrorParameterInvalidity(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            DBFILESUserAuthRoutes *fileRoutes = [DBClientsManager authorizedClient].filesRoutes;
            
            if(fileRoutes==nil)
            {
                returnError  = PPErrorParameterInvalidity(nil);
                break;
            }
            
            //////////////////////////////////////////////////
            
            __block typeof(self) blockself = self;
            
            [[fileRoutes listFolder:self.loadMetadata]
              setResponseBlock:^(DBFILESListFolderResult *filesMetadata, DBFILESListFolderError *routeError, DBRequestError *error) {
                 
                  if (filesMetadata)
                  {
                      if([blockself.delegate respondsToSelector:@selector(ppDropboxOperation:loadedMetadata:)]==YES)
                      {
                          [blockself.delegate ppDropboxOperation:blockself loadedMetadata:filesMetadata];
                      }
                  }
                  else
                  {
                      if([blockself.delegate respondsToSelector:@selector(ppDropboxOperation:loadMetadataFailedWithError:)]==YES)
                      {
                          NSError *convertedError = nil;
                          
                          // !! Howard 特殊做法，導入相同流程，此時404代表目錄下沒有任何檔案
                          if([error.statusCode integerValue]==404)
                          {
                              convertedError = PPErrorMake(PPCloudCommonError_PathNotExist, @"File not found", nil);
                          }
                          else
                          {
                              convertedError = [blockself convertErrorFromSystemError:error];
                          }
                          
                          [blockself.delegate ppDropboxOperation:blockself loadMetadataFailedWithError:convertedError];
                      }
                  }
                  
                  //////////////////////////////////////////////////

                  [blockself completion];
                  
              }];
              
              
        }while(0);
        
        //////////////////////////////////////////////////

        if(returnError!=nil &&
           [self.delegate respondsToSelector:@selector(ppDropboxOperation:loadMetadataFailedWithError:)]==YES)
        {
            [self.delegate ppDropboxOperation:self loadMetadataFailedWithError:returnError];
            [self completion];
        }
    }
}

@end
