//
//  PPDropboxOperation_Link.m
//  
//
//  Created by Mike on 13-3-12.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPDropboxOperation_Link.h"

// Category
#import "NSObject+Wait.h"

#import "PPCloud.h"

@implementation PPDropboxOperation_Link

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize viewcontroller = viewcontroller_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
#if TARGET_OS_IPHONE
#elif TARGET_OS_MAC
        [[NSAppleEventManager sharedAppleEventManager] setEventHandler:self
                                                           andSelector:@selector(handleAppleEvent:withReplyEvent:)
                                                         forEventClass:kInternetEventClass
                                                            andEventID:kAEGetURL];
#endif
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [viewcontroller_ release];

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

//================================================================================
//
//================================================================================
- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            if(self.viewcontroller==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
          
#if TARGET_OS_IPHONE
            
            __block typeof(self) blockself = self;
            
            dispatch_async(dispatch_get_main_queue(), ^{
                
                
                DBScopeRequest *scopeRequest = [[[DBScopeRequest alloc] initWithScopeType:DBScopeTypeUser
                                                                                   scopes:@[]
                                                                     includeGrantedScopes:NO] autorelease];
                
                
                [DBClientsManager authorizeFromControllerV2:[UIApplication sharedApplication]
                                                 controller:self.viewcontroller
                                      loadingStatusDelegate:nil
                                                    openURL:^(NSURL *url) {
                    // dropbox 底層，登入頁面按取消，呼叫 [DBClientsManager handleRedirectURL:url], 會自動退開 viewController, 所以這邊另行處理
                    if (([[url host] isEqualToString:@"1"] && [[url path] isEqualToString:@"/cancel"]) ||
                        ([[url host] isEqualToString:@"2"] && [[url path] isEqualToString:@"/cancel"]))
                    {
                        if([self.delegate respondsToSelector:@selector(ppDropboxOperation:linkFailedWithError:)]==YES)
                        {
                            [blockself.delegate ppDropboxOperation:blockself linkFailedWithError:PPErrorMake(PPCloudCommonError_CancelLogin, @"Login canceled", nil)];
                        }
                        
                        //////////////////////////////////////////////////

                        [blockself completion];
                    }
                    else
                    {
                        [[UIApplication sharedApplication] openURL:url];
                    }
                }
                                               scopeRequest:scopeRequest];
                
            });
#elif TARGET_OS_MAC
            [self performSelectorOnMainThread:@selector(mainThreadShowLoginViewContorller) withObject:nil waitUntilDone:NO];
#endif
      
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(error!=nil)
        {
            if([self.delegate respondsToSelector:@selector(ppDropboxOperation:linkFailedWithError:)]==YES)
            {
                [self.delegate ppDropboxOperation:self linkFailedWithError:error];
            }
            
            [self completion];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Notificaiton Method

#if TARGET_OS_IPHONE
#elif TARGET_OS_MAC

//================================================================================
//
//================================================================================
- (void)handleAppleEvent:(NSAppleEventDescriptor *)event withReplyEvent:(NSAppleEventDescriptor *)replyEvent
{
    BOOL result = NO;
    NSError *returnError = nil;
    
    do
    {
        NSURL *url = [NSURL URLWithString:[[event paramDescriptorForKeyword:keyDirectObject] stringValue]];
        
        if(url==nil)
        {
            returnError = PPErrorMake(PPCloudCommonError_LinkFailed, @"Linked failed", nil);
            break;
        }
        
        //////////////////////////////////////////////////
        
        __block DBOAuthResult *authResult = nil;
        __block BOOL hasAuthResult = NO;
        
        [DBClientsManager handleRedirectURL:url completion:^(DBOAuthResult * _Nullable returnAuthResult) {
            authResult = [returnAuthResult retain];
            hasAuthResult = YES;
        }];
        
        [self waitBlock:^BOOL(id object) {
            return hasAuthResult;
        }];
        
        if(authResult==nil)
        {
            returnError = PPErrorMake(PPCloudCommonError_LinkFailed, @"handleRedirectURL failed", nil);
            break;
        }
        
        //////////////////////////////////////////////////

        result = [authResult isSuccess];
        
        [authResult release];
        
        if(result==YES)
        {
            break;
        }
     
        //////////////////////////////////////////////////

        if ([authResult isCancel]==YES)
        {
            returnError = PPErrorMake(PPCloudCommonError_CancelLogin, @"Login canceled", nil);
        }
        else if ([authResult isError]==YES)
        {
            NSString *errorMessage = [NSString stringWithFormat:@"authResult type:%td, %@",authResult.errorType,authResult.errorDescription];
            
            returnError = PPErrorMake(PPCloudCommonError_LinkFailed,
                                      errorMessage,
                                      nil);
        }
        else
        {
            returnError = PPErrorMake(PPCloudCommonError_Unknown,
                                      @"unknown error",
                                      nil);
        }
    }
    while (0);
    
    //////////////////////////////////////////////////
    
    if(result==YES)
    {
        if([self.delegate respondsToSelector:@selector(ppDropboxOperationLinkSuccess:)]==YES)
        {
            [self.delegate ppDropboxOperationLinkSuccess:self];
        }
    }
    else
    {
        if([self.delegate respondsToSelector:@selector(ppDropboxOperation:linkFailedWithError:)]==YES)
        {
            [self.delegate ppDropboxOperation:self linkFailedWithError:returnError];
        }
    }
    
    //////////////////////////////////////////////////
    
#if TARGET_OS_IPHONE
#elif TARGET_OS_MAC
    [[NSAppleEventManager sharedAppleEventManager] removeEventHandlerForEventClass:kInternetEventClass andEventID:kAEGetURL];
#endif
    
    //////////////////////////////////////////////////

    [self completion];
}
#endif


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Overwrite Methods

//================================================================================
//
//================================================================================
- (void)cancel
{
    [super cancel];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    [self completion];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
    
#pragma mark - Private Method

#if TARGET_OS_IPHONE
#elif TARGET_OS_MAC

//================================================================================
//
//================================================================================
- (void)mainThreadShowLoginViewContorller
{
    if(self.viewcontroller.contentViewController==nil)
    {
        NSError *returnError = PPErrorMake(PPCloudCommonError_LinkFailed, @"NSWindowController's ContentViewController is nil", nil);
        
        if([self.delegate respondsToSelector:@selector(ppDropboxOperation:linkFailedWithError:)]==YES)
        {
            [self.delegate ppDropboxOperation:self linkFailedWithError:returnError];
        }
        
        //////////////////////////////////////////////////

        [self completion];
    }
    else
    {
        // New: OAuth 2 code flow with PKCE that grants a short-lived token with scopes.
        DBScopeRequest *scopeRequest = [[[DBScopeRequest alloc] initWithScopeType:DBScopeTypeUser
                                                                           scopes:@[]
                                                             includeGrantedScopes:NO] autorelease];
        
        [DBClientsManager authorizeFromControllerDesktopV2:[NSWorkspace sharedWorkspace]
                                                controller:self.viewcontroller.contentViewController
                                     loadingStatusDelegate:nil
                                                   openURL:^(NSURL *url) { [[NSWorkspace sharedWorkspace] openURL:url]; }
                                              scopeRequest:scopeRequest];
    }
}
#endif

    
    

    

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//================================================================================
//
//================================================================================
- (BOOL)handleOpenURL:(NSURL *)url
{
    BOOL result = NO;
    __block BOOL isHandled = NO;
    
    __block DBOAuthResult *authResult = nil;
    NSError *returnError = nil;
    
    do
    {
        if(url==nil)
        {
            // !! 沒有處理，不算錯誤
            break;
        }
        
        //////////////////////////////////////////////////
        
        
        [DBClientsManager handleRedirectURL:url
                                 completion:^(DBOAuthResult * _Nullable result) {
            
            authResult = [result retain];
            isHandled = YES;
        }];
        
        [self waitBlock:^BOOL(id object) {
            return isHandled;
        }];
        
        if(authResult==nil)
        {
            // !! 沒有處理，不算錯誤
            break;
        }
        
        //////////////////////////////////////////////////
      
        result = [authResult isSuccess];
        
        if(result==YES)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if ([authResult isCancel]==YES)
        {
            returnError = PPErrorMake(PPCloudCommonError_CancelLogin, @"Login canceled", nil);
        }
        else if ([authResult isError]==YES)
        {
            NSString *errorMessage = [NSString stringWithFormat:@"authResult type:%td, %@",authResult.errorType,authResult.errorDescription];
            
            returnError = PPErrorMake(PPCloudCommonError_LinkFailed,
                                      errorMessage,
                                      nil);
        }
        else
        {
            returnError = PPErrorMake(PPCloudCommonError_Unknown,
                                      @"unknown error",
                                      nil);
        }
    }
    while (0);
    
    //////////////////////////////////////////////////
    
    if(isHandled==YES)
    {
        if(result==YES)
        {
            if([self.delegate respondsToSelector:@selector(ppDropboxOperationLinkSuccess:)]==YES)
            {
                [self.delegate ppDropboxOperationLinkSuccess:self];
            }
        }
        else
        {
            if([self.delegate respondsToSelector:@selector(ppDropboxOperation:linkFailedWithError:)]==YES)
            {
                [self.delegate ppDropboxOperation:self linkFailedWithError:returnError];
            }
        }
    }
    
    [authResult release];
    [self completion];

    return isHandled;
}


@end
