//
//  PPDropboxOperation_Copy.m
//  
//
//  Created by Mike on 13-3-14.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPDropboxOperation_Copy.h"

@implementation PPDropboxOperation_Copy

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize fromPath    = fromPath_;
@synthesize toPath      = toPath_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [fromPath_ release];
    [toPath_ release];
	
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

//================================================================================
//
//================================================================================
- (void)main
{
    @autoreleasepool
    {
        NSError *returnError = nil;
        
        do
        {
            if(self.fromPath==nil || self.toPath==nil)
            {
                returnError = PPErrorParameterInvalidity(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            DBFILESUserAuthRoutes *fileRoutes = [DBClientsManager authorizedClient].filesRoutes;
            
            if(fileRoutes==nil)
            {
                returnError  = PPErrorParameterInvalidity(nil);
                break;
            }
            
            //////////////////////////////////////////////////
            
            __block typeof(self) blockself = self;
            
            [[[fileRoutes dCopyV2:self.fromPath
                           toPath:self.toPath] setResponseBlock:^(DBFILESRelocationResult * _Nullable result, DBFILESRelocationError * _Nullable routeError, DBRequestError * _Nullable networkError) {
                if(result!=nil)
                {
                    if([blockself.delegate respondsToSelector:@selector(ppDropboxOperation:copiedPath:to:)]==YES)
                    {
                        [blockself.delegate ppDropboxOperation:blockself
                                                    copiedPath:blockself.toPath
                                                            to:result.metadata];
                    }
                }
                else
                {
                    if([blockself.delegate respondsToSelector:@selector(ppDropboxOperation:copyPathFailedWithError:)]==YES)
                    {
                        NSError *convertedError = [blockself convertErrorFromSystemError:networkError];
                        
                        if(convertedError==nil)
                        {
                            if(routeError.tag==DBFILESRelocationErrorDuplicatedOrNestedPaths)
                            {
                                convertedError = PPErrorMake(PPCloudCommonError_PathAlreadyExist, @"DBFILESUploadErrorPath", nil);
                            }
                            else
                            {
                                NSString *failedReason = [NSString stringWithFormat:@"DBFILESRelocationErrorTag:%td",routeError.tag];
                                
                                convertedError = PPErrorMake(PPCloudCommonError_Unknown,
                                                             failedReason,
                                                             nil);
                            }
                        }
                        
                        [blockself.delegate ppDropboxOperation:blockself
                                       copyPathFailedWithError:convertedError];
                    }
                }
                
                //////////////////////////////////////////////////
                
                [blockself completion];
            }] setProgressBlock:^(int64_t bytesWritten, int64_t totalBytesWritten, int64_t totalBytesExpectedToWrite) {
                
            }];
           
            
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(returnError!=nil)
        {
            if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppDropboxOperation:copyPathFailedWithError:)]==YES)
            {
                [self.delegate ppDropboxOperation:self copyPathFailedWithError:returnError];
            }
            
            [self completion];
        }
    }
}
@end
