//
//  PPCloudController.m
//
//
//  Created by Mike on 13-3-11.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPCloudController.h"
#import "PPCloudOperation.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static PPCloudController *sharedCloudController = nil;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudController()

@interface PPCloudController()
@property(nonatomic,readonly)   NSMutableDictionary *cloudDictionary;
@property(nonatomic,readonly)   NSOperationQueue    *operationQueue;
- (PPCloud *)ppCloudForCloudClass:(Class)cloudClass;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPCloudController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize cloudDictionary     = cloudDictionary_;
@synthesize operationQueue      = operationQueue_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (id)init
{
    id object = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if((self=[super init]))
    {
        do
        {
            cloudDictionary_ = [[NSMutableDictionary alloc] init];
            if(self.cloudDictionary==nil)
            {
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operationQueue_ = [[NSOperationQueue alloc] init];
            if(self.operationQueue==nil)
            {
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            [self.operationQueue setMaxConcurrentOperationCount:1];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            object = self;
            
        }while(0);
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(object!=self)
    {
        [self release];
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    return object;
}

- (void)dealloc
{
    [operationQueue_ release];
    [cloudDictionary_ release];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    [super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Methods

- (PPCloud *)ppCloudForCloudClass:(Class)cloudClass
{
    PPCloud *ppCloud = nil;
    
    do
    {
        if(cloudClass==Nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        ppCloud = [self.cloudDictionary objectForKey:NSStringFromClass(cloudClass)];
        
        if(ppCloud==nil && [cloudClass isSubclassOfClass:[PPCloud class]]==YES)
        {
            ppCloud = [[cloudClass alloc] initWithOperationQueue:self.operationQueue];
            
            if(ppCloud!=nil)
            {
                [self.cloudDictionary setObject:ppCloud forKey:NSStringFromClass(cloudClass)];
                
                [ppCloud autorelease];
            }
        }
        
    }while(0);
    
    return ppCloud;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (BOOL)handleOpenURL:(NSURL *)url
{
    BOOL result = NO;
    
    NSArray *clouds = self.cloudDictionary.allValues;
    
    for(id cloud in clouds)
    {
        if([cloud respondsToSelector:@selector(handleOpenURL:)]==YES)
        {
            result = [cloud handleOpenURL:url];
            
            if(result==YES)
            {
                break;
            }
        }
    }
    
    return result;
}

- (BOOL)isLinkedWithCloudClass:(Class)cloudClass
{
    BOOL isLinked = NO;
    
    do
    {
        PPCloud *ppCloud = [self ppCloudForCloudClass:cloudClass];
        
        if(ppCloud==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        isLinked = [ppCloud isLinked];
        
    }while(0);
    
    return isLinked;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Protocol Methods

- (BOOL)copyFrom:(NSString*)fromPath toPath:(NSString *)toPath delegate:(id<PPCloudDelegate_Copy>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    BOOL result = NO;
    
    do
    {
        if([cloudClass conformsToProtocol:@protocol(PPCloudProtocol_Copy)]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPCloud<PPCloudProtocol_Copy> *ppCloud = (PPCloud<PPCloudProtocol_Copy> *)[self ppCloudForCloudClass:cloudClass];
        
        if(ppCloud==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        result = [ppCloud copyFrom:fromPath
                            toPath:toPath
                          delegate:delegate
                          userInfo:userInfo];
        
    }while(0);
    
    return result;
}

- (BOOL)createFolder:(NSString *)createFolder delegate:(id<PPCloudDelegate_CreateFolder>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    BOOL result = NO;
    
    do
    {
        if([cloudClass conformsToProtocol:@protocol(PPCloudProtocol_CreateFolder)]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPCloud<PPCloudProtocol_CreateFolder> *ppCloud = (PPCloud<PPCloudProtocol_CreateFolder> *)[self ppCloudForCloudClass:cloudClass];
        
        if(ppCloud==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        result = [ppCloud createFolder:createFolder
                              delegate:delegate
                              userInfo:userInfo];
        
    }while(0);
    
    return result;
}

- (BOOL)deletePath:(NSString *)deletePath delegate:(id<PPCloudDelegate_Delete>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    BOOL result = NO;
    
    do
    {
        if([cloudClass conformsToProtocol:@protocol(PPCloudProtocol_Delete)]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPCloud<PPCloudProtocol_Delete> *ppCloud = (PPCloud<PPCloudProtocol_Delete> *)[self ppCloudForCloudClass:cloudClass];
        
        if(ppCloud==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        result = [ppCloud deletePath:deletePath
                            delegate:delegate
                            userInfo:userInfo];
        
    }while(0);
    
    return result;
}

- (BOOL)linkFromController:(CPCLViewController *)viewcontroller delegate:(id<PPCloudDelegate_Link>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    BOOL result = NO;
    
    do
    {
        if([cloudClass conformsToProtocol:@protocol(PPCloudProtocol_Link)]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPCloud<PPCloudProtocol_Link> *ppCloud = (PPCloud<PPCloudProtocol_Link> *)[self ppCloudForCloudClass:cloudClass];
        
        if(ppCloud==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        // !! 強制中斷之前的登入操作
        [self cancelLinkOperation];
        
        result = [ppCloud linkFromController:viewcontroller
                                    delegate:delegate
                                    userInfo:userInfo];
        
    }while(0);
    
    return result;
}

- (BOOL)loadAccountInfoWithDelegate:(id<PPCloudDelegate_LoadAccountInfo>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    BOOL result = NO;
    
    do
    {
        if([cloudClass conformsToProtocol:@protocol(PPCloudProtocol_LoadAccountInfo)]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPCloud<PPCloudProtocol_LoadAccountInfo> *ppCloud = (PPCloud<PPCloudProtocol_LoadAccountInfo> *)[self ppCloudForCloudClass:cloudClass];
        
        if(ppCloud==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        result = [ppCloud loadAccountInfoWithDelegate:delegate
                                             userInfo:userInfo];
        
    }while(0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (BOOL)loadFileFromPath:(NSString *)filePath
                orFileID:(NSString *)fileID
                intoPath:(NSString *)intoPath
                delegate:(id<PPCloudDelegate_LoadFile>)delegate
                userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    BOOL result = NO;
    
    do
    {
        if([cloudClass conformsToProtocol:@protocol(PPCloudProtocol_LoadFile)]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPCloud<PPCloudProtocol_LoadFile> *ppCloud = (PPCloud<PPCloudProtocol_LoadFile> *)[self ppCloudForCloudClass:cloudClass];
        
        if(ppCloud==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        result = [ppCloud loadFileFromPath:filePath
                                  orFileID:fileID
                                  intoPath:intoPath
                                  delegate:delegate
                                  userInfo:userInfo];
        
    }while(0);
    
    return result;
}

- (BOOL)loadMetadata:(NSString *)loadMetadata delegate:(id<PPCloudDelegate_LoadMetadata>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    BOOL result = NO;
    
    do
    {
        if([cloudClass conformsToProtocol:@protocol(PPCloudProtocol_LoadMetadata)]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPCloud<PPCloudProtocol_LoadMetadata> *ppCloud = (PPCloud<PPCloudProtocol_LoadMetadata> *)[self ppCloudForCloudClass:cloudClass];
        
        if(ppCloud==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        result = [ppCloud loadMetadata:loadMetadata
                              delegate:delegate
                              userInfo:userInfo];
        
    }while(0);
    
    return result;
}

- (BOOL)loadThumbnail:(NSString *)loadThumbnail ofSize:(NSString *)size intoPath:(NSString *)intoPath delegate:(id<PPCloudDelegate_LoadThumbnail>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    BOOL result = NO;
    
    do
    {
        if([cloudClass conformsToProtocol:@protocol(PPCloudProtocol_LoadThumbnail)]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPCloud<PPCloudProtocol_LoadThumbnail> *ppCloud = (PPCloud<PPCloudProtocol_LoadThumbnail> *)[self ppCloudForCloudClass:cloudClass];
        
        if(ppCloud==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        result = [ppCloud loadThumbnail:loadThumbnail
                                 ofSize:size
                               intoPath:intoPath
                               delegate:delegate
                               userInfo:userInfo];
        
    }while(0);
    
    return result;
}

- (BOOL)moveFrom:(NSString *)moveFrom toPath:(NSString *)toPath delegate:(id<PPCloudDelegate_Move>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    BOOL result = NO;
    
    do
    {
        if([cloudClass conformsToProtocol:@protocol(PPCloudProtocol_Move)]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPCloud<PPCloudProtocol_Move> *ppCloud = (PPCloud<PPCloudProtocol_Move> *)[self ppCloudForCloudClass:cloudClass];
        
        if(ppCloud==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        result = [ppCloud moveFrom:moveFrom
                            toPath:toPath
                          delegate:delegate
                          userInfo:userInfo];
        
    }while(0);
    
    return result;
}

- (BOOL)unlinkWithDelegate:(id<PPCloudDelegate_Unlink>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    BOOL result = NO;
    
    do
    {
        if([cloudClass conformsToProtocol:@protocol(PPCloudProtocol_Unlink)]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPCloud<PPCloudProtocol_Unlink> *ppCloud = (PPCloud<PPCloudProtocol_Unlink> *)[self ppCloudForCloudClass:cloudClass];
        
        if(ppCloud==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        // !! 強制中斷之前的登入操作
        [self cancelLinkOperation];
        
        result = [ppCloud unlinkWithDelegate:delegate
                                    userInfo:userInfo];
        
    }while(0);
    
    return result;
}

- (BOOL)uploadFile:(NSString *)filename toPath:(NSString *)toPath fromPath:(NSString *)fromPath delegate:(id<PPCloudDelegate_UploadFile>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    BOOL result = NO;
    
    do
    {
        if([cloudClass conformsToProtocol:@protocol(PPCloudProtocol_UploadFile)]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPCloud<PPCloudProtocol_UploadFile> *ppCloud = (PPCloud<PPCloudProtocol_UploadFile> *)[self ppCloudForCloudClass:cloudClass];
        
        if(ppCloud==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        result = [ppCloud uploadFile:filename
                              toPath:toPath
                            fromPath:fromPath
                            delegate:delegate
                            userInfo:userInfo];
        
    }while(0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (BOOL)sharedlinkFile:(NSString *)sharedlinkFile delegate:(id<PPCloudDelegate_Sharedlink>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    BOOL result = NO;
    
    do
    {
        if([cloudClass conformsToProtocol:@protocol(PPCloudProtocol_Sharedlink)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPCloud<PPCloudProtocol_Sharedlink> *ppCloud = (PPCloud<PPCloudProtocol_Sharedlink> *)[self ppCloudForCloudClass:cloudClass];
        if(ppCloud==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        result = [ppCloud sharedlinkFile:sharedlinkFile
                                delegate:delegate
                                userInfo:userInfo];
        
    }while(0);
    
    return result;
}


//================================================================================
// 結束正在處理的登入
//================================================================================
- (void)cancelLinkOperation
{
    //    return ;
    
    NSOperationQueue *operationQueue = nil;// [PPCloudController sharedCloudController]
    
    if([[PPCloudController sharedCloudController] respondsToSelector:@selector(operationQueue)]==YES)
    {
        operationQueue = [[PPCloudController sharedCloudController] performSelector:@selector(operationQueue)];
    }
    
    //////////////////////////////////////////////////
    
    for(PPCloudOperation *operation in operationQueue.operations)
    {
        if([operation isKindOfClass:NSClassFromString(@"PPGoogleDriveOperation_Link")] ||
           [operation isKindOfClass:NSClassFromString(@"PPDropboxOperation_Link")])
        {
            [operation cancel];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)cancelAllOperations
{
    [self.operationQueue cancelAllOperations];
    
    while([self.operationQueue operationCount]>0)
    {
        [NSThread sleepForTimeInterval:0.01];
    }
}


//================================================================================
//
//================================================================================
- (void)setOperationDelegate:(id)operationDelegate
{
    [self.operationQueue setSuspended:YES];
    
    for(PPCloudOperation *operation in self.operationQueue.operations)
    {
        operation.delegate = operationDelegate;
    }
    
    [self.operationQueue setSuspended:NO];
}


//================================================================================
//
//================================================================================
- (NSUInteger)operationCount
{
    return [[[self operationQueue] operations] count];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (PPCloudController *)sharedCloudController
{
    return sharedCloudController;
}

+ (void)setSharedCloudController:(PPCloudController *)cloudController
{
    [cloudController retain];
    [sharedCloudController release];
    sharedCloudController = cloudController;
}

+ (void)setParameter:(id)parameter forKey:(NSString *)key
{
    [PPCloud setParameter:parameter forKey:key];
}

+ (BOOL)handleOpenURL:(NSURL *)url
{
    return [[PPCloudController sharedCloudController] handleOpenURL:url];
}

+ (BOOL)isLinkedWithCloudClass:(Class)cloudClass
{
    return [[PPCloudController sharedCloudController] isLinkedWithCloudClass:cloudClass];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Protocol Methods

+ (BOOL)copyFrom:(NSString*)fromPath toPath:(NSString *)toPath delegate:(id<PPCloudDelegate_Copy>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    return [[PPCloudController sharedCloudController] copyFrom:fromPath
                                                        toPath:toPath
                                                      delegate:delegate
                                                      userInfo:userInfo
                                                    cloudClass:cloudClass];
}

+ (BOOL)createFolder:(NSString *)createFolder delegate:(id<PPCloudDelegate_CreateFolder>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    return [[PPCloudController sharedCloudController] createFolder:createFolder
                                                          delegate:delegate
                                                          userInfo:userInfo
                                                        cloudClass:cloudClass];
}

+ (BOOL)deletePath:(NSString *)deletePath delegate:(id<PPCloudDelegate_Delete>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    return [[PPCloudController sharedCloudController] deletePath:deletePath
                                                        delegate:delegate
                                                        userInfo:userInfo
                                                      cloudClass:cloudClass];
}

+ (BOOL)linkFromController:(CPCLViewController *)viewcontroller delegate:(id<PPCloudDelegate_Link>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    return [[PPCloudController sharedCloudController] linkFromController:viewcontroller
                                                                delegate:delegate
                                                                userInfo:userInfo
                                                              cloudClass:cloudClass];
}

+ (BOOL)loadAccountInfoWithDelegate:(id<PPCloudDelegate_LoadAccountInfo>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    return [[PPCloudController sharedCloudController] loadAccountInfoWithDelegate:delegate
                                                                         userInfo:userInfo
                                                                       cloudClass:cloudClass];
}

+ (BOOL)loadFileFromPath:(NSString *)filePath
                orFileID:(NSString *)fileID
                intoPath:(NSString *)intoPath
                delegate:(id<PPCloudDelegate_LoadFile>)delegate
                userInfo:(id)userInfo cloudClass:(Class)cloudClass;
{
    return [[PPCloudController sharedCloudController] loadFileFromPath:filePath
                                                              orFileID:fileID
                                                              intoPath:intoPath
                                                              delegate:delegate
                                                              userInfo:userInfo
                                                            cloudClass:cloudClass];
}

+ (BOOL)loadMetadata:(NSString *)loadMetadata delegate:(id<PPCloudDelegate_LoadMetadata>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    return [[PPCloudController sharedCloudController] loadMetadata:loadMetadata
                                                          delegate:delegate
                                                          userInfo:userInfo
                                                        cloudClass:cloudClass];
}

+ (BOOL)loadThumbnail:(NSString *)loadThumbnail ofSize:(NSString *)size intoPath:(NSString *)intoPath delegate:(id<PPCloudDelegate_LoadThumbnail>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    return [[PPCloudController sharedCloudController] loadThumbnail:loadThumbnail
                                                             ofSize:size
                                                           intoPath:intoPath
                                                           delegate:delegate
                                                           userInfo:userInfo
                                                         cloudClass:cloudClass];
}

+ (BOOL)moveFrom:(NSString *)moveFrom toPath:(NSString *)toPath delegate:(id<PPCloudDelegate_Move>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    return [[PPCloudController sharedCloudController] moveFrom:moveFrom
                                                        toPath:toPath
                                                      delegate:delegate
                                                      userInfo:userInfo
                                                    cloudClass:cloudClass];
}

+ (BOOL)unlinkWithDelegate:(id<PPCloudDelegate_Unlink>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    return [[PPCloudController sharedCloudController] unlinkWithDelegate:delegate
                                                                userInfo:userInfo
                                                              cloudClass:cloudClass];
}

+ (BOOL)uploadFile:(NSString *)filename toPath:(NSString *)toPath fromPath:(NSString *)fromPath delegate:(id<PPCloudDelegate_UploadFile>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    return [[PPCloudController sharedCloudController] uploadFile:filename
                                                          toPath:toPath
                                                        fromPath:fromPath
                                                        delegate:delegate
                                                        userInfo:userInfo
                                                      cloudClass:cloudClass];
}


//================================================================================
//
//================================================================================
+ (BOOL)sharedlinkFile:(NSString *)sharedlinkFile delegate:(id<PPCloudDelegate_Sharedlink>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass
{
    return [[PPCloudController sharedCloudController] sharedlinkFile:sharedlinkFile
                                                            delegate:delegate
                                                            userInfo:userInfo
                                                          cloudClass:cloudClass];
}


//================================================================================
//
//================================================================================
+ (void)cancelAllOperations
{
    [[PPCloudController sharedCloudController] cancelAllOperations];
}


//================================================================================
//
//================================================================================
+ (void)setOperationDelegate:(id)operationDelegate
{
    [[PPCloudController sharedCloudController] setOperationDelegate:operationDelegate];
}


//================================================================================
//
//================================================================================
+ (NSUInteger)operationCount
{
    return [[PPCloudController sharedCloudController] operationCount];
}
@end
